/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.util.CtrlPanelArtistUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class CtrlImageUtilities
implements SwingConstants {
    private static final Logger logger = LogUtil.getPackageLogger(CtrlImageUtilities.class);
    private static final String NOTFOUND_ICON = "com/kingdee/cosmic/ctrl/swing/util/notfdicon.gif";
    public static final Component producer = new Component(){
        private static final long serialVersionUID = 2496566665220241432L;
    };
    private static HashMap cacheImage = new HashMap();
    public static final int PAINT_NORMAL = 0;
    public static final int PAINT_STRETCH = 1;
    public static final int PAINT_TILE = 2;
    public static final int PAINT_CENTERED = 3;
    public static final int PAINT_NONE = 5;
    public static final int TRANSPARENT_RED = 255;
    public static final int TRANSPARENT_GREEN = 0;
    public static final int TRANSPARENT_BLUE = 255;
    public static final int TRANSPARENT_TO_REMOVE = new Color(255, 0, 255).getRGB();
    public static final int TRANSPARENT_PIXEL = new Color(255, 0, 0, 0).getRGB();
    private static SelfImageIO selfImage = new SelfImageIO();

    public static Color decodeColor(String s) {
        int val = 0;
        try {
            val = s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : (s.startsWith("#") ? Integer.parseInt(s.substring(1), 16) : (s.startsWith("0") && s.length() > 1 ? Integer.parseInt(s.substring(1), 8) : Integer.parseInt(s, 10)));
            return new Color(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static ImageIcon getImageIconFromDefaults(ImageIcon image, String imaKey) {
        if (image == null) {
            return (ImageIcon)UIManager.get(imaKey);
        }
        return image;
    }

    public static ImageIcon getDisabledIcon(ImageIcon anIcon) {
        return CtrlImageUtilities.getDisabledIcon(anIcon.getImage());
    }

    public static ImageIcon getDisabledIcon(Image anImage) {
        return new ImageIcon(CtrlImageUtilities.getDisabledImage(anImage));
    }

    public static Image getDisabledImage(Image anImage) {
        if (anImage == null) {
            return null;
        }
        return CtrlImageUtilities.filterImage(new GrayFilter(true, 65), anImage);
    }

    public static ImageIcon getNotFoundIcon() {
        return CtrlImageUtilities.getRootImageIcon(NOTFOUND_ICON);
    }

    public static ImageIcon getDisabledIcon(ImageIcon anIcon, int count) {
        Image anImage = anIcon.getImage();
        if (anImage != null) {
            return new ImageIcon(CtrlImageUtilities.filterImage(new GrayFilter(true, count), anImage));
        }
        return null;
    }

    public static Image filterImage(RGBImageFilter filter, Image image) {
        return producer.createImage(new FilteredImageSource(image.getSource(), filter));
    }

    public static Image rotateImage(Image anImage) {
        int w = anImage.getWidth(null);
        int h = anImage.getHeight(null);
        int[] pixels = new int[w * h];
        PixelGrabber pixel = new PixelGrabber(anImage, 0, 0, w, h, pixels, 0, w);
        try {
            pixel.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] rot = new int[h * w];
        int pos = 0;
        for (int i = w; i > 0; --i) {
            for (int j = 0; j < h; ++j) {
                rot[pos] = pixels[i + w * j - 1];
                ++pos;
            }
        }
        return CtrlImageUtilities.convertBytesToImage(producer, rot, h, w);
    }

    public static Image rotateImage(Image anImage, double angle) {
        int width = anImage.getWidth(null);
        int height = anImage.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber pixel = new PixelGrabber(anImage, 0, 0, width, height, pixels, 0, width);
        try {
            pixel.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] pixels2 = new int[width * height];
        int i = 0;
        double radians = -angle / 57.29577951308232;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int centerX = width >> 1;
        int centerY = height >> 1;
        for (int oldY = -centerY; oldY < centerY; ++oldY) {
            for (int oldX = -centerX; oldX < centerX; ++oldX) {
                int newX = centerX + (int)((double)oldX * cos - (double)oldY * sin);
                int newY = centerY + (int)((double)oldX * sin + (double)oldY * cos);
                pixels2[i++] = newX > 0 && newX < width && newY > 0 && newY < height ? pixels[width * newY + newX] : pixels[0];
            }
        }
        return producer.createImage(new MemoryImageSource(width, height, pixels2, 0, width));
    }

    public static Image convertBytesToImage(Component c, int[] pixels, int w, int h) {
        return c.createImage(new MemoryImageSource(w, h, pixels, 0, w));
    }

    public static void paint(Component c, Graphics g, Image image) {
        CtrlImageUtilities.paint(c, g, image, true);
    }

    public static void paint(Component c, Graphics g, Image image, int paintType) {
        CtrlImageUtilities.paint(c, g, image, true, paintType);
    }

    public static void paint(Component c, Graphics g, Image image, boolean alignWithParent) {
        CtrlImageUtilities.paint(c, g, image, alignWithParent, 1);
    }

    public static void paint(Component c, Graphics g, Image image, boolean alignWithParent, int paintType) {
        CtrlImageUtilities.paint(c, g, image, 0, 0, ((JComponent)c).getWidth(), ((JComponent)c).getHeight(), alignWithParent, paintType);
    }

    public static void paint(Component c, Graphics g, Image image, int x, int y, int width, int height) {
        CtrlImageUtilities.paint(c, g, image, x, y, width, height, true, 1);
    }

    public static void paint(Component c, Graphics g, Image image, int x, int y, int width, int height, int paintType) {
        CtrlImageUtilities.paint(c, g, image, x, y, width, height, true, paintType);
    }

    public static void paint(Component c, Graphics g, Image image, int x, int y, int width, int height, boolean alignWithParent, int paintType) {
        if (image == null) {
            return;
        }
        switch (paintType) {
            case 0: {
                g.drawImage(image, x, y, c);
                break;
            }
            case 1: {
                g.drawImage(image, x, y, width, height, c);
                break;
            }
            case 2: {
                CtrlImageUtilities.paintTile(c, g, image, x, y, width, height, alignWithParent);
                break;
            }
            case 3: {
                g.drawImage(image, (width - image.getWidth(c)) / 2, (height - image.getHeight(c)) / 2, c);
                break;
            }
        }
    }

    public static void paintTile(Component component, Graphics g, Image image, int x, int y, int width, int height) {
        CtrlImageUtilities.paintTile(component, g, image, x, y, width, height, true);
    }

    public static Image transparent(Image image) {
        return CtrlImageUtilities.toBufferedImage(image);
    }

    public static Image grab(Image image, int x, int y, int width, int height) {
        if (width * height <= 0) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getSubimage(x, y, width, height);
        }
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, x, y, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int pixel = pixels[j * width + i];
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                if (red != 255 || green != 0 || blue != 255) continue;
                pixels[j * width + i] = TRANSPARENT_PIXEL;
            }
        }
        Image newImage = producer.createImage(new MemoryImageSource(width, height, pixels, 0, width));
        return CtrlImageUtilities.toBufferedImage(newImage);
    }

    public static Image buildTile(Image image, int factor) {
        int width = image.getWidth(producer);
        int height = image.getHeight(producer);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        int[] zoomed = new int[pixels.length * factor];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < factor; ++j) {
                System.arraycopy(pixels, width * i, zoomed, width * factor * i + width * j, width);
            }
        }
        pixels = zoomed;
        int[] zoomed2 = new int[pixels.length * factor];
        for (int i = 0; i < factor; ++i) {
            System.arraycopy(pixels, 0, zoomed2, i * pixels.length, pixels.length);
        }
        return producer.createImage(new MemoryImageSource(width * factor, height * factor, zoomed2, 0, width * factor));
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        DataBuffer db = bufferedImage.getRaster().getDataBuffer();
        int c = db.getSize();
        for (int i = 0; i < c; ++i) {
            if (db.getElem(i) != TRANSPARENT_TO_REMOVE) continue;
            db.setElem(i, TRANSPARENT_PIXEL);
        }
        return bufferedImage;
    }

    public static Image flipHorizontally(Image image) {
        if (image == null) {
            return null;
        }
        AffineTransform transform = CtrlPanelArtistUtilities.getYFlipTransform(image.getHeight(producer));
        AffineTransformOp operation = new AffineTransformOp(transform, 2);
        return operation.filter((BufferedImage)image, null);
    }

    public static Image rotateLeft(Image anImage) {
        if (anImage == null) {
            return null;
        }
        AffineTransform transform = CtrlPanelArtistUtilities.getCCWRotateTransform(anImage.getWidth(producer), anImage.getHeight(producer));
        AffineTransformOp operation = new AffineTransformOp(transform, 2);
        return CtrlImageUtilities.transparent(operation.filter((BufferedImage)anImage, null));
    }

    public static Image rotateRight(Image anImage) {
        if (anImage == null) {
            return null;
        }
        AffineTransform transform = CtrlPanelArtistUtilities.getCWRotateTransform(anImage.getWidth(producer), anImage.getHeight(producer));
        AffineTransformOp operation = new AffineTransformOp(transform, 2);
        return CtrlImageUtilities.transparent(operation.filter((BufferedImage)anImage, null));
    }

    private static void paintTile(Component component, Graphics g, Image image, int x, int y, int width, int height, boolean alignWithParent) {
        if (image == null) {
            return;
        }
        int dx = image.getWidth(null);
        int dy = image.getHeight(null);
        if (dx <= 0 || dy <= 0) {
            return;
        }
        int xoff = 0;
        int yoff = 0;
        Shape oldClip = g.getClip();
        if (oldClip.contains(x, y, width, height) || width <= 0 || height <= 0) {
            g.setClip(x, y, width, height);
        } else if (oldClip.intersects(x, y, width, height)) {
            Rectangle currentRect = oldClip.getBounds();
            g.setClip(SwingUtilities.computeIntersection(x, y, width, height, (Rectangle)currentRect.clone()));
        }
        if (alignWithParent) {
            xoff = component.getLocation().x;
            yoff = component.getLocation().y;
            for (Container parent = component.getParent(); parent != null && !(parent instanceof JInternalFrame); parent = parent.getParent()) {
                if (parent.getParent() == null) continue;
                xoff += parent.getLocation().x;
                yoff += parent.getLocation().y;
            }
            x -= xoff % dx;
            y -= yoff % dy;
        }
        int maxX = x + width + dx;
        int maxY = y + height + dy;
        while (x <= maxX) {
            for (int j = y; j <= maxY; j += dy) {
                g.drawImage(image, x, j, component);
            }
            x += dx;
        }
        g.setClip(oldClip);
    }

    public static void drawGradient(Graphics g, Color color1, Color color2, Rectangle rect, boolean isVertical) {
        if (isVertical) {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(0.0f, (float)rect.getY(), color1, 0.0f, (float)(rect.getHeight() + rect.getY()), color2);
            g2D.setPaint(gradient);
            g2D.fill(rect);
        } else {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint((float)rect.getX(), 0.0f, color1, (float)(rect.getWidth() + rect.getX()), 0.0f, color2);
            g2D.setPaint(gradient);
            g2D.fill(rect);
        }
    }

    public static void drawTexture(Graphics g, Rectangle rect, BufferedImage txtr) {
        Graphics2D g2D = (Graphics2D)g;
        TexturePaint txtrPaint = new TexturePaint(txtr, new Rectangle(0, 0, txtr.getWidth(), txtr.getHeight()));
        g2D.setPaint(txtrPaint);
        g2D.fill(rect);
    }

    public static void drawGradient(Graphics g, float x1, float y1, Color color1, float x2, float y2, Color color2, Shape s, boolean isVertical) {
        if (isVertical) {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(0.0f, y1, color1, 0.0f, y2, color2);
            g2D.setPaint(gradient);
            g2D.fill(s);
        } else {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(x1, 0.0f, color1, x2, 0.0f, color2);
            g2D.setPaint(gradient);
            g2D.fill(s);
        }
    }

    public static ImageIcon getCurrentDirectoryImageIcon(Class c, String imagePath) {
        if (imagePath == null) {
            return null;
        }
        WeakReference weakRef = (WeakReference)cacheImage.get(imagePath = imagePath.trim());
        if (weakRef != null) {
            return (ImageIcon)weakRef.get();
        }
        URL url = null;
        url = c != null ? c.getResource(imagePath) : selfImage.getClass().getResource(imagePath);
        if (url != null) {
            ImageIcon imgIcon = new ImageIcon(url);
            WeakReference<ImageIcon> weak = new WeakReference<ImageIcon>(imgIcon);
            cacheImage.put(imagePath, weak);
            return imgIcon;
        }
        return null;
    }

    public static ImageIcon getRootImageIcon(String imagePath) {
        if (imagePath == null) {
            return null;
        }
        WeakReference weakRef = (WeakReference)cacheImage.get(imagePath);
        if (weakRef != null) {
            return (ImageIcon)weakRef.get();
        }
        URL url = selfImage.getClass().getClassLoader().getResource(imagePath);
        if (url != null) {
            ImageIcon imgIcon = new ImageIcon(url);
            WeakReference<ImageIcon> weak = new WeakReference<ImageIcon>(imgIcon);
            cacheImage.put(imagePath, weak);
            return imgIcon;
        }
        return null;
    }

    public static Icon createDisableIcon(Icon icon) {
        Image img = ((ImageIcon)icon).getImage();
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage temp = new BufferedImage(width, height, 2);
        BufferedImage gray = new BufferedImage(width, height, 2);
        Graphics2D srcG = temp.createGraphics();
        srcG.drawImage(img, 0, 0, null);
        ColorSpace graySpace = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(graySpace, null);
        op.filter(temp, gray);
        return new ImageIcon(gray);
    }

    public static Color createDisableColor(Color color) {
        int rgb = color.getRGB();
        GrayFilter filter = new GrayFilter(true, 50);
        int grayRGB = filter.filterRGB(0, 0, rgb);
        Color disableColor = new Color(grayRGB);
        return disableColor;
    }

    static class SelfImageIO {
        SelfImageIO() {
        }
    }
}

