/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class GraphicsKit {
    private static final Logger logger = LogUtil.getPackageLogger(GraphicsKit.class);
    private static BufferedImage image = null;

    public static Graphics getComponentGraphics(Component comp) {
        Graphics2D g = null;
        BufferedImage img = null;
        if (comp != null) {
            Dimension d = comp.getSize();
            if (d.getWidth() <= 0.0 || d.getHeight() <= 0.0) {
                comp.setSize(comp.getPreferredSize());
                d = comp.getPreferredSize();
            }
            img = new BufferedImage(d.width, d.height, 2);
            g = img.createGraphics();
        }
        image = img;
        return g;
    }

    public static void exportImage(String imageTitle, String formatName) {
        if (image != null) {
            String fn = imageTitle + "." + formatName;
            try (FileOutputStream os = new FileOutputStream(FilenameUtils.normalize((String)fn));){
                ImageIO.write((RenderedImage)image, formatName, os);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"err", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }
}

