/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.util;

import com.kingdee.cosmic.ctrl.swing.BasicFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.DateTimeEditor;
import com.kingdee.cosmic.ctrl.swing.DefaultTextField;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDatePicker;
import com.kingdee.cosmic.ctrl.swing.KDMultiLangBox;
import com.kingdee.cosmic.ctrl.swing.KDPromptBox;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.util.TextComponentUtilitiesResource;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class TextComponentUtilities {
    private static String getReadForbitItem() {
        return TextComponentUtilitiesResource.getLocaleText(TextComponentUtilitiesResource.READ_FORBIT_ITEM);
    }

    public static boolean setEnabled(IKDTextComponent comp, boolean enabled) {
        if (TextComponentUtilities.isCheckAuthority(comp)) {
            if (comp.getAccessAuthority() == 0) {
                ((JComponent)((Object)comp)).putClientProperty("originalEnabled", enabled);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static boolean isEnabled(IKDTextComponent comp) {
        Boolean enabled = (Boolean)((JComponent)((Object)comp)).getClientProperty("originalEnabled");
        return enabled;
    }

    public static boolean setEditable(IKDTextComponent comp, boolean editable) {
        if (TextComponentUtilities.isCheckAuthority(comp)) {
            if (comp.getAccessAuthority() == 0) {
                ((JComponent)((Object)comp)).putClientProperty("originalEditable", editable);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static boolean isEditable(IKDTextComponent comp) {
        Boolean editable = (Boolean)((JComponent)((Object)comp)).getClientProperty("originalEditable");
        return editable;
    }

    public static void setRequired(IKDTextComponent comp, boolean required) {
    }

    public static Object getData(IKDTextComponent comp) {
        return ((JComponent)((Object)comp)).getClientProperty("originalData");
    }

    public static boolean setData(IKDTextComponent comp, Object data) {
        if (TextComponentUtilities.isCheckAuthority(comp)) {
            ((JComponent)((Object)comp)).putClientProperty("originalData", data);
            return TextComponentUtilities.getAccessAuthority(comp) != 2 || TextComponentUtilities.getAccessAuthority(comp) != 1;
        }
        return true;
    }

    public static void setAccessAuthority(IKDTextComponent comp, int accessAuthority) {
        if (accessAuthority == 0) {
            TextComponentUtilities.storeOriginalData(comp);
            ((JComponent)((Object)comp)).putClientProperty("accessAuthority", accessAuthority);
            TextComponentUtilities.toOriginal(comp);
        } else if (accessAuthority == 1) {
            if (TextComponentUtilities.getAccessAuthority(comp) != 2) {
                TextComponentUtilities.storeOriginalData(comp);
                ((JComponent)((Object)comp)).putClientProperty("accessAuthority", accessAuthority);
                TextComponentUtilities.toReadOnly(comp);
            }
        } else if (accessAuthority == 2) {
            TextComponentUtilities.storeOriginalData(comp);
            ((JComponent)((Object)comp)).putClientProperty("accessAuthority", accessAuthority);
            TextComponentUtilities.toReadFobit(comp);
        }
    }

    public static int getAccessAuthority(IKDTextComponent comp) {
        Integer accessAuthority = (Integer)((JComponent)((Object)comp)).getClientProperty("accessAuthority");
        if (accessAuthority != null) {
            return accessAuthority;
        }
        return 0;
    }

    public static void storeOriginalData(IKDTextComponent comp) {
        comp.setEnabled(comp.isEnabled());
        comp.setEditable(comp.isEditable());
        Object data = null;
        if (comp instanceof KDTextField) {
            KDTextField tf = (KDTextField)comp;
            data = tf.getText();
        } else if (comp instanceof KDTextArea) {
            KDTextArea ta = (KDTextArea)comp;
            data = ta.getText();
        } else if (comp instanceof BasicFormattedTextField) {
            BasicFormattedTextField bftf = (BasicFormattedTextField)comp;
            data = bftf.getValue();
        } else if (comp instanceof KDPromptBox) {
            KDPromptBox pb = (KDPromptBox)comp;
            data = pb.getValue();
        } else if (comp instanceof KDComboBox) {
            KDComboBox combo = (KDComboBox)comp;
            data = combo.getSelectedItem();
        } else if (comp instanceof KDMultiLangBox) {
            KDMultiLangBox lBox = (KDMultiLangBox)comp;
            data = lBox.getSelectedItem();
        } else if (comp instanceof KDSpinner) {
            KDSpinner spinner = (KDSpinner)comp;
            data = spinner.getModel().getValue();
        } else if (comp instanceof KDDatePicker) {
            KDDatePicker dp = (KDDatePicker)comp;
            data = dp.getEditor().getText();
        }
        TextComponentUtilities.setData(comp, data);
    }

    private static void toOriginal(IKDTextComponent comp) {
        boolean enabled = TextComponentUtilities.isEnabled(comp);
        boolean editable = TextComponentUtilities.isEditable(comp);
        comp.setEditable(editable);
        comp.setEnabled(enabled);
        if (comp instanceof KDTextField) {
            String data = (String)TextComponentUtilities.getData(comp);
            ((KDTextField)comp).setText(data);
            ((KDTextField)comp).setEditable(true);
        } else if (comp instanceof KDTextArea) {
            String data = (String)TextComponentUtilities.getData(comp);
            ((KDTextArea)comp).setText(data);
            ((KDTextArea)comp).setEditable(true);
        } else if (comp instanceof BasicFormattedTextField) {
            Object data = TextComponentUtilities.getData(comp);
            ((BasicFormattedTextField)comp).setValue(data);
        } else if (comp instanceof KDPromptBox) {
            Object data = TextComponentUtilities.getData(comp);
            ((KDPromptBox)comp).setValue(data);
            ((KDPromptBox)comp).setReadOnly(false);
            ((IKDTextComponent)((Object)((KDPromptBox)comp).getEditor())).setAccessAuthority(0);
            ((KDPromptBox)comp).setDirty(false);
        } else if (comp instanceof KDComboBox) {
            Object data = TextComponentUtilities.getData(comp);
            ((KDComboBox)comp).removeItem(TextComponentUtilities.getReadForbitItem());
            ((KDComboBox)comp).setSelectedItem(data);
            ((KDComboBox)comp).setReadOnly(false);
            ((KDComboBox)comp).setKeySelectionManager(null);
        } else if (comp instanceof KDMultiLangBox) {
            KDMultiLangBox lBox = (KDMultiLangBox)comp;
            TextComponentUtilities.toOriginal((IKDTextComponent)((Object)lBox.getEditorComponent()));
        } else if (comp instanceof KDSpinner) {
            Object data = TextComponentUtilities.getData(comp);
            KDSpinner spinner = (KDSpinner)comp;
            if (spinner.getEditor() instanceof KDSpinner.DefaultNumberEditor) {
                KDSpinner.DefaultNumberEditor editor = (KDSpinner.DefaultNumberEditor)spinner.getEditor();
                JFormattedTextField ftf = editor.getTextField();
                spinner.setEditorUnFiltered(false);
                ftf.setText(data.toString());
            }
            ((JSpinner.DefaultEditor)((KDSpinner)comp).getEditor()).getTextField().putClientProperty("promptbox", null);
            ((JSpinner.DefaultEditor)((KDSpinner)comp).getEditor()).getTextField().putClientProperty("access", null);
        } else if (comp instanceof KDDatePicker) {
            String data = (String)TextComponentUtilities.getData(comp);
            DateTimeEditor editor = ((KDDatePicker)comp).getEditor();
            if (editor.getEditorComponent() instanceof JTextField) {
                if (((KDDatePicker)comp).getValue() == null) {
                    ((JTextField)editor.getEditorComponent()).setText(null);
                } else {
                    ((JTextField)editor.getEditorComponent()).setText(data);
                }
            }
            ((BasicFormattedTextField)((KDDatePicker)comp).getEditor().getEditorComponent()).setAccessAuthority(0);
        }
    }

    private static void toReadOnly(IKDTextComponent comp) {
        TextComponentUtilities.setCheckAuthority(comp, false);
        if (comp instanceof KDTextField || comp instanceof KDTextArea || comp instanceof BasicFormattedTextField) {
            comp.setEditable(false);
        } else if (comp instanceof KDPromptBox) {
            ((KDPromptBox)comp).setReadOnly(true);
            ((IKDTextComponent)((Object)((KDPromptBox)comp).getEditor())).setAccessAuthority(1);
        } else if (comp instanceof KDComboBox) {
            comp.setEditable(false);
            ((KDComboBox)comp).setReadOnly(true);
            ((KDComboBox)comp).setKeySelectionManager(new JComboBox.KeySelectionManager(){

                public int selectionForKey(char aKey, ComboBoxModel aModel) {
                    return -1;
                }
            });
        } else if (comp instanceof KDMultiLangBox) {
            comp.setEditable(false);
        } else if (comp instanceof KDSpinner) {
            comp.setEnabled(false);
            ((JSpinner.DefaultEditor)((KDSpinner)comp).getEditor()).getTextField().putClientProperty("spinner", Boolean.TRUE);
            ((JSpinner.DefaultEditor)((KDSpinner)comp).getEditor()).getTextField().putClientProperty("access", 1);
        } else if (comp instanceof KDDatePicker) {
            ((BasicFormattedTextField)((KDDatePicker)comp).getEditor().getEditorComponent()).setAccessAuthority(1);
        }
        TextComponentUtilities.setCheckAuthority(comp, true);
    }

    private static void toReadFobit(IKDTextComponent comp) {
        TextComponentUtilities.setCheckAuthority(comp, false);
        comp.setEnabled(false);
        if (comp instanceof KDTextField) {
            ((KDTextField)comp).setText(TextComponentUtilities.getReadForbitItem());
        } else if (comp instanceof KDTextArea) {
            ((KDTextArea)comp).setText(TextComponentUtilities.getReadForbitItem());
        } else if (comp instanceof BasicFormattedTextField) {
            ((BasicFormattedTextField)comp).setText(TextComponentUtilities.getReadForbitItem());
        } else if (comp instanceof KDPromptBox) {
            ((KDPromptBox)comp).setText(TextComponentUtilities.getReadForbitItem());
            ((KDPromptBox)comp).setLabelText(TextComponentUtilities.getReadForbitItem());
        } else if (comp instanceof KDMultiLangBox) {
            KDMultiLangBox lBox = (KDMultiLangBox)comp;
            ((DefaultTextField)lBox.getEditorComponent()).setAccessAuthority(2);
        } else if (comp instanceof KDSpinner) {
            KDSpinner spinner = (KDSpinner)comp;
            if (spinner.getEditor() instanceof KDSpinner.DefaultNumberEditor) {
                KDSpinner.DefaultNumberEditor editor = (KDSpinner.DefaultNumberEditor)spinner.getEditor();
                JFormattedTextField ftf = editor.getTextField();
                spinner.setEditorUnFiltered(true);
                ftf.setText(TextComponentUtilities.getReadForbitItem());
                spinner.setEditorUnFiltered(false);
            }
        } else if (comp instanceof KDDatePicker) {
            KDDatePicker dp = (KDDatePicker)comp;
            DateTimeEditor editor = dp.getEditor();
            JComponent tf = editor.getEditorComponent();
            if (tf instanceof JTextField) {
                ((JTextField)tf).setText(TextComponentUtilities.getReadForbitItem());
            }
            ((BasicFormattedTextField)((KDDatePicker)comp).getEditor().getEditorComponent()).setAccessAuthority(2);
        }
        TextComponentUtilities.setCheckAuthority(comp, true);
    }

    private static boolean isCheckAuthority(IKDTextComponent comp) {
        Boolean result = (Boolean)((JComponent)((Object)comp)).getClientProperty("checkAuthority");
        if (result != null) {
            return result;
        }
        return true;
    }

    private static void setCheckAuthority(IKDTextComponent comp, boolean check) {
        ((JComponent)((Object)comp)).putClientProperty("checkAuthority", check);
    }
}

