/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.workbench.persist;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.workbench.persist.Trinity;
import com.kingdee.cosmic.ctrl.workbench.ui.ITrimView;
import com.kingdee.cosmic.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetViewport;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class TrimWidgetDescriptor
extends HashMap {
    private ArrayList trinities = new ArrayList();
    private String trimId;
    private String trimClsName;
    private String category;
    private String trimTitle;
    private URL trimIconURL;
    private static final boolean DEBUG = false;

    TrimWidgetDescriptor(ITrimWidget trimWidget) {
        this.trimId = trimWidget.getId();
        this.trimClsName = trimWidget.getClass().getName();
        String title = trimWidget.getTitle();
        URL url = trimWidget.getIconURL();
        boolean closeable = trimWidget.isCloseable();
        String category = trimWidget.getCategory();
        this.trimTitle = title;
        this.trimIconURL = url;
        this.category = category;
        this.addTrinity(new Trinity(16, "Id", this.trimId));
        this.addTrinity(new Trinity(16, "Title", title));
        if (url != null) {
            this.addTrinity(new Trinity(15, "IconURL", url.toString()));
        }
        this.addTrinity(new Trinity(1, "Closeable", Boolean.toString(closeable)));
        this.addTrinity(new Trinity(16, "Category", category));
        if (trimWidget instanceof TrimWidgetViewport) {
            String viewClsName = ((TrimWidgetViewport)trimWidget).getView().getClass().getName();
            this.addTrinity(new Trinity(17, "View", viewClsName));
        }
    }

    TrimWidgetDescriptor(String trimId, String trimClsName) {
        this.trimId = trimId;
        this.trimClsName = trimClsName;
    }

    void addTrinity(Trinity trinity) {
        if ("Title".equals(trinity.key)) {
            this.trimTitle = trinity.value;
        } else if ("Category".equals(trinity.key)) {
            this.category = trinity.value;
        } else if ("IconURL".equals(trinity.key)) {
            try {
                this.trimIconURL = new URL(trinity.value);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.trinities.add(trinity);
    }

    String getId() {
        return this.trimId;
    }

    String getTitle() {
        return this.trimTitle;
    }

    URL getIconURL() {
        return this.trimIconURL;
    }

    String getCategory() {
        return this.category;
    }

    public ITrimWidget toTrimWidget() {
        ITrimWidget trim;
        long t1 = System.currentTimeMillis();
        try {
            trim = (ITrimWidget)Class.forName(this.trimClsName).newInstance();
        }
        catch (Exception e) {
            return null;
        }
        for (Trinity trinity : this.trinities) {
            try {
                String key = trinity.getKey();
                Method m = "View".equals(key) ? trim.getClass().getMethod("set" + key, ITrimView.class) : trim.getClass().getMethod("set" + key, trinity.getType());
                m.invoke((Object)trim, trinity.getValue());
            }
            catch (Exception exception) {}
        }
        return trim;
    }

    public IXmlElement toXmlElement() {
        IXmlElement trimNode = XmlUtil.createNode((String)"trim");
        trimNode.setAttribute("id", this.trimId);
        trimNode.setAttribute("clsName", this.trimClsName);
        Iterator iterator = this.trinities.iterator();
        while (iterator.hasNext()) {
            IXmlElement trinityEle = XmlUtil.createNode((String)"trinity");
            trimNode.addChild(trinityEle);
            Trinity trinity = (Trinity)iterator.next();
            IXmlElement type = XmlUtil.createNode((String)"type");
            type.addCData("" + trinity.type);
            IXmlElement key = XmlUtil.createNode((String)"key");
            key.addCData("" + trinity.key);
            IXmlElement value = XmlUtil.createNode((String)"value");
            value.addCData("" + trinity.value);
            trinityEle.addChild(type);
            trinityEle.addChild(key);
            trinityEle.addChild(value);
        }
        return trimNode;
    }
}

