/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.workbench.splash;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.workbench.splash.BilinearImagePainter;
import com.kingdee.cosmic.ctrl.workbench.splash.BufferedImageOpFactory;
import com.kingdee.cosmic.ctrl.workbench.splash.ColorTintFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;

public class ImageUtil {
    private static ColorTintFilter Color_Tint_Filter;
    private static Color dark;
    private static Color light;
    private static Color outline;
    private static GraphicsConfiguration GRPHICSCONFIGURATION;

    public static BufferedImage getResizedImage(BufferedImage image, int targetWidth, int targetHeight) {
        return BilinearImagePainter.drawImageBilinear(image, targetWidth, targetHeight);
    }

    public static ColorTintFilter getColorTintFilter(Color mixColor, float mixValue) {
        if (Color_Tint_Filter == null) {
            Color_Tint_Filter = new ColorTintFilter(mixColor, mixValue);
        }
        return Color_Tint_Filter;
    }

    public static BufferedImage blurImageByGaussian(int xradius, int yradius, BufferedImage src, BufferedImage dest) {
        src = ImageUtil.createCompatibleImage(src);
        ConvolveOp gaussian = BufferedImageOpFactory.getGaussianBlurFilter(xradius, true);
        src = gaussian.filter(src, dest);
        gaussian = BufferedImageOpFactory.getGaussianBlurFilter(yradius, false);
        src = gaussian.filter(src, dest);
        return src;
    }

    public static BufferedImage blurImageByPlain(int radius, BufferedImage src, BufferedImage dest) {
        src = ImageUtil.createCompatibleImage(src);
        ConvolveOp plain = BufferedImageOpFactory.getPlainBlurFilter(radius, true);
        plain.filter(src, dest);
        plain = BufferedImageOpFactory.getPlainBlurFilter(radius, false);
        plain.filter(src, dest);
        return src;
    }

    public static BufferedImage drawString(String str, BufferedImage src, int x, int y, int fontSize, int offset) {
        char[] temp = str.toCharArray();
        String single = null;
        BufferedImage imageTemp = null;
        Graphics2D g2 = null;
        g2 = src.createGraphics();
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 1, fontSize);
        AffineTransform transform = new AffineTransform();
        int xOffset = x;
        int blur = offset / 15;
        for (int i = 0; i < temp.length; ++i) {
            single = String.valueOf(temp[i]);
            transform.setToTranslation(0.0, fontSize);
            imageTemp = blur > 1 ? ImageUtil.createSingleStringImage(single, transform, f, frc, offset, true, true, true) : ImageUtil.createSingleStringImage(single, transform, f, frc, offset, true, false, false);
            g2.drawImage((Image)imageTemp, xOffset, y, null);
            if (blur > 1) {
                xOffset += imageTemp.getWidth() + 2;
                continue;
            }
            xOffset += imageTemp.getWidth();
        }
        return src;
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        if (GRPHICSCONFIGURATION == null) {
            GRPHICSCONFIGURATION = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return GRPHICSCONFIGURATION;
    }

    private static BufferedImage createSingleStringImage(String single, AffineTransform tran, Font f, FontRenderContext frc, int offset, boolean withReflect, boolean bolder, boolean blur) {
        tran.setToTranslation(0.0, offset);
        TextLayout tl = null;
        Rectangle r = null;
        Shape shape = null;
        Graphics2D fontG2 = null;
        GradientPaint p = null;
        tl = new TextLayout(single, f, frc);
        shape = tl.getOutline(tran);
        r = shape.getBounds();
        BufferedImage imageTemp = new BufferedImage(r.width, r.height, 2);
        fontG2 = imageTemp.createGraphics();
        fontG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        fontG2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (bolder) {
            p = new GradientPaint(r.x, r.y, outline, r.x, r.y + r.height, light);
            fontG2.setPaint(p);
            fontG2.fill(shape);
            fontG2.setColor(dark);
            fontG2.draw(shape);
            fontG2.setClip(shape);
        } else {
            p = new GradientPaint(r.x, r.y, new Color(100, 150, 255), r.x, r.y + r.height, light);
            fontG2.setPaint(p);
            fontG2.fill(shape);
        }
        if (withReflect) {
            imageTemp = ImageUtil.drawStringReflection(imageTemp);
        }
        fontG2.drawImage((Image)imageTemp, 0, 0, null);
        fontG2.dispose();
        return imageTemp;
    }

    private static BufferedImage createCompatibleImage(BufferedImage src) {
        BufferedImage temp = ImageUtil.getGraphicsConfiguration().createCompatibleImage(src.getWidth(), src.getHeight(), src.getType());
        temp.createGraphics().drawImage((Image)src, 0, 0, null);
        return temp;
    }

    public static BufferedImage drawStringReflection(BufferedImage image) {
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(image.getWidth(), height * 2 + 20, 2);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.scale(1.0, -1.0);
        g2.drawImage((Image)image, 0, -height - height, null);
        g2.scale(1.0, -1.0);
        g2.translate(0, height);
        GradientPaint mask = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.5f), 0.0f, height / 2, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, image.getWidth(), height);
        g2.dispose();
        return result;
    }

    static {
        dark = new Color(148, 148, 148);
        light = new Color(20, 184, 255);
        outline = new Color(0, 0, 0);
    }
}

