/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.common.Utils;
import chrriis.dj.nativeswing.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.SyntaxHighlighterOptions;
import java.awt.Component;

public class JSyntaxHighlighter
extends NSPanelComponent {
    private static final String PACKAGE_PREFIX = "/dp.SyntaxHighlighter/";
    private JWebBrowser webBrowser;
    private static final String LS = Utils.LINE_SEPARATOR;

    public JSyntaxHighlighter(NSOption ... options) {
        if (this.getClass().getResource("/dp.SyntaxHighlighter/Styles/SyntaxHighlighter.css") == null) {
            throw new IllegalStateException("The SyntaxHighlighter distribution is missing from the classpath!");
        }
        this.webBrowser = new JWebBrowser(options);
        this.initialize(this.webBrowser.getNativeComponent());
        this.webBrowser.setDefaultPopupMenuRegistered(false);
        this.webBrowser.setBarsVisible(false);
        this.add((Component)this.webBrowser, "Center");
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void setContent(String content, ContentLanguage language) {
        this.setContent(content, language, null);
    }

    public void setContent(String content, ContentLanguage language, SyntaxHighlighterOptions options) {
        if (language == null) {
            throw new IllegalArgumentException("The language cannot be null!");
        }
        if (options == null) {
            options = new SyntaxHighlighterOptions();
        }
        String hContent = "<html>" + LS + "  <head>" + LS + "    <link type=\"text/css\" rel=\"stylesheet\" href=\"" + WebServer.getDefaultWebServer().getClassPathResourceURL(null, "/dp.SyntaxHighlighter/Styles/SyntaxHighlighter.css") + "\"></link>" + LS + "    <script language=\"javascript\" src=\"" + WebServer.getDefaultWebServer().getClassPathResourceURL(null, "/dp.SyntaxHighlighter/Scripts/shCore.js") + "\"></script>" + LS + "    <script language=\"javascript\" src=\"" + WebServer.getDefaultWebServer().getClassPathResourceURL(null, "/dp.SyntaxHighlighter/Scripts/shBrush" + language.getFileName() + ".js") + "\"></script>" + LS + "    <script language=\"JavaScript\" type=\"text/javascript\">" + LS + "      <!--" + LS + "      function init() {" + LS + "        dp.SyntaxHighlighter.ClipboardSwf = '" + WebServer.getDefaultWebServer().getClassPathResourceURL(null, "/dp.SyntaxHighlighter/Scripts/clipboard.swf") + "';" + LS + "        dp.SyntaxHighlighter.HighlightAll('code');" + LS + "      }" + LS + "      //-->" + LS + "    </script>" + LS + "    <style type=\"text/css\">" + LS + "      html, body { width: 100%; height: 100%; min-height: 100%; margin: 0; padding: 0; white-space: nowrap; background-color: #FFFFFF; }" + LS + "      div.dp-highlighter { overflow: visible; }" + LS + "      div.wrapper { width: 100%; height: 100%; min-height: 100%; padding: 0; margin: -18px 0; white-space: nowrap; }" + LS + "    </style>" + LS + "  </head>" + LS + "  <body id=\"body\">" + "    <div class=\"wrapper\">" + "      <pre name=\"code\" class=\"" + language.getLanguage() + "\">" + JSyntaxHighlighter.escapeXML(content) + "</pre>" + LS + "    </div>" + "  </body>" + LS + "<script language=\"JavaScript\" type=\"text/javascript\">" + LS + "  <!--" + LS + "    init();" + LS + "  //-->" + LS + "</script>" + LS + "</html>";
        this.webBrowser.setHTMLContent(hContent);
    }

    private static String escapeXML(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder((int)((double)s.length() * 1.1));
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentLanguage {
        Cpp("c++", "Cpp"),
        CSharp("c#", "CSharp"),
        CSS("css", "Css"),
        Delphi("delphi", "Delphi"),
        Java("java", "Java"),
        Javascript("js", "JScript"),
        PHP("php", "Php"),
        Python("python", "Python"),
        Ruby("ruby", "Ruby"),
        SQL("sql", "Sql"),
        VB("vb", "Vb"),
        XML("xml", "Xml"),
        HTML("html", "Xml");

        private String language;
        private String fileName;

        private ContentLanguage(String language, String fileName) {
            this.language = language;
            this.fileName = fileName;
        }

        String getLanguage() {
            return this.language;
        }

        String getFileName() {
            return this.fileName;
        }
    }
}

