/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdminOrgRangeFilterUtil
implements Serializable {
    private static Logger logger = Logger.getLogger((String)AdminOrgRangeFilterUtil.class.getName());

    public static String getUserAdminOrgSql(Context ctx) {
        String userid = AdminOrgRangeFilterUtil.getCurrentUserId(ctx);
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("SELECT DISTINCT BaseUnit.FID").append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON OrgRange.FOrgID = BaseUnit.FID  ").append(" WHERE OrgRange.FUserID = '").append(userid).append("'").append(" AND OrgRange.FType = ").append(20).append(" AND BaseUnit.FIsAssistantOrg = 0 ");
        return buffer.toString();
    }

    public static FilterItemInfo getFilterByAdminOrgRange(Context ctx) {
        return new FilterItemInfo("id", (Object)AdminOrgRangeFilterUtil.getUserAdminOrgSql(ctx), CompareType.INNER);
    }

    public static boolean isFilterByUserAdminOrgRange(Context ctx) {
        boolean isFilter = true;
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"isFilterByUserAdminOrgRange");
            if (StringUtils.isEmpty((String)value)) {
                value = "false";
            }
            isFilter = Boolean.valueOf(value);
        }
        catch (Exception e) {
            logger.error((Object)"get param isFilterByUserAdminOrgRange error:", (Throwable)e);
        }
        if (isFilter) {
            ObjectUuidPK userPK = new ObjectUuidPK(AdminOrgRangeFilterUtil.getCurrentUserId(ctx));
            try {
                return !Administrator.isSuperCUAdmin((IObjectPK)userPK) && !Administrator.isCUAdmin((Context)ctx, (IObjectPK)userPK);
            }
            catch (Exception e) {
                logger.error((Object)"get cu admin error", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static String getCurrentUserId(Context ctx) {
        String userid = "";
        userid = ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        return userid;
    }

    public static void disableNodeByCurrentUserAdminOrgRange(Context ctx, DefaultKingdeeTreeNode root) throws Exception {
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Set orgRange = AdminOrgRangeFilterUtil.getCurrentUserAdminOrgRange(ctx);
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            Object obj = node.getUserObject();
            if (obj == null || !(obj instanceof FullOrgUnitInfo) || orgRange.contains((unitInfo = (FullOrgUnitInfo)obj).getId().toString())) continue;
            OrgF7InnerUtils.disableTreeNode(node);
        }
        OrgF7InnerUtils.clipTreeNodeByColor(root);
    }

    public static Set getCurrentUserAdminOrgRange(Context ctx) throws Exception {
        OrgRangeCollection coll = AdminOrgRangeFilterUtil.getCurrentUserAdminOrgRangeColl(ctx);
        HashSet<String> result = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            result.add(coll.get(i).getOrg().getId().toString());
        }
        return result;
    }

    public static OrgRangeCollection getCurrentUserAdminOrgRangeColl(Context ctx) throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(AdminOrgRangeFilterUtil.getCurrentUserId(ctx));
        IOrgRange orgRange = null;
        orgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection coll = orgRange.findFullOrgCol((IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE);
        return coll;
    }

    public static boolean isTopLevelNodeInRange(DefaultKingdeeTreeNode root, String orgid) {
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode selectNode = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            Object obj = node.getUserObject();
            if (obj == null || !(obj instanceof FullOrgUnitInfo) || !(unitInfo = (FullOrgUnitInfo)obj).getId().toString().equals(orgid)) continue;
            selectNode = node;
            break;
        }
        DefaultKingdeeTreeNode parentNode = selectNode;
        boolean hasParentEnableNode = false;
        if (!OrgF7InnerUtils.isTreeNodeDisable(selectNode)) {
            while (parentNode.getParent() != null) {
                if (!OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)selectNode.getParent())) {
                    hasParentEnableNode = true;
                    break;
                }
                parentNode = (DefaultKingdeeTreeNode)parentNode.getParent();
            }
            return !hasParentEnableNode;
        }
        return false;
    }
}

