/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public final class BizOrgAssistInfoBuilder
extends PropertyContainer
implements Serializable {
    public static final int TREETYPE_ORDINARY = 0;
    public static final int TREETYPE_BIZUNIT = 1;
    public static final int TREETYPE_VIRTUALUNIT = 2;
    public static final int TREETYPE_UNIONANDGROUP = 0;
    public static final int TREETYPE_UNITONLY = 1;
    public static final int TREETYPE_GROUPONLY = 2;

    public BizOrgAssistInfoBuilder() {
    }

    public BizOrgAssistInfoBuilder(OrgViewType orgViewType, String treeID) throws BOSException {
        this.setNeedConsiderFaultTree(true);
        this.setInnerJoinStyle(true);
        if (orgViewType == null) {
            throw new BOSException("orgViewType cannot be null");
        }
        this.put("orgViewType", (Object)orgViewType);
        if (orgViewType == OrgViewType.UNIONDEBT && StringUtils.isEmpty((String)treeID)) {
            throw new BOSException("treeID cannot be null when orgViewType is union");
        }
        if (orgViewType != OrgViewType.UNIONDEBT) {
            this.setString("treeID", NewOrgViewHelper.convert2TreeId(orgViewType));
        }
    }

    public OrgViewType getOrgViewType() {
        return (OrgViewType)((Object)this.get("orgViewType"));
    }

    public String getTreeID() {
        return this.getString("treeID");
    }

    public boolean isNeedAddSealUpFilter() {
        return this.getBoolean("isNeedAddSealUpFilter");
    }

    public BizOrgAssistInfoBuilder setNeedAddSealUpFilter(boolean isNeedAddSealUpFilter) {
        this.setBoolean("isNeedAddSealUpFilter", isNeedAddSealUpFilter);
        return this;
    }

    public boolean isNeedAddAssistantFilter() {
        return this.getBoolean("isNeedAddAssistantFilter");
    }

    public BizOrgAssistInfoBuilder setNeedAddAssistantFilter(boolean isNeedAddAssistantFilter) {
        this.setBoolean("isNeedAddAssistantFilter", isNeedAddAssistantFilter);
        return this;
    }

    public boolean isNeedAddOrgRange() {
        return this.getBoolean("needAddOrgRange");
    }

    public BizOrgAssistInfoBuilder setNeedAddOrgRange(boolean needAddOrgRange) {
        this.setBoolean("needAddOrgRange", needAddOrgRange);
        return this;
    }

    public boolean isNeedAddVirtualFilter() {
        return this.getBoolean("isNeedAddVirtualFilter");
    }

    public BizOrgAssistInfoBuilder setNeedAddVirtualFilter(boolean isNeedAddVirtualFilter) {
        this.setBoolean("isNeedAddVirtualFilter", isNeedAddVirtualFilter);
        return this;
    }

    public IMetaDataPK getActionPK() {
        return (IMetaDataPK)this.get("actionPK");
    }

    public BizOrgAssistInfoBuilder setUIPKAndActionPK(IMetaDataPK uiPK, IMetaDataPK actionPK) {
        this.put("actionPK", actionPK);
        this.put("uiPK", uiPK);
        return this;
    }

    public String getCuID() {
        return this.getString("cuID");
    }

    public BizOrgAssistInfoBuilder setCuID(String cuID) {
        this.setString("cuID", cuID);
        return this;
    }

    public boolean isCUFilter() {
        return this.getBoolean("isCUFilter");
    }

    public BizOrgAssistInfoBuilder setCUFilter(boolean isCUFilter, boolean isCUFilterIncludeSub) {
        this.setBoolean("isCUFilter", isCUFilter);
        this.setBoolean("isCUFilterIncludeSub", isCUFilterIncludeSub);
        return this;
    }

    public boolean isCUFilterIncludeSub() {
        return this.getBoolean("isCUFilterIncludeSub");
    }

    public IMetaDataPK getUiPK() {
        return (IMetaDataPK)this.get("uiPK");
    }

    public IObjectPK getUserPK() {
        return (IObjectPK)this.get("userPK");
    }

    public BizOrgAssistInfoBuilder setUserPK(IObjectPK userPK) {
        this.put("userPK", userPK);
        return this;
    }

    public boolean isNeedConsiderFaultTree() {
        return this.getBoolean("needConsiderFaultTree");
    }

    public BizOrgAssistInfoBuilder setNeedConsiderFaultTree(boolean needConsiderFaultTree) {
        this.setBoolean("needConsiderFaultTree", needConsiderFaultTree);
        return this;
    }

    public String getExtraFilters() {
        return this.getString("extraFilters");
    }

    public BizOrgAssistInfoBuilder setExtraFilters(String extraFilters) {
        this.setString("extraFilters", extraFilters);
        return this;
    }

    public boolean isInnerJoinStyle() {
        return this.getBoolean("isInnerJoinStyle");
    }

    public BizOrgAssistInfoBuilder setInnerJoinStyle(boolean isInnerJoinStyle) {
        this.setBoolean("isInnerJoinStyle", isInnerJoinStyle);
        return this;
    }

    public String getBizUnitQuerySQL() {
        return this.getString("bizQuerySQL");
    }

    public BizOrgAssistInfoBuilder setBizUnitQuerySQL(int treeType) {
        if (this.getOrgViewType() != OrgViewType.CTRLUNIT) {
            if (this.getOrgViewType() == OrgViewType.UNIONDEBT) {
                if (treeType == 2) {
                    StringBuffer extraFilter = new StringBuffer();
                    extraFilter.append("\"BASEUNIT\"").append(".FIsUnion = 1");
                    this.setString("bizQuerySQL", extraFilter.toString());
                } else if (treeType == 1) {
                    StringBuffer extraFilter = new StringBuffer();
                    extraFilter.append("\"BASEUNIT\"").append(".FIsUnion = 0");
                    this.setString("bizQuerySQL", extraFilter.toString());
                }
            } else if (treeType == 1) {
                StringBuffer extraFilter = new StringBuffer();
                extraFilter.append("\"OUPART\"").append(".FIsBizUnit = 1 ");
                this.setString("bizQuerySQL", extraFilter.toString());
            } else if (treeType == 2) {
                StringBuffer extraFilter = new StringBuffer();
                extraFilter.append("\"OUPART\"").append(".FIsBizUnit = 0 ");
                this.setString("bizQuerySQL", extraFilter.toString());
            }
        }
        return this;
    }

    public BizOrgAssistInfoBuilder setAccountTableIDAndPeriodID(String accountTableID, String periodID) {
        if (StringUtils.isEmpty((String)accountTableID) || StringUtils.isEmpty((String)periodID)) {
            return this;
        }
        StringBuilder extraFilter = new StringBuilder();
        extraFilter.append("\"OUPART\"").append(".FAccountTableID = '").append(accountTableID).append("' AND ").append("\"OUPART\"").append(".FAccountPeriodID = '").append(periodID).append("'");
        this.setString("accountTableAndPeriodSQL", extraFilter.toString());
        return this;
    }

    public String getAccountTableAndPeriodSQL() {
        return this.getString("accountTableAndPeriodSQL");
    }

    public BizOrgAssistInfoBuilder setAccountSchemaID(String accountSchemaID) {
        if (!StringUtils.isEmpty((String)accountSchemaID) && !"00000000-0000-0000-0000-000000000000DDF8E923".equals(accountSchemaID)) {
            this.setNeedAddAssistantFilter(false);
            StringBuffer extraFilter = new StringBuffer();
            extraFilter.append(" NOT EXISTS (").append("select 1 from t_org_company where fid = ").append("\"BASEUNIT\"").append(".FID").append(" and fisassistantorg = 1 and faccountschemeid <> '").append(accountSchemaID).append("') ").append(" AND NOT EXISTS ( ").append(" select 1 from t_org_company where fmainorgid = ").append("\"BASEUNIT\"").append(".FID").append(" and fisassistantorg = 1 and faccountschemeid = '").append(accountSchemaID).append("' )");
            this.setString("accountSchemaSQL", extraFilter.toString());
        }
        return this;
    }

    public String getAccountSchemaSQL() {
        return this.getString("accountSchemaSQL");
    }
}

