/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.eas.basedata.org.BizCheckerConfigParser;
import com.kingdee.eas.basedata.org.IOrgBizChecker;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgBizCheckerManager {
    private static Logger logger = Logger.getLogger((String)OrgBizCheckerManager.class.getName());
    private static OrgBizCheckerManager instance = null;
    private List checkers;

    public static OrgBizCheckerManager getOrgBizCheckerManager() {
        if (instance == null) {
            instance = new OrgBizCheckerManager();
            OrgBizCheckerManager.instance.checkers = new ArrayList();
        }
        return instance;
    }

    private OrgBizCheckerManager() {
    }

    public List getAllCheckers() {
        return this.checkers;
    }

    public void clearCheckers() {
        this.checkers.clear();
    }

    public void registerChecker(IOrgBizChecker checker) {
        this.checkers.add(checker);
    }

    public void reloadCheckers() throws EASBizException {
        this.clearCheckers();
        try {
            for (String name : BizCheckerConfigParser.getCheckerItems()) {
                IOrgBizChecker checker = (IOrgBizChecker)Class.forName(name).newInstance();
                this.registerChecker(checker);
            }
        }
        catch (Exception err) {
            logger.error((Object)err);
            throw new OrgException(OrgException.BIZCHECKER_LOAD_ERROR, err);
        }
    }
}

