/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOUPartFI;
import com.kingdee.eas.basedata.org.IOUPartProfitCenter;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartFIFactory;
import com.kingdee.eas.basedata.org.OUPartFIInfo;
import com.kingdee.eas.basedata.org.OUPartProfitCenterFactory;
import com.kingdee.eas.basedata.org.OUPartProfitCenterInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.app.AbstractNewOrgUnitFacadeControllerBean;
import com.kingdee.eas.basedata.org.app.OrgBizConfigUtil;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.basedata.org.app.ext.ExtHelper;
import com.kingdee.eas.basedata.org.app.ext.IOrgExt;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jdom.JDOMException;

public class NewOrgUnitFacadeControllerBean
extends AbstractNewOrgUnitFacadeControllerBean {
    @Override
    protected IObjectValue _getDelegateUnit(Context ctx, String unitID, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(unitID);
        FullOrgUnitInfo info = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)pk);
        if (toType.getValue() == 10) {
            if (info.getCU() == null) {
                throw new RuntimeException("data error, cu can't be null!");
            }
            ObjectUuidPK cuPK = new ObjectUuidPK(info.getCU().getId());
            return CtrlUnitFactory.getLocalInstance(ctx).getCtrlUnitInfo((IObjectPK)cuPK);
        }
        if (NewOrgUnitHelper.isBizType(info, toType)) {
            return this.getTypedInfo(ctx, info, toType);
        }
        String oql = "select toUnit.* where fromUnit.id = '" + unitID + "' and typeRelation.fromType = " + fromType.getValue() + " and typeRelation.toType = " + toType.getValue();
        OrgUnitRelationCollection col = OrgUnitRelationFactory.getLocalInstance(ctx).getOrgUnitRelationCollection(oql);
        if (col != null && col.size() > 0) {
            return this.getTypedInfo(ctx, col.get(0).getToUnit(), toType);
        }
        FullOrgUnitInfo parentInfo = info.getParent();
        if (parentInfo == null || parentInfo.getId() == null) {
            return null;
        }
        return this._getDelegateUnit(ctx, parentInfo.getId().toString(), fromType, toType);
    }

    private OrgUnitInfo getTypedInfo(Context ctx, OrgUnitInfo info, OrgType type) throws BOSException, EASBizException {
        return NewOrgUnitHelper.getTypedOrgUnit(ctx, info.getId().toString(), type);
    }

    @Override
    protected IObjectValue _getDelegateUnit(Context ctx, String unitID, OrgType toType) throws BOSException, EASBizException {
        return this.innerGetDelegateUnit(ctx, unitID, toType);
    }

    private IObjectValue innerGetDelegateUnit(Context ctx, String unitID, OrgType toType) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(unitID);
        FullOrgUnitInfo info = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)pk);
        if (toType.getValue() == 10) {
            if (info.getCU() == null) {
                throw new RuntimeException("data error, cu can't be null!");
            }
            return OrgCacheFactory.getOrgCache(ctx).getOrgUnitInfo(ctx, info.getCU().getId().toString(), OrgType.ControlUnit);
        }
        if (NewOrgUnitHelper.isBizType(info, toType)) {
            return OrgCacheFactory.getOrgCache(ctx).getOrgUnitInfo(ctx, unitID, toType);
        }
        FullOrgUnitInfo parentInfo = info.getParent();
        if (parentInfo == null || parentInfo.getId() == null) {
            return null;
        }
        if (toType.getValue() == 1) {
            if (parentInfo.getId().toString().equals(info.getId().toString())) {
                if (NewOrgUnitHelper.isBizType(info, toType)) {
                    return OrgCacheFactory.getOrgCache(ctx).getOrgUnitInfo(ctx, info.getId().toString(), toType);
                }
                return null;
            }
            return this.innerGetDelegateUnit(ctx, parentInfo.getId().toString(), toType);
        }
        return null;
    }

    @Override
    protected IObjectValue _getDelegateUnit(Context ctx, IObjectValue unitInfo, OrgType toType) throws BOSException, EASBizException {
        assert (toType.getValue() != 1);
        return this.innerGetDelegateUnit(ctx, (FullOrgUnitInfo)unitInfo, toType);
    }

    private IObjectValue innerGetDelegateUnit(Context ctx, FullOrgUnitInfo unitInfo, OrgType toType) throws BOSException, EASBizException {
        if (toType.getValue() == 10) {
            if (unitInfo.getCU() == null) {
                throw new RuntimeException("data error, cu can't be null!");
            }
            return OrgCacheFactory.getOrgCache(ctx).getOrgUnitInfo(ctx, unitInfo.getCU().getId().toString(), OrgType.ControlUnit);
        }
        if (NewOrgUnitHelper.isBizType(unitInfo, toType)) {
            return OrgCacheFactory.getOrgCache(ctx).getOrgUnitInfo(ctx, unitInfo.getId().toString(), toType);
        }
        return null;
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iou = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo info = iou.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
        String oql = "select * where longNumber like '" + info.getLongNumber() + "!%'";
        return iou.getFullOrgUnitCollection(oql);
    }

    @Override
    protected IObjectValue _getParent(Context ctx, String unitID) throws BOSException, EASBizException {
        String oql = "select parent.* where id='" + unitID + "'";
        FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitCollection(oql);
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    @Override
    protected IObjectCollection _getBrother(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iou = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo info = iou.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
        String oql = null;
        oql = info.getParent() == null ? "select * where parent is null AND id!='" + unitID + "'" : "select * where parent.id='" + info.getId().toString() + "' AND id!='" + unitID + "'";
        return iou.getFullOrgUnitCollection(oql);
    }

    @Override
    protected IObjectCollection _getDirectChildren(Context ctx, String unitID) throws BOSException {
        IFullOrgUnit iou = FullOrgUnitFactory.getLocalInstance(ctx);
        String oql = "select * where parent.id='" + unitID + "'";
        return iou.getFullOrgUnitCollection(oql);
    }

    @Override
    protected boolean _isOrgStart(Context ctx) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        BOSUuid rootOUID = BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4");
        FullOrgUnitInfo rootOUInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootOUID));
        return rootOUInfo.isIsStart();
    }

    @Override
    protected void _checkIsOUSealUp(Context ctx, String unitID, int orgTypeValue) throws BOSException, EASBizException {
        if (unitID == null || unitID.length() == 0) {
            throw new IllegalArgumentException("Org id cannot be null or empty!");
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unit = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        if (unit.isIsOUSealUp()) {
            Object[] param = new Object[1];
            String strResource = "com.kingdee.eas.basedata.org.F7TitleResource";
            param[0] = EASCommonResource.getString((String)strResource, (String)"TABLE_COLUMN_TITLE_REFORGUNIT", (Locale)ctx.getLocale());
            throw new OUException(OUException.CANT_ADDNEW_FOR_SEALED, param);
        }
        OrgUnitInfo orgUnitInfo = NewOrgViewHelper.getOrgUnitInfo(ctx, unitID, OrgType.getEnum(orgTypeValue));
        if (orgUnitInfo.getBoolean("isSealUp")) {
            Object[] param = new Object[]{OrgType.getEnum(orgTypeValue).getAlias()};
            throw new OUException(OUException.CANT_ADDNEW_FOR_SEALED, param);
        }
    }

    @Override
    protected void _updateAccountTableInCU(Context ctx, String cuId, String accountTableId) throws BOSException, EASBizException {
        if (!CtrlUnitFactory.getLocalInstance(ctx).exists("where id = '" + cuId + "'")) {
            throw new BOSException("id, " + cuId + ", is not a control unit's id");
        }
        IOrgExt iOrgExt = ExtHelper.getOrgExtImpl();
        boolean accountTable = iOrgExt.existAccountTable(ctx, accountTableId);
        if (!accountTable) {
            throw new BOSException("id, " + accountTableId + ", is not an account table's id");
        }
        String updateOUPartFI = new StringBuffer().append("update t_org_oupartfi set faccounttableid = '").append(accountTableId).append("'").append(" where funitid in (").append("select fid from t_org_baseunit where fiscompanyorgunit = 1 and fcontrolunitid = '").append(cuId).append("')").toString();
        String updateCompany = new StringBuffer().append("update t_org_company set faccounttableid = '").append(accountTableId).append("'").append(" where fcontrolunitid = '").append(cuId).append("'").toString();
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            stmt.addBatch(updateOUPartFI);
            stmt.addBatch(updateCompany);
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        OrgCacheFactory.getOrgCache(ctx).clearOrgCache();
    }

    @Override
    protected IObjectValue _getCachedOrgUnitInfo(Context ctx, String id, OrgType orgType) throws BOSException, EASBizException {
        return OrgCacheFactory.getOrgCache(ctx).getOrgUnitInfo(ctx, id, orgType);
    }

    @Override
    protected void _updateAccountTableInCompany(Context ctx, String companyId, String accountTableId) throws BOSException, EASBizException {
        if (!NewOrgViewHelper.existOrgUnitInfo(ctx, companyId, OrgType.Company)) {
            throw new BOSException("id, " + companyId + ", is not a company unit's id");
        }
        IOrgExt iOrgExt = ExtHelper.getOrgExtImpl();
        boolean accountTable = iOrgExt.existAccountTable(ctx, accountTableId);
        if (accountTableId != null && !accountTable) {
            throw new BOSException("id, " + accountTableId + ", is not an account table's id");
        }
        StringBuffer updateOUPartFI = new StringBuffer();
        if (accountTableId == null) {
            updateOUPartFI.append("update t_org_oupartfi set faccounttableid = null");
        } else {
            updateOUPartFI.append("update t_org_oupartfi set faccounttableid = '").append(accountTableId).append("'");
        }
        updateOUPartFI.append(" where funitid = '").append(companyId).append("'");
        StringBuffer updateCompany = new StringBuffer();
        if (accountTableId == null) {
            updateCompany.append("update t_org_company set faccounttableid = null");
        } else {
            updateCompany.append("update t_org_company set faccounttableid = '").append(accountTableId).append("'");
        }
        updateCompany.append(" where fid = '").append(companyId).append("'");
        Connection cn = null;
        Statement stmt = null;
        try {
            IOUPartFI partFI = OUPartFIFactory.getLocalInstance((Context)ctx);
            IObjectPK[] pks = partFI.getPKList(" where unit.id='" + companyId + "'");
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            stmt.addBatch(updateOUPartFI.toString());
            stmt.addBatch(updateCompany.toString());
            stmt.executeBatch();
            OUPartFIInfo fiInfo = new OUPartFIInfo();
            ORMValueCacheService.getInstance().removeBatch(ctx, fiInfo.getBOSType(), pks);
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            ORMValueCacheService.getInstance().remove(ctx, companyInfo.getBOSType(), companyId);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        OrgCacheFactory.getOrgCache(ctx).clearOrgCache();
    }

    @Override
    protected List _getXMLOrgBizClasses(Context ctx, String configitemName, String attributeKey) throws BOSException, EASBizException {
        List dealClassNamesList = null;
        try {
            dealClassNamesList = OrgBizConfigUtil.getInstance().getXMLBizClasses(configitemName, attributeKey);
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return dealClassNamesList;
    }

    @Override
    protected Collection _getAllOrgTypes(Context ctx) throws BOSException, EASBizException {
        return OrgCommonUtils.getAllOrgType();
    }

    @Override
    protected String _getTreeIdByOrgType(Context ctx, OrgType orgType) throws BOSException, EASBizException {
        return OrgCommonUtils.getOrgTreeId(orgType);
    }

    @Override
    protected String _getBosTypeByOrgType(Context ctx, OrgType orgType) throws BOSException, EASBizException {
        return OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgType).getBosType().toString();
    }

    @Override
    protected void _updateAccountTableInProfitCenter(Context ctx, String profitCenterID, String pcAcctTableID) throws BOSException, EASBizException {
        if (!NewOrgViewHelper.existOrgUnitInfo(ctx, profitCenterID, OrgType.ProfitCenter)) {
            throw new BOSException("id, " + profitCenterID + ", is not a profitCenter unit's id");
        }
        StringBuffer updateOUPartPC = new StringBuffer();
        if (pcAcctTableID == null) {
            updateOUPartPC.append("update T_ORG_OUPartProfitCenter set FPcAccountTableID = null");
        } else {
            updateOUPartPC.append("update T_ORG_OUPartProfitCenter set FPcAccountTableID = '").append(pcAcctTableID).append("'");
        }
        updateOUPartPC.append(" where funitid = '").append(profitCenterID).append("'");
        StringBuffer updateProfitCenter = new StringBuffer();
        if (pcAcctTableID == null) {
            updateProfitCenter.append("update t_org_profitCenter set FPcaccountTableID = null");
        } else {
            updateProfitCenter.append("update t_org_profitCenter set FPcaccountTableID = '").append(pcAcctTableID).append("'");
        }
        updateProfitCenter.append(" where fid = '").append(profitCenterID).append("'");
        Connection cn = null;
        Statement stmt = null;
        try {
            IOUPartProfitCenter partProfit = OUPartProfitCenterFactory.getLocalInstance((Context)ctx);
            IObjectPK[] pks = partProfit.getPKList(" where unit.id='" + profitCenterID + "'");
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            stmt.addBatch(updateOUPartPC.toString());
            stmt.addBatch(updateProfitCenter.toString());
            stmt.executeBatch();
            OUPartProfitCenterInfo pcInfo = new OUPartProfitCenterInfo();
            ORMValueCacheService.getInstance().removeBatch(ctx, pcInfo.getBOSType(), pks);
            ProfitCenterOrgUnitInfo profitCenterInfo = new ProfitCenterOrgUnitInfo();
            ORMValueCacheService.getInstance().remove(ctx, profitCenterInfo.getBOSType(), profitCenterID);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        OrgCacheFactory.getOrgCache(ctx).clearOrgCache();
    }

    @Override
    protected boolean _getAdminOrgIsStartSHR(Context ctx, String orgID) throws BOSException, EASBizException {
        String sql = "select 1 from t_org_admin where fisstartshr= 1 and fid='" + orgID + "'";
        IRowSet rs = DbUtil.executeQueryNoTx((Context)ctx, (String)sql);
        return rs.size() > 0;
    }

    @Override
    protected boolean _isStartSHR(Context ctx) throws BOSException, EASBizException {
        String sql = "select 1 from t_org_admin where fisstartshr= 1";
        IRowSet rs = DbUtil.executeQueryNoTx((Context)ctx, (String)sql);
        return rs.size() > 0;
    }
}

