/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.basedata.org.OrgXMLElement;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class OrgBizConfigUtil {
    private static Logger logger = Logger.getLogger((String)OrgBizConfigUtil.class.getName());
    private static OrgBizConfigUtil instance = null;
    private static String path = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append("OrgConfig.xml").toString();
    private Element document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OrgBizConfigUtil getInstance() {
        if (instance != null) return instance;
        Class<OrgBizConfigUtil> clazz = OrgBizConfigUtil.class;
        synchronized (OrgBizConfigUtil.class) {
            if (instance != null) return instance;
            instance = new OrgBizConfigUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private OrgBizConfigUtil() {
        try {
            this.document = this.initDocument();
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public Element initDocument() throws JDOMException, IOException {
        FileInputStream inputStream = null;
        String path = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append("OrgConfig.xml").toString();
        Element document = null;
        inputStream = new FileInputStream(new File(path));
        document = XMLParser.parseXML((InputStream)inputStream).getRootElement();
        return document;
    }

    public static List getBizClassesforOrg(String configitemName, String attributeKey) {
        ArrayList<String> dealClassNamesList = new ArrayList<String>();
        try {
            String path = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append("OrgConfig.xml").toString();
            File orgConfigFile = new File(path);
            XMLConfiguration xmlReader = XMLConfiguration.getInstance((File)orgConfigFile);
            ConfigurationItem item = xmlReader.getConfigItem(configitemName);
            Map pro = item.getProperties();
            String dealClassName2 = null;
            if (StringUtils.isEmpty((String)attributeKey)) {
                for (String dealClassName2 : pro.values()) {
                    if (StringUtils.isEmpty((String)dealClassName2)) continue;
                    dealClassNamesList.add(dealClassName2);
                }
            } else {
                dealClassNamesList.add((String)pro.get(attributeKey));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dealClassNamesList;
    }

    public List getXMLBizClasses(String configitemName, String attributeKey) throws JDOMException, IOException {
        ArrayList<OrgXMLElement> dealClassNamesList = new ArrayList<OrgXMLElement>();
        ArrayList<OrgXMLElement> keyFilterClassNamesList = new ArrayList<OrgXMLElement>();
        if (this.document == null) {
            throw new JDOMException();
        }
        Element currentElement = (Element)XPath.selectSingleNode((Object)this.document, (String)("configitem[lower-case(attribute::name)='" + configitemName.toLowerCase() + "']"));
        if (currentElement != null) {
            List entities = currentElement.getChildren();
            int size = entities.size();
            for (int i = 0; i < size; ++i) {
                Element entity = (Element)entities.get(i);
                String key = entity.getAttribute("key").getValue();
                String value = entity.getAttribute("value").getValue();
                boolean isThrowException = Boolean.valueOf(entity.getAttribute("isThrowException").getValue());
                String description = entity.getAttribute("description").getValue();
                OrgXMLElement item = new OrgXMLElement(key, value, isThrowException, description);
                if (!StringUtils.isEmpty((String)attributeKey) && attributeKey.equalsIgnoreCase(key)) {
                    keyFilterClassNamesList.add(item);
                }
                dealClassNamesList.add(item);
            }
        }
        if (StringUtils.isEmpty((String)attributeKey)) {
            return dealClassNamesList;
        }
        return keyFilterClassNamesList;
    }
}

