/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTypeRelation;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationFactory;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.app.AbstractOrgUnitRelationControllerBean;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgUnitRelationControllerBean
extends AbstractOrgUnitRelationControllerBean {
    private static Logger logger = Logger.getLogger((String)OrgUnitRelationControllerBean.class.getName());

    @Override
    public IObjectCollection _getFromUnits(Context ctx, IObjectValue _typeRelation, IObjectValue _toUnit) throws BOSException, EASBizException {
        OrgUnitInfo toUnit = (OrgUnitInfo)_toUnit;
        OrgTypeRelationInfo typeRelation = (OrgTypeRelationInfo)_typeRelation;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)typeRelation.getId()));
        fi.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)toUnit.getId()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("fromUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("fromUnit.name"));
        OrgUnitRelationCollection col = super.getOrgUnitRelationCollection(ctx, evi);
        OrgUnitCollection result = new OrgUnitCollection();
        for (int i = 0; i < col.size(); ++i) {
            result.add(col.get(i).getFromUnit());
        }
        return result;
    }

    @Override
    public IObjectValue _getToUint(Context ctx, IObjectValue _typeRelation, IObjectValue _fromUnit) throws BOSException, EASBizException {
        OrgUnitInfo fromUnit = (OrgUnitInfo)_fromUnit;
        OrgTypeRelationInfo typeRelation = (OrgTypeRelationInfo)_typeRelation;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)typeRelation.getId()));
        fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)fromUnit.getId()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("toUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("toUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("toUnit.orgType"));
        OrgUnitRelationCollection col = super.getOrgUnitRelationCollection(ctx, evi);
        if (col.size() == 0) {
            return null;
        }
        return col.get(0).getToUnit();
    }

    @Override
    public IObjectCollection _getCollection(Context ctx, IObjectValue _fromUnit) throws BOSException {
        OrgUnitInfo fromUnit = (OrgUnitInfo)_fromUnit;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)fromUnit.getId()));
        evi.setFilter(fi);
        return super.getOrgUnitRelationCollection(ctx, evi);
    }

    @Override
    protected IObjectCollection _getToUnit(Context ctx, String fromUnitID, int fromType, int toType) throws BOSException, EASBizException {
        OrgUnitRelationCollection relCol = OrgCacheFactory.getOrgCache(ctx).getOrgUnitRelationCollectionCache(ctx, fromUnitID, fromType, toType);
        OrgUnitCollection unitCol = new OrgUnitCollection();
        int n = relCol.size();
        for (int i = 0; i < n; ++i) {
            String toUnitID = relCol.get(i).getToUnit().getId().toString();
            unitCol.add(this.getStrongTypedInfo(ctx, toType, toUnitID));
        }
        return unitCol;
    }

    @Override
    protected IObjectValue _getDefaultToUnit(Context ctx, String fromUnitID, int fromType, int toType) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        view.getSelector().add(new SelectorItemInfo("isDefault"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", (Object)fromUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(toType), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        OrgUnitRelationCollection relCol = this.getOrgUnitRelationCollection(ctx, view);
        OrgUnitInfo unitInfo = null;
        int n = relCol.size();
        for (int i = 0; i < n; ++i) {
            OrgUnitRelationInfo relInfo = relCol.get(i);
            if (!relInfo.isIsDefault()) continue;
            String toUnitID = relInfo.getToUnit().getId().toString();
            unitInfo = this.getStrongTypedInfo(ctx, toType, toUnitID);
            break;
        }
        return unitInfo;
    }

    @Override
    protected IObjectCollection _getFromUnit(Context ctx, String toUnitID, int toUnitType, int fromUnitType) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        return this._getFromUnit(ctx, toUnitID, toUnitType, fromUnitType, selectors);
    }

    private OrgUnitCollection getStrongTypeCollection(Context ctx, int fromUnitType, Collection fromUnitIDCol, SelectorItemCollection selectors) throws BOSException, EASBizException {
        return NewOrgViewHelper.getOrgUnitCollection(ctx, fromUnitIDCol, OrgType.getEnum(fromUnitType), selectors);
    }

    private OrgUnitInfo getStrongTypedInfo(Context ctx, int orgType, String unitID) throws BOSException, EASBizException {
        return NewOrgViewHelper.getOrgUnitInfo(ctx, unitID, OrgType.getEnum(orgType));
    }

    @Override
    protected void _batchAddNew(Context ctx, IObjectCollection col) throws BOSException {
        if (col == null || col.size() == 0) {
            return;
        }
        OrgUnitRelationCollection relationCol = (OrgUnitRelationCollection)col;
        Connection cn = null;
        PreparedStatement pstmt = null;
        try {
            ArrayList<OrgUnitRelationInfo> hasDefaultDelOrgList = new ArrayList<OrgUnitRelationInfo>();
            for (int i = 0; i < relationCol.size(); ++i) {
                OrgUnitRelationInfo tempRelInfo = relationCol.get(i);
                if (!tempRelInfo.isIsDefault()) continue;
                hasDefaultDelOrgList.add(tempRelInfo);
            }
            cn = this.getConnection(ctx);
            if (!hasDefaultDelOrgList.isEmpty()) {
                String updateSql = "update T_ORG_UnitRelation set FIsDefault = 0 where FTypeRelationID=? and FFromUnitID=? and FVersionNumber=?";
                pstmt = cn.prepareStatement(updateSql);
                for (int i = 0; i < hasDefaultDelOrgList.size(); ++i) {
                    OrgUnitRelationInfo info = (OrgUnitRelationInfo)hasDefaultDelOrgList.get(i);
                    pstmt.setString(1, info.getTypeRelation().getId().toString());
                    pstmt.setString(2, info.getFromUnit().getId().toString());
                    pstmt.setString(3, info.getVersionNumber());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            String deleteSql = new StringBuffer("delete T_ORG_UnitRelation").append(" where FFromUnitID =? and  FToUnitID = ? and  FTypeRelationID=? and FVersionNumber =?").toString();
            pstmt = cn.prepareStatement(deleteSql);
            int n = relationCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitRelationInfo info = relationCol.get(i);
                pstmt.setString(1, info.getFromUnit().getId().toString());
                pstmt.setString(2, info.getToUnit().getId().toString());
                pstmt.setString(3, info.getTypeRelation().getId().toString());
                pstmt.setString(4, info.getVersionNumber());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            String insertSql = new StringBuffer("INSERT INTO T_ORG_UnitRelation").append("(FID, FFromUnitID, FToUnitID, FTypeRelationID, FIsDefault, FVersionNumber) ").append("VALUES(?, ?, ?, ?, ?, ?)").toString();
            pstmt = cn.prepareStatement(insertSql);
            IOrgTypeRelation iTypeRelation = OrgTypeRelationFactory.getLocalInstance(ctx);
            OrgTypeRelationInfo adminToFIRelationInfo = iTypeRelation.getOrgTypeRelationInfo("where fromType=0and toType=1");
            String adminToFIID = adminToFIRelationInfo.getId().toString();
            OrgTypeRelationInfo adminToCostRelationInfo = iTypeRelation.getOrgTypeRelationInfo("where fromType=0and toType=5");
            String adminToCostID = adminToCostRelationInfo.getId().toString();
            OrgTypeRelationInfo CostToFIRelationInfo = iTypeRelation.getOrgTypeRelationInfo("where fromType=5and toType=1");
            String costToFIID = CostToFIRelationInfo.getId().toString();
            int adminToFIIndex = -1;
            int adminToCost = -1;
            OrgUnitRelationInfo adminToFIInfo = null;
            OrgUnitRelationInfo adminToCostInfo = null;
            OrgUnitRelationInfo costToFIInfo = null;
            int n2 = relationCol.size();
            for (int i = 0; i < n2; ++i) {
                OrgUnitRelationInfo info = relationCol.get(i);
                if (info.getTypeRelation().getId().toString().equals(adminToFIID)) {
                    adminToFIInfo = info;
                    adminToFIIndex = i;
                }
                if (info.getTypeRelation().getId().toString().equals(adminToCostID)) {
                    adminToCostInfo = info;
                    adminToCost = i;
                }
                if (!info.getTypeRelation().getId().toString().equals(costToFIID)) continue;
                costToFIInfo = info;
            }
            boolean isValid = this.checkAdminDelegate(ctx, true, adminToFIInfo, adminToCostInfo, costToFIInfo);
            if (!isValid) {
                throw new OUException(OUException.ADMIN_DELEGATE_ERROR);
            }
            int n3 = relationCol.size();
            for (int i = 0; i < n3; ++i) {
                OrgUnitRelationInfo info = relationCol.get(i);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                pstmt.setString(2, info.getFromUnit().getId().toString());
                pstmt.setString(3, info.getToUnit().getId().toString());
                pstmt.setString(4, info.getTypeRelation().getId().toString());
                pstmt.setBoolean(5, info.isIsDefault());
                pstmt.setString(6, info.getVersionNumber());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            OrgCacheFactory.getOrgCache(ctx).removeAllOrgUnitRelationCollectionCache();
        }
        catch (Exception e) {
            try {
                SQLException sqle;
                logger.error((Object)"batch addnew OrgUnitRelation error! \n", (Throwable)e);
                if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                    logger.error((Object)"**************************** Next exception is: ***************************", (Throwable)sqle);
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)cn);
    }

    private boolean checkAdminDelegate(Context ctx, boolean isForList, OrgUnitRelationInfo adminToFIRelInfo, OrgUnitRelationInfo adminToCostRelInfo, OrgUnitRelationInfo costToFIRelInfo) throws EASBizException, BOSException {
        String[] adminDelComLongnumber;
        FullOrgUnitInfo adminInfo = null;
        FullOrgUnitInfo adminToComInfo = null;
        FullOrgUnitInfo adminToCostCenterInfo = null;
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance(ctx);
        if (isForList) {
            if (adminToFIRelInfo != null) {
                adminToComInfo = adminToFIRelInfo.getToUnit();
                adminInfo = adminToFIRelInfo.getFromUnit();
            }
            if (adminToCostRelInfo != null) {
                adminToCostCenterInfo = adminToCostRelInfo.getToUnit();
                adminInfo = adminToCostRelInfo.getFromUnit();
            }
        } else if (adminToFIRelInfo == null) {
            adminToCostCenterInfo = adminToCostRelInfo.getToUnit();
            adminInfo = adminToCostRelInfo.getFromUnit();
            OrgUnitCollection adminToComCol = iOrgRelation.getToUnit(adminInfo.getId().toString(), 0, 1);
            if (adminToComCol != null && adminToComCol.size() == 1) {
                adminToComInfo = adminToComCol.get(0).castToFullOrgUnitInfo();
            }
        } else {
            adminToComInfo = adminToFIRelInfo.getToUnit();
            adminInfo = adminToFIRelInfo.getFromUnit();
            OrgUnitCollection adminToCostCol = iOrgRelation.getToUnit(adminInfo.getId().toString(), 0, 5);
            if (adminToCostCol != null && adminToCostCol.size() == 1) {
                adminToCostCenterInfo = adminToCostCol.get(0).castToFullOrgUnitInfo();
            }
        }
        if (adminToComInfo == null || adminToCostCenterInfo == null) {
            return true;
        }
        if (adminToComInfo.getId().toString().equals(adminToCostCenterInfo.getId().toString())) {
            return true;
        }
        FullOrgUnitInfo delegatedCostToFIInfo = null;
        if (isForList && adminInfo.getId().toString().equals(adminToCostCenterInfo.getId().toString())) {
            if (costToFIRelInfo != null) {
                delegatedCostToFIInfo = costToFIRelInfo.getToUnit();
            }
        } else {
            OrgUnitCollection toFIUnitCol = iOrgRelation.getToUnit(adminToCostCenterInfo.getId().toString(), 5, 1);
            if (toFIUnitCol != null && toFIUnitCol.size() == 1) {
                delegatedCostToFIInfo = toFIUnitCol.get(0).castToFullOrgUnitInfo();
            }
        }
        if (delegatedCostToFIInfo != null && adminToComInfo.getId().toString().equals(delegatedCostToFIInfo.getId().toString())) {
            return true;
        }
        String[] adminDelCLongnumber = adminToCostCenterInfo.getLongNumber().split("!");
        if (adminDelCLongnumber.length > (adminDelComLongnumber = adminToComInfo.getLongNumber().split("!")).length) {
            boolean isSuperior = true;
            for (int i = 0; i < adminDelComLongnumber.length; ++i) {
                if (adminDelCLongnumber[i].equals(adminDelComLongnumber[i])) continue;
                isSuperior = false;
                break;
            }
            if (isSuperior) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected IObjectCollection _getFromUnit(Context ctx, String toUnitID, int toUnitType, int fromUnitType, SelectorItemCollection selectors) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("fromUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit", (Object)toUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(toUnitType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromUnitType), CompareType.EQUALS));
        view.setFilter(filter);
        OrgUnitRelationCollection relCol = this.getOrgUnitRelationCollection(ctx, view);
        ArrayList<String> orgIdList = new ArrayList<String>();
        int n = relCol.size();
        for (int i = 0; i < n; ++i) {
            String fromUnitID = relCol.get(i).getFromUnit().getId().toString();
            orgIdList.add(fromUnitID);
        }
        return this.getStrongTypeCollection(ctx, fromUnitType, orgIdList, selectors);
    }

    @Override
    protected List _existsToUnit(Context ctx, Set fromUnitIdSet, int fromUnitType, int toUnitType) throws BOSException, EASBizException {
        ArrayList<OrgUnitInfo> existsToUnitList = new ArrayList<OrgUnitInfo>();
        for (OrgUnitInfo info : fromUnitIdSet) {
            IObjectCollection col = this._getToUnit(ctx, info.getId().toString(), fromUnitType, toUnitType);
            if (col.size() <= 0) continue;
            existsToUnitList.add(info);
        }
        return existsToUnitList;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isValid;
        OrgUnitRelationInfo info = (OrgUnitRelationInfo)model;
        IOrgTypeRelation iTypeRelation = OrgTypeRelationFactory.getLocalInstance(ctx);
        OrgTypeRelationInfo typeRelationInfo = iTypeRelation.getOrgTypeRelationInfo((IObjectPK)new ObjectUuidPK(info.getTypeRelation().getId()));
        int fromValue = typeRelationInfo.getFromType().getValue();
        int toValue = typeRelationInfo.getToType().getValue();
        if (0 == fromValue && 1 == toValue && !(isValid = this.checkAdminDelegate(ctx, false, info, null, null))) {
            throw new OUException(OUException.ADMIN_DELEGATE_ERROR);
        }
        if (0 == fromValue && 5 == toValue && !(isValid = this.checkAdminDelegate(ctx, false, null, info, null))) {
            throw new OUException(OUException.ADMIN_DELEGATE_ERROR);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        return pk;
    }

    protected void _update(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isValid;
        OrgUnitRelationInfo info = (OrgUnitRelationInfo)model;
        IOrgTypeRelation iTypeRelation = OrgTypeRelationFactory.getLocalInstance(ctx);
        OrgTypeRelationInfo typeRelationInfo = iTypeRelation.getOrgTypeRelationInfo((IObjectPK)new ObjectUuidPK(info.getTypeRelation().getId()));
        int fromValue = typeRelationInfo.getFromType().getValue();
        int toValue = typeRelationInfo.getToType().getValue();
        if (0 == fromValue && 1 == toValue && !(isValid = this.checkAdminDelegate(ctx, false, info, null, null))) {
            throw new OUException(OUException.ADMIN_DELEGATE_ERROR);
        }
        if (0 == fromValue && 5 == toValue && !(isValid = this.checkAdminDelegate(ctx, false, null, info, null))) {
            throw new OUException(OUException.ADMIN_DELEGATE_ERROR);
        }
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    @Override
    protected List _addNewBatch(Context ctx, IObjectCollection col) throws BOSException {
        PreparedStatement pstmt;
        Connection cn;
        block12: {
            boolean isValid;
            OrgUnitRelationInfo relationInfo;
            int i;
            OrgUnitRelationCollection relationCol = (OrgUnitRelationCollection)col;
            ArrayList<OrgUnitRelationInfo> failAddrelationList = new ArrayList<OrgUnitRelationInfo>();
            cn = null;
            pstmt = null;
            String insertSql = new StringBuffer("INSERT INTO T_ORG_UnitRelation").append("(FID, FFromUnitID, FToUnitID, FTypeRelationID, FIsDefault, FVersionNumber) ").append("VALUES(?, ?, ?, ?, ?, ?)").toString();
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(insertSql);
            OrgUnitRelationInfo info = relationCol.get(0);
            IOrgTypeRelation iTypeRelation = OrgTypeRelationFactory.getLocalInstance(ctx);
            OrgTypeRelationInfo typeRelationInfo = iTypeRelation.getOrgTypeRelationInfo((IObjectPK)new ObjectUuidPK(info.getTypeRelation().getId()));
            int fromValue = typeRelationInfo.getFromType().getValue();
            int toValue = typeRelationInfo.getToType().getValue();
            if (0 == fromValue && 1 == toValue) {
                for (i = relationCol.size() - 1; i >= 0; --i) {
                    relationInfo = relationCol.get(i);
                    isValid = this.checkAdminDelegate(ctx, false, relationInfo, null, null);
                    if (isValid) continue;
                    relationCol.removeObject(i);
                    failAddrelationList.add(relationInfo);
                }
            }
            if (0 == fromValue && 5 == toValue) {
                for (i = relationCol.size() - 1; i >= 0; --i) {
                    relationInfo = relationCol.get(i);
                    isValid = this.checkAdminDelegate(ctx, false, null, relationInfo, null);
                    if (isValid) continue;
                    relationCol.removeObject(i);
                    failAddrelationList.add(relationInfo);
                }
            }
            int n = relationCol.size();
            for (i = 0; i < n; ++i) {
                OrgUnitRelationInfo unitRelInfo = relationCol.get(i);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                pstmt.setString(2, unitRelInfo.getFromUnit().getId().toString());
                pstmt.setString(3, unitRelInfo.getToUnit().getId().toString());
                pstmt.setString(4, unitRelInfo.getTypeRelation().getId().toString());
                pstmt.setBoolean(5, unitRelInfo.isIsDefault());
                pstmt.setString(6, unitRelInfo.getVersionNumber());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (failAddrelationList.size() <= 0) break block12;
            ArrayList<String> failRelInfo = new ArrayList<String>();
            for (int i2 = 0; i2 < failAddrelationList.size(); ++i2) {
                OrgUnitRelationInfo relationInfo2 = (OrgUnitRelationInfo)failAddrelationList.get(i2);
                FullOrgUnitInfo fromUnitInfo = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(relationInfo2.getFromUnit().getId().toString()));
                FullOrgUnitInfo toUnitInfo = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(relationInfo2.getToUnit().getId().toString()));
                String erroRelation = fromUnitInfo.getName() + "-" + toUnitInfo.getName();
                failRelInfo.add(erroRelation);
            }
            ArrayList<String> arrayList = failRelInfo;
            SQLUtils.cleanup((Statement)pstmt, (Connection)cn);
            return arrayList;
        }
        try {
            OrgCacheFactory.getOrgCache(ctx).removeAllOrgUnitRelationCollectionCache();
        }
        catch (Exception e) {
            try {
                SQLException sqle;
                logger.error((Object)"batch addnew OrgUnitRelation error! \n", (Throwable)e);
                if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                    logger.error((Object)"**************************** Next exception is: ***************************", (Throwable)sqle);
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)cn);
        return null;
    }
}

