/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.app.di.OrgDIBase;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class OUDI
extends OrgDIBase {
    @Override
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String number = this.getFieldValue(hsData, "FNumber");
        String code = this.getFieldValue(hsData, "FCode");
        String parent = this.getFieldValue(hsData, "FParentID");
        String name_l1 = this.getFieldValue(hsData, "FName_L1");
        String name_l2 = this.getFieldValue(hsData, "FName_L2");
        String name_l3 = this.getFieldValue(hsData, "FName_L3");
        String simple = this.getFieldValue(hsData, "FSimpleName");
        String desc_l1 = this.getFieldValue(hsData, "FDescription_L1");
        String desc_l2 = this.getFieldValue(hsData, "FDescription_L2");
        String desc_l3 = this.getFieldValue(hsData, "FDescription_L3");
        FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkRequeiredField(ctx, "FParentID", parent);
        unitInfo.setParent(this.getFullOrgUnitInfo4Common(ctx, parent));
        this.checkInCurrentUserOrgRange(ctx, number, parent);
        this.checkParentExisted(ctx, parent);
        if (new Locale("L1").equals(ctx.getLocale())) {
            this.checkRequeiredField(ctx, "FName_L1", name_l1);
        } else if (new Locale("L2").equals(ctx.getLocale())) {
            this.checkRequeiredField(ctx, "FName_L2", name_l2);
        } else {
            this.checkRequeiredField(ctx, "FName_L3", name_l3);
        }
        super.checkAllInvalidChar(hsData);
        this.verifyOrgNameDup(ctx, hsData);
        if (number != null && number.length() != 0) {
            unitInfo.setNumber(number);
        }
        if (code != null && code.length() != 0) {
            unitInfo.setCode(code);
        }
        if (name_l1 != null && name_l1.length() != 0) {
            unitInfo.setName(name_l1, new Locale("L1"));
        }
        if (name_l2 != null && name_l2.length() != 0) {
            unitInfo.setName(name_l2, new Locale("L2"));
        }
        if (name_l3 != null && name_l3.length() != 0) {
            unitInfo.setName(name_l3, new Locale("L3"));
        }
        if (simple != null && simple.length() != 0) {
            unitInfo.setSimpleName(simple);
        }
        if (desc_l1 != null && desc_l1.length() != 0) {
            unitInfo.setDescription(desc_l1, new Locale("L1"));
        }
        if (desc_l2 != null && desc_l2.length() != 0) {
            unitInfo.setDescription(desc_l2, new Locale("L2"));
        }
        if (desc_l3 != null && desc_l3.length() != 0) {
            unitInfo.setDescription(desc_l3, new Locale("L3"));
        }
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        if (this.isImpModeUpdate()) {
            fullOrgUnitInfo = this.getFullOrgUnitInfo(ctx, unitInfo);
        }
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(fullOrgUnitInfo);
        String orgTypes = orgTypeHelper.createOrgTypeStrBySet();
        unitInfo.setIsAdminOrgUnit(orgTypeHelper.isOrgType(OrgType.Admin));
        unitInfo.setIsAssistantOrg(fullOrgUnitInfo.isIsAssistantOrg());
        unitInfo.setIsCompanyOrgUnit(orgTypeHelper.isOrgType(OrgType.Company));
        unitInfo.setIsHROrgUnit(orgTypeHelper.isOrgType(OrgType.HRO));
        unitInfo.setIsCostOrgUnit(orgTypeHelper.isOrgType(OrgType.CostCenter));
        unitInfo.setIsCU(orgTypeHelper.isOrgType(OrgType.CostCenter));
        unitInfo.setIsProfitOrgUnit(orgTypeHelper.isOrgType(OrgType.ProfitCenter));
        unitInfo.setIsPurchaseOrgUnit(orgTypeHelper.isOrgType(OrgType.Purchase));
        unitInfo.setIsTransportOrgUnit(orgTypeHelper.isOrgType(OrgType.Transport));
        unitInfo.setIsSaleOrgUnit(orgTypeHelper.isOrgType(OrgType.Sale));
        unitInfo.setIsStorageOrgUnit(orgTypeHelper.isOrgType(OrgType.Storage));
        unitInfo.setIsUnion(orgTypeHelper.isOrgType(OrgType.UnionDebt));
        unitInfo.setIsQualityOrgUnit(orgTypeHelper.isOrgType(OrgType.Quality));
        unitInfo.setOrgTypeStr(orgTypes);
        unitInfo.setIsCU(orgTypeHelper.isOrgType(OrgType.ControlUnit));
        BOSUuid pk = fullOrgUnitInfo.getId();
        if (!this.isImpModeUpdate()) {
            this.setCU(ctx, unitInfo, parent);
        } else {
            Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
            Iterator orgIt = orgTypeCol.iterator();
            IDynamicObject iDynamicObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
            while (orgIt.hasNext()) {
                OrgTypeInfo orgTypeInfo = (OrgTypeInfo)orgIt.next();
                if (!orgTypeHelper.isOrgType(orgTypeInfo.getOrgType()) || !orgTypeInfo.isBasicOrgType() || unitInfo.getPartInfo(orgTypeInfo.getOrgType()) != null) continue;
                BOSObjectType bosType = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType()).getOrgTypeSelfInfo().getOrgTableBosType();
                unitInfo.setPartInfo(orgTypeInfo.getOrgType(), (OUPartCoreBaseInfo)iDynamicObj.getValue(bosType, "where unit.id = '" + pk.toString() + "'"));
            }
        }
        BizParentAndDelegateInfo pdInfo = new BizParentAndDelegateInfo();
        if (pk != null) {
            INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getLocalInstance(ctx);
            pdInfo = iNOUI.loadSuperiorAndDelegateUnits((IObjectPK)new ObjectUuidPK(pk));
        }
        unitInfo.put("PDValueInfo", pdInfo);
        return unitInfo;
    }

    private boolean isImpModeUpdate() {
        return (Integer)this.getContextParameter().get("DATATASKMODE") == 16;
    }

    private boolean isHaveSetOrgTypes(Context ctx, FullOrgUnitInfo unitInfo) throws Exception {
        String oql = "select id,orgTypeStr,isAdminOrgUnit,isCompanyOrgUnit,isCU,isCostOrgUnit,isHROrgUnit,isProfitOrgUnit,isPurchaseOrgUnit,isQualityOrgUnit,isSaleOrgUnit,isStorageOrgUnit,isTransportOrgUnit,isUnion where number='" + unitInfo.getNumber() + "' and isUnion = '" + 0 + "'";
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance(ctx);
        boolean isNotNew = iFullOrgUnit.exists(oql);
        if (isNotNew) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)iFullOrgUnit.getDataBaseInfo(oql);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper(info);
            Set orgTypes = orgTypeHelper.getAllSelectOrgTypeSet();
            HashSet<OrgType> notBizOrgTypes = new HashSet<OrgType>();
            notBizOrgTypes.add(OrgType.ControlUnit);
            notBizOrgTypes.add(OrgType.NONE);
            orgTypes.removeAll(notBizOrgTypes);
            if (orgTypes.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private FullOrgUnitInfo getFullOrgUnitInfo(Context ctx, FullOrgUnitInfo unitInfo) throws Exception {
        String oql = "select id,orgTypeStr,isAdminOrgUnit,isCompanyOrgUnit,isCU,isCostOrgUnit,isHROrgUnit,isProfitOrgUnit,isPurchaseOrgUnit,isQualityOrgUnit,isSaleOrgUnit,isStorageOrgUnit,isTransportOrgUnit,ISASSISTANTORG,isUnion where number='" + unitInfo.getNumber() + "' and isUnion = '" + 0 + "'";
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo info = (FullOrgUnitInfo)iFullOrgUnit.getDataBaseInfo(oql);
        return info;
    }

    private void checkParentAtTheSameCU(Context ctx, String number, String parent) throws Exception {
        String currentCUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String oql = new StringBuffer().append("select CU.id where number = '").append(parent).append("'").toString();
        String parentCUID = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo(oql).getCU().getId().toString();
        if (!currentCUID.equals(parentCUID)) {
            StringBuffer message = new StringBuffer();
            Locale currentLocale = ctx.getLocale();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"PLEASE_CHANGE", (Locale)currentLocale));
            message.append(number);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"PARENT_CODE", (Locale)currentLocale));
            message.append(parent);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"IMPORTING", (Locale)currentLocale));
            throw new Exception(message.toString());
        }
    }

    private void setCU(Context ctx, FullOrgUnitInfo unitInfo, String parent) throws EASBizException, BOSException {
        String oql = new StringBuffer().append("select CU.id where number = '").append(parent).append("'").toString();
        unitInfo.setCU(FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo(oql).getCU());
    }

    private void checkInCurrentUserOrgRange(Context ctx, String number, String parent) throws Exception {
        if (Administrator.isSuperCUAdmin((IObjectPK)ctx.getCaller())) {
            return;
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("type"));
        selectors.add(new SelectorItemInfo("bizAdmin"));
        UserInfo userInfo = iUser.getUserInfo(ctx.getCaller(), selectors);
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance(ctx);
        StringBuffer selectOql = new StringBuffer();
        String msg = "";
        Object[] param = new Object[]{parent};
        if (UserType.SYSTEM.equals((Object)userInfo.getType())) {
            selectOql.append(" where number ='").append(parent).append("'").append(" and CU.id in(select og.forgid from T_PM_ORGRANGE og where ").append(" og.fuserid='").append(ctx.getCaller().toString()).append("' and ftype = 10)");
            msg = EASCommonResource.getString((String)this.RESOURCE_FILE_NAME, (String)"OU_Not_CurrentUser_OrgRange", (Locale)ctx.getLocale());
        } else if (userInfo.isBizAdmin()) {
            selectOql.append(" where number ='").append(parent).append("'").append(" and CU.id in(select og.forgid from T_PM_ORGRANGE og where ").append(" og.fuserid='").append(ctx.getCaller().toString()).append("' and ftype = 30)");
            msg = EASCommonResource.getString((String)this.RESOURCE_FILE_NAME, (String)"OU_Not_CurrentUser_Range", (Locale)ctx.getLocale());
        } else {
            selectOql.append(" where number ='").append(parent).append("'").append(" and CU.id in(select ou.FControlUnitID from T_PM_ORGRANGE og join t_org_baseUnit ou on og.forgId=ou.fid where ").append(" og.fuserid='").append(ctx.getCaller().toString()).append("' and ftype = 10)");
            msg = EASCommonResource.getString((String)this.RESOURCE_FILE_NAME, (String)"OU_Not_CurrentUser_OrgRange", (Locale)ctx.getLocale());
        }
        if (!iFullOrgUnit.exists(selectOql.toString())) {
            throw new Exception(MessageFormat.format(msg, param));
        }
    }

    private void verifyOrgNameDup(Context ctx, Hashtable hsData) throws Exception {
        String number = hsData.get("FNumber").toString();
        String parent = hsData.get("FParentID").toString();
        String name_l1 = hsData.get("FName_L1").toString();
        String name_l2 = hsData.get("FName_L2").toString();
        String name_l3 = hsData.get("FName_L3").toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 1 FROM T_ORG_BASEUNIT WHERE ");
        if (!"".equals(name_l1) || !"".equals(name_l3)) {
            sql.append("(");
        }
        sql.append("FNAME_L2 = '").append(name_l2).append("'");
        if (!"".equals(name_l1) && "".equals(name_l3)) {
            sql.append("OR FNAME_L1 = '").append(name_l1).append("')");
        } else if (!"".equals(name_l3) && "".equals(name_l1)) {
            sql.append("OR FNAME_L3 = '").append(name_l3).append("')");
        } else if (!"".equals(name_l1) && !"".equals(name_l3)) {
            sql.append("OR FNAME_L1 = '").append(name_l1).append("' OR FNAME_L3 = '").append(name_l3).append("')");
        }
        sql.append(" AND FNUMBER <> '").append(number).append("'");
        sql.append(" AND FParentID = (SELECT FID FROM T_ORG_BASEUNIT WHERE FNUMBER ='").append(parent).append("')");
        sql.append(" AND FISUNION = 0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            throw new OUException(OUException.NAME_DUP);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            String description;
            String simpleName;
            String parentNumber;
            result.put("FNumber", rs.getString("number"));
            String code = rs.getString("code");
            if (code != null) {
                result.put("FCode", code);
            }
            if ((parentNumber = rs.getString("parent.number")) != null) {
                result.put("FParentID", parentNumber);
            }
            Locale currentLocale = ctx.getLocale();
            String name = rs.getString("name");
            if (name != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FName_L1", name);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FName_L2", name);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FName_L3", name);
                }
            }
            if ((simpleName = rs.getString("simpleName")) != null) {
                result.put("FSimpleName", simpleName);
            }
            if ((description = rs.getString("description")) != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FDescription_L1", description);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FDescription_L2", description);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FDescription_L3", description);
                }
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", createTime.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String id = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)id, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isUnion", (Object)new Integer(0), CompareType.EQUALS));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.OUExportQuery";
    }
}

