/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import java.util.Hashtable;
import java.util.Locale;

public abstract class OrgDIBase
extends AbstractDataTransmission {
    protected String RESOURCE_FILE_NAME = "com.kingdee.eas.basedata.org.ImportResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        IFullOrgUnit iCoreBase = null;
        try {
            iCoreBase = this.getBizInterface(ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return iCoreBase;
    }

    protected IFullOrgUnit getBizInterface(Context ctx) throws Exception {
        return FullOrgUnitFactory.getLocalInstance(ctx);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            CoreBaseInfo newData = this.createNewData(hsData, ctx);
            this.injectIDWhenUpdate(newData, ctx);
            return newData;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract CoreBaseInfo createNewData(Hashtable var1, Context var2) throws Exception;

    protected void injectIDWhenUpdate(CoreBaseInfo newData, Context ctx) throws Exception {
        BOSUuid id;
        if ((Integer)this.getContextParameter().get("DATATASKMODE") == 16 && (id = this.getID(newData, ctx)) != null) {
            newData.setId(id);
        }
    }

    protected BOSUuid getID(CoreBaseInfo newData, Context ctx) throws Exception {
        String propertyName = this.getPropertyNameWithWhichTheIDCanBeFound();
        String propertyValue = newData.get(propertyName).toString();
        StringBuffer oql = new StringBuffer(50);
        oql.append("select id where ").append(propertyName).append(" = '").append(propertyValue).append("'");
        BOSUuid id = null;
        if (this.getBizInterface(ctx).exists(oql.toString())) {
            id = this.getBizInterface(ctx).getValue(oql.toString()).getId();
        }
        return id;
    }

    protected String getPropertyNameWithWhichTheIDCanBeFound() throws Exception {
        return "number";
    }

    protected String getFieldValue(Hashtable hsData, String key) {
        if (hsData.get(key) != null && ((DataToken)hsData.get((Object)key)).data != null) {
            return ((String)((DataToken)hsData.get((Object)key)).data).trim();
        }
        return "";
    }

    protected CoreBaseInfo getCoreBaseInfo(ICoreBase iCoreBase, String number) throws Exception {
        StringBuffer oql = new StringBuffer(20);
        oql.append("where number = '").append(number).append("'");
        CoreBaseInfo coreBaseInfo = null;
        if (iCoreBase.exists(oql.toString())) {
            coreBaseInfo = iCoreBase.getValue(oql.toString());
        }
        return coreBaseInfo;
    }

    protected FullOrgUnitInfo getFullOrgUnitInfo4Common(Context ctx, String number) throws Exception {
        String oql = new StringBuffer().append("where number = '").append(number).append("'").toString();
        FullOrgUnitInfo unitInfo = this.getBizInterface(ctx).getFullOrgUnitInfo(oql.toString());
        return unitInfo;
    }

    protected void checkRequeiredField(Context ctx, String field, String value) throws Exception {
        if (value == null || value.trim().length() == 0) {
            StringBuffer message = new StringBuffer();
            Locale currentLocale = ctx.getLocale();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"FIELD", (Locale)currentLocale));
            message.append(field);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"NOT_NULL", (Locale)currentLocale));
            throw new Exception(message.toString());
        }
    }

    protected void checkParentExisted(Context ctx, String parent) throws Exception {
        if (parent != null && parent.trim().length() != 0 && !FullOrgUnitFactory.getLocalInstance(ctx).exists(new StringBuffer("where number = '").append(parent).append("'").toString())) {
            StringBuffer message = new StringBuffer();
            Locale currentLocale = ctx.getLocale();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)currentLocale));
            message.append(parent);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"PARENT_NOT_EXISTED", (Locale)currentLocale));
            throw new Exception(message.toString());
        }
    }

    protected void checkAllInvalidChar(Hashtable hsData) throws Exception {
        String number = hsData.get("FNumber").toString();
        String parent = hsData.get("FParentID").toString();
        String name_l1 = hsData.get("FName_L1").toString();
        String name_l2 = hsData.get("FName_L2").toString();
        String name_l3 = hsData.get("FName_L3").toString();
        String[] allInvalidChar = OrgToolUtils.allInvalidChar();
        for (int i = 0; i < allInvalidChar.length; ++i) {
            String invalidChar = allInvalidChar[i];
            if (number.trim().indexOf(invalidChar) != -1 || parent.trim().indexOf(invalidChar) != -1) {
                throw new OrgBlankException(OrgBlankException.NUMBER_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
            }
            if (name_l2.trim().indexOf(invalidChar) == -1 && name_l1.trim().indexOf(invalidChar) == -1 && name_l3.trim().indexOf(invalidChar) == -1) continue;
            throw new OrgBlankException(OrgBlankException.NAME_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
        }
    }
}

