/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.basedata.org.app.helper.DefaultUnitDirectTreeNode;
import com.kingdee.eas.basedata.org.app.helper.TreeNodeTypeAssemblage;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BizOrgRangeDirectTreeNode
extends DefaultUnitDirectTreeNode {
    private static Logger logger = Logger.getLogger((String)BizOrgRangeDirectTreeNode.class.getName());

    public BizOrgRangeDirectTreeNode() {
    }

    public BizOrgRangeDirectTreeNode(TreeNodeTypeAssemblage assemblage) {
        super(assemblage);
    }

    public BizOrgRangeDirectTreeNode(TreeNodeTypeAssemblage assemblage, List filters) {
        super(assemblage, filters);
    }

    @Override
    public List getDirectTreeNode(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        if (selectedNode instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)selectedNode;
            if (!unitInfo.isIsUnion()) {
                result.addAll(super.getNodesByAllQueryItem(ctx, selectedNode, assistInfo));
                if (unitInfo.isIsCU() && !assistInfo.isIgnoreUnionAndMaintain() && "00000000-0000-0000-0000-000000000000CCE7AED4".equals(unitInfo.getId().toString())) {
                    result.addAll(this.getUnionAndMaintain(ctx, assistInfo, unitInfo));
                }
            } else {
                result.addAll(this.getChildrenOnUnion(ctx, assistInfo, unitInfo));
            }
        } else if (selectedNode instanceof OrgTreeInfo) {
            OrgTreeInfo treeInfo = (OrgTreeInfo)selectedNode;
            return this.getSQL4Tree(ctx, assistInfo, treeInfo);
        }
        return result;
    }

    private List getSQL4Tree(Context ctx, OrgAssistInfo newOrgF7AssistInfo, OrgTreeInfo selectedNode) throws EASBizException, BOSException {
        ArrayList<FullOrgUnitInfo> result;
        block5: {
            result = new ArrayList<FullOrgUnitInfo>();
            String oql = this.appendTreeQuery(ctx, newOrgF7AssistInfo, selectedNode);
            try {
                OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureInfo(oql);
                if (structInfo == null) break block5;
                FullOrgUnitInfo unitInfo = structInfo.getUnit();
                unitInfo.setString("structLongNumber", structInfo.getLongNumber());
                unitInfo.setIsLeaf(structInfo.isIsLeaf());
                unitInfo.setString("treeId", selectedNode.getId().toString());
                unitInfo.setString("parentUnitId", selectedNode.getString("parentUnitId"));
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FCONTROLUNITID  from t_org_tree where fid = '" + structInfo.getTree().getId().toString() + "'"));
                    if (rs.next()) {
                        String treeCUID = rs.getString("FCONTROLUNITID");
                        unitInfo.setString("treeCUID", treeCUID);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                result.add(unitInfo);
            }
            catch (ObjectNotFoundException e) {
                logger.warn((Object)"no suitable record.");
            }
        }
        return result;
    }

    private String appendTreeQuery(Context ctx, OrgAssistInfo newOrgF7AssistInfo, OrgTreeInfo selectedNode) {
        StringBuffer oql = new StringBuffer();
        oql.append("select unit.id, unit.name, longnumber, isleaf, unit.isunion ").append(" where unit.isunion = 1 and tree.id = '").append(selectedNode.getId().toString()).append("'").append(" and level = 1 ").append(" and (tree.CU.id in (").append(this.getCuIDs(ctx)).append(")").append(this.appendMaintainCU(newOrgF7AssistInfo.isDisplayMaintain(), this.getCuIDs(ctx))).append(")");
        return oql.toString();
    }

    private List getUnionAndMaintain(Context ctx, OrgAssistInfo newOrgF7AssistInfo, FullOrgUnitInfo selectedNode) throws BOSException {
        ArrayList<OrgTreeInfo> result = new ArrayList<OrgTreeInfo>();
        if (newOrgF7AssistInfo.isIgnoreUnionAndMaintain()) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select tree.id, tree.name, tree.startDate, tree.endDate, tree.isVersioned where ").append(this.appendUnionAndMaintainQuery(ctx, newOrgF7AssistInfo, this.getCuIDs(ctx)));
        if (!StringUtils.isEmpty((String)newOrgF7AssistInfo.getQuickQueryValue())) {
            sql.append(" and ").append(this.appendQuickQueryOQL(newOrgF7AssistInfo));
        }
        sql.append(" order by tree.number, tree.startDate");
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(sql.toString());
        List unionRange = this.getDistinctOrgTreeInfo(structCol);
        if (unionRange != null) {
            int j = unionRange.size();
            for (int i = 0; i < j; ++i) {
                OrgTreeInfo info = (OrgTreeInfo)unionRange.get(i);
                info.setString("parentUnitId", selectedNode.getId().toString());
                result.add(info);
            }
        }
        return result;
    }

    private List getDistinctOrgTreeInfo(OrgStructureCollection structCol) {
        ArrayList<OrgTreeInfo> result = new ArrayList<OrgTreeInfo>();
        if (structCol != null && structCol.size() > 0) {
            int n = structCol.size();
            for (int i = 0; i < n; ++i) {
                OrgTreeInfo treeInfo = structCol.get(i).getTree();
                if (result.contains(treeInfo)) continue;
                result.add(treeInfo);
            }
        }
        return result;
    }

    private String appendUnionAndMaintainQuery(Context ctx, OrgAssistInfo newOrgF7AssistInfo, String unitIDs) {
        StringBuffer sql = new StringBuffer();
        sql.append(" tree.type = 8 and ").append(" unit.isunion = 1 and ").append(" (tree.status = ").append(UnionVersionStatusEnum.START.getValue()).append(" or tree.status = ").append(UnionVersionStatusEnum.ARCHIVE.getValue()).append(")").append(" and (").append(" tree.CU.id in (").append(unitIDs).append(")").append(this.appendMaintainCU(newOrgF7AssistInfo.isDisplayMaintain(), unitIDs)).append(")").append(this.appendOrgRange(ctx, newOrgF7AssistInfo));
        return sql.toString();
    }

    private StringBuffer appendMaintainCU(boolean isDisplayMaintain, String cuIDs) {
        StringBuffer maintainOQL = new StringBuffer();
        if (isDisplayMaintain && !StringUtils.isEmpty((String)cuIDs)) {
            maintainOQL.append(" or (unit.maintainCU.id in (").append(cuIDs).append(")").append(" and tree.CU.id not in (").append(cuIDs).append(")").append(")");
        }
        return maintainOQL;
    }

    private String getCuIDs(Context ctx) {
        String sql = null;
        boolean isCUAdmin = false;
        try {
            isCUAdmin = Administrator.isCUAdmin((Context)ctx, (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        sql = isCUAdmin ? "select forgid from t_pm_orgrange where fuserid = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId() + "' and ftype = " + 10 : "select unit.fcontrolunitid from t_pm_orgrange range inner join t_org_baseunit unit on range.forgid = unit.fid where fuserid = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId() + "' and ftype = " + 30;
        return sql;
    }

    private String appendQuickQueryOQL(OrgAssistInfo newOrgF7AssistInfo) {
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)newOrgF7AssistInfo.getQuickQueryValue())) {
            if (newOrgF7AssistInfo.isBlured()) {
                if (newOrgF7AssistInfo.getQuickQueryField() == 2) {
                    result.append(" unit.name like '%").append(newOrgF7AssistInfo.getQuickQueryValue()).append("%'");
                } else if (newOrgF7AssistInfo.getQuickQueryField() == 1) {
                    result.append(" unit.number like '%").append(newOrgF7AssistInfo.getQuickQueryValue()).append("%'");
                } else if (newOrgF7AssistInfo.getQuickQueryField() == 8) {
                    result.append(" (unit.name like '%").append(newOrgF7AssistInfo.getQuickQueryValue()).append("%'").append(" or ").append(" unit.number like '%").append(newOrgF7AssistInfo.getQuickQueryValue()).append("%')");
                } else if (newOrgF7AssistInfo.getQuickQueryField() == 5) {
                    result.append(" unit.code like '%").append(newOrgF7AssistInfo.getQuickQueryValue()).append("%'");
                }
            } else if (newOrgF7AssistInfo.getQuickQueryField() == 2) {
                result.append(" unit.name = '").append(newOrgF7AssistInfo.getQuickQueryValue()).append("'");
            } else if (newOrgF7AssistInfo.getQuickQueryField() == 1) {
                result.append(" unit.number = '").append(newOrgF7AssistInfo.getQuickQueryValue()).append("'");
            } else if (newOrgF7AssistInfo.getQuickQueryField() == 8) {
                result.append(" (unit.name = '").append(newOrgF7AssistInfo.getQuickQueryValue()).append("'").append(" or ").append(" unit.number = '").append(newOrgF7AssistInfo.getQuickQueryValue()).append("')");
            } else if (newOrgF7AssistInfo.getQuickQueryField() == 5) {
                result.append(" unit.code = '").append(newOrgF7AssistInfo.getQuickQueryValue()).append("'");
            }
        }
        return result.toString();
    }

    private String appendOrgRange(Context ctx, OrgAssistInfo newOrgF7AssistInfo) {
        StringBuffer oql = new StringBuffer();
        if (!StringUtils.isEmpty((String)newOrgF7AssistInfo.getOrgRangeSQL())) {
            oql.append(" and tree.id in (");
            oql.append("select FTREEID  from T_ORG_STRUCTURE where FUNITID in (select ff.fid from t_org_baseunit ff where ff.FMAINTAINCUID is not null and  ff.FID  in (");
            oql.append(newOrgF7AssistInfo.getOrgRangeSQL());
            oql.append("))");
            oql.append(")");
        }
        return oql.toString();
    }

    private List getChildrenOnUnion(Context ctx, OrgAssistInfo newOrgF7AssistInfo, FullOrgUnitInfo selectedNode) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        String querySQL = this.getUnionSubNodesOQL(ctx, newOrgF7AssistInfo, selectedNode);
        OrgStructureCollection coll = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureCollection(querySQL);
        if (coll == null || coll.size() == 0) {
            return result;
        }
        StringBuffer ids = new StringBuffer();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            ids.append("'").append(coll.get(i).getId()).append("',");
        }
        StringBuffer oql = new StringBuffer();
        oql.append(this.buildSelectorSQL(ctx, newOrgF7AssistInfo)).append(" where \"STRUCTURE\".FLongnumber in (").append(this.getInterceptLongNumberSQL(newOrgF7AssistInfo, selectedNode.getString("structLongNumber"))).append(" where \"STRUCTURE\".FID in (").append(ids.substring(0, ids.length() - 1)).append(")").append(") AND \"STRUCTURE\".FTreeId = '").append(selectedNode.getString("treeId")).append("'");
        if (!StringUtils.isEmpty((String)newOrgF7AssistInfo.getOrgRangeSQL())) {
            oql.append(" and \"UNIT\".fid in (").append(newOrgF7AssistInfo.getOrgRangeSQL()).append(" )");
        }
        oql.append(" and \"UNIT\".fmaintainCuID in ( " + this.getCuIDs(ctx) + ")");
        result.addAll(this.executeQuery(ctx, newOrgF7AssistInfo, oql.toString()));
        int j2 = result.size();
        for (int i = 0; i < j2; ++i) {
            FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)result.get(i);
            unitInfo.setString("treeId", selectedNode.getString("treeId"));
            unitInfo.setString("parentUnitId", selectedNode.getString("parentUnitId"));
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FCONTROLUNITID  from t_org_tree where fid = '" + selectedNode.getString("treeId") + "'"));
                if (!rs.next()) continue;
                String treeCUID = rs.getString("FCONTROLUNITID");
                unitInfo.setString("treeCUID", treeCUID);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private StringBuffer buildSelectorSQL(Context ctx, OrgAssistInfo newOrgF7AssistInfo) throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer();
        result.append("select \"UNIT\".FID, \"UNIT\".FName_").append(ctx.getLocale().toString()).append(", \"STRUCTURE\".FLongnumber, \"STRUCTURE\".FIsleaf, \"UNIT\".FIsUnion from T_ORG_BaseUnit AS \"UNIT\" ").append("  INNER JOIN T_ORG_STRUCTURE AS \"STRUCTURE\" on \"UNIT\".FID = \"STRUCTURE\".FUnitId ");
        return result;
    }

    private StringBuffer getInterceptLongNumberSQL(OrgAssistInfo newOrgF7AssistInfo, String rootLongNumber) {
        StringBuffer result = new StringBuffer();
        result.append("select distinct substring(").append("\"STRUCTURE\".FLongNumber, 0, CHARINDEX('!', ").append("\"STRUCTURE\".FLongNumber||'!', ").append(rootLongNumber.length() + 2).append(")-1) ").append("AS FVALIDLN").append(" from ").append("T_ORG_STRUCTURE \"STRUCTURE\"");
        return result;
    }

    private String getUnionSubNodesOQL(Context ctx, OrgAssistInfo newOrgF7AssistInfo, FullOrgUnitInfo selectedNode) {
        StringBuffer oql = new StringBuffer();
        oql.append("select id").append(" where ").append(this.appendUnionAndMaintainQuery(ctx, newOrgF7AssistInfo, this.getCuIDs(ctx))).append(" and tree.id = '").append(selectedNode.getString("treeId")).append("' and longNumber like '").append(selectedNode.getString("structLongNumber")).append("!%' ");
        if (!StringUtils.isEmpty((String)newOrgF7AssistInfo.getQuickQueryValue())) {
            oql.append(" and ").append(this.appendQuickQueryOQL(newOrgF7AssistInfo));
        }
        oql.append(" order by longNumber");
        return oql.toString();
    }

    private List executeQuery(Context ctx, OrgAssistInfo newOrgF7AssistInfo, String queryString) throws BOSException {
        List result = null;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(queryString);
            result = this.buildInfoByResultSet(ctx, newOrgF7AssistInfo, rs);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return result;
    }

    private List buildInfoByResultSet(Context ctx, OrgAssistInfo newOrgF7AssistInfo, ResultSet rs) throws BOSException {
        ArrayList<FullOrgUnitInfo> result = new ArrayList<FullOrgUnitInfo>();
        try {
            JdbcRowSet rowset;
            int fetched;
            while ((fetched = (rowset = new JdbcRowSet()).populate(rs, 0, 1, true)) != 0) {
                rowset.next();
                result.add(this.trans2FullOrgUnitInfo(ctx, rowset));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private FullOrgUnitInfo trans2FullOrgUnitInfo(Context ctx, JdbcRowSet row) throws UuidException, SQLException {
        FullOrgUnitInfo info = new FullOrgUnitInfo();
        info.setId(BOSUuid.read((String)row.getString(1)));
        info.setName(row.getString(2));
        info.setString("structLongNumber", row.getString(3));
        info.setIsLeaf(row.getBoolean(4));
        info.setIsUnion(row.getBoolean(5));
        return info;
    }
}

