/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.TableAssistInfo;
import com.kingdee.eas.basedata.org.app.helper.FilterAssembleDecorator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.List;

public class CUFilter4F7Decorator
extends FilterAssembleDecorator {
    @Override
    protected List<String> handleFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<String> filterItems = new ArrayList<String>();
        if (assistInfo.isCUFilter()) {
            filterItems.add("\"BASEUNIT\".FControlUnitID = ?");
            if (assistInfo.isCUFilterIncludeSub()) {
                filterItems.add("\"CTRLUNIT\".FLongNumber like ?");
            }
        }
        return filterItems;
    }

    @Override
    protected List<TableAssistInfo> handleTables(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<TableAssistInfo> tables = new ArrayList<TableAssistInfo>();
        if (assistInfo.isCUFilter() && assistInfo.isCUFilterIncludeSub()) {
            tables.add(assistInfo.createTableAssistInfo("T_ORG_CTRLUNIT", "\"CTRLUNIT\"", "FID", "\"BASEUNIT\"", "FControlUnitID"));
        }
        return tables;
    }

    @Override
    protected List<Object> getObjParams(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<Object> objParams = new ArrayList<Object>();
        if (assistInfo.isCUFilter()) {
            objParams.add(assistInfo.getCuID());
            if (assistInfo.isCUFilterIncludeSub()) {
                try {
                    CtrlUnitInfo unitInfo = CtrlUnitFactory.getLocalInstance(ctx).getCtrlUnitInfo((IObjectPK)new ObjectStringPK(assistInfo.getCuID()));
                    String longNumber = unitInfo.getLongNumber();
                    objParams.add(longNumber + "!%");
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return objParams;
    }

    @Override
    protected String getMaskString(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (assistInfo.isCUFilter() && assistInfo.isCUFilterIncludeSub()) {
            return "#0 or #1";
        }
        return null;
    }
}

