/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgInnerFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.helper.FieldMetaDataInfo;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgAppHelper {
    private static Logger logger = Logger.getLogger(OrgAppHelper.class);

    public static String getInvalidDate() {
        Date currentDate = new Date(System.currentTimeMillis());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date invalidDate = cal.getTime();
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formater.format(invalidDate);
    }

    public static void setValueInfo(IObjectValue iObjectValue, IRowSet rowSet, Map fieldMetaInfoMap) throws BOSException {
        OrgAppHelper.setValueInfo(iObjectValue, rowSet, null, fieldMetaInfoMap);
    }

    public static void setValueInfo(IObjectValue iObjectValue, IRowSet rowSet, String talbeNameAlias, Map fieldMetaInfoMap) throws BOSException {
        if (iObjectValue == null || rowSet == null || fieldMetaInfoMap == null || fieldMetaInfoMap.isEmpty()) {
            throw new IllegalArgumentException(" iObjectValue,rowSet,fieldMap is null!");
        }
        Iterator it = fieldMetaInfoMap.keySet().iterator();
        String tableAlias = talbeNameAlias + ".";
        if (StringUtils.isEmpty((String)talbeNameAlias)) {
            tableAlias = "";
        }
        while (it.hasNext()) {
            String filedName = (String)it.next();
            FieldMetaDataInfo fieldMetaInfo = (FieldMetaDataInfo)fieldMetaInfoMap.get(filedName);
            String fieldAliasName = fieldMetaInfo.getFieldNameDb();
            if (fieldAliasName != null && fieldAliasName.indexOf("_l2") != -1) {
                fieldAliasName = StringUtils.replace((String)fieldAliasName, (String)"_l2", (String)"");
            }
            String inRowSetValueNameAlias = tableAlias + fieldAliasName;
            iObjectValue.put(filedName, OrgAppHelper.getRowSetValue(rowSet, inRowSetValueNameAlias, fieldMetaInfo.getFieldObjDataType()));
        }
    }

    public static Object getRowSetValue(IRowSet rowSet, String fieldAliasName, String clazzName) throws BOSException {
        try {
            logger.debug((Object)("get fieldAliasName is: " + fieldAliasName));
            String value = rowSet.getString(fieldAliasName);
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            logger.debug((Object)("value is:" + value));
            if (String.class.getName().equals(clazzName)) {
                return value;
            }
            if (BOSUuid.class.getName().equals(clazzName)) {
                return BOSUuid.read((String)value);
            }
            if (Date.class.getName().equals(clazzName)) {
                return new Date(rowSet.getDate(fieldAliasName).getTime());
            }
            if (Boolean.class.getName().equals(clazzName) || Boolean.class.getName().toLowerCase().indexOf(clazzName.toLowerCase()) != -1) {
                if ("1".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (Integer.class.getName().equals(clazzName)) {
                return new Integer(value);
            }
            return null;
        }
        catch (SQLException sqle) {
            logger.error((Object)"sql eror!", (Throwable)sqle);
            throw new BOSException((Throwable)sqle);
        }
    }

    public static boolean existBizSuperiorLoop(Context ctx, OrgStructureInfo self, OrgStructureInfo parent) throws BOSException, EASBizException {
        return parent.getLongNumber().startsWith(self.getLongNumber() + "!");
    }

    public static boolean isBizChildrenExist(Context ctx, FullOrgUnitInfo unit, String treeID) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo structInfo = null;
        try {
            structInfo = iStruct.getOrgStructureInfo("Select longNumber Where unit.id = '" + unit.getId().toString() + "' and tree.id = '" + treeID + "'");
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        String longNumber = structInfo.getLongNumber();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)longNumber, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        return iStruct.exists(filter);
    }

    public static boolean isCUBizPropertyExistInOU(Context ctx, FullOrgUnitInfo unit, int orgType) throws BOSException, EASBizException {
        if (!unit.isIsCU()) {
            return false;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)unit.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)unit.getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgTypeStr", (Object)("%" + OrgTypeHelper.createLikeStr(OrgType.getEnum(orgType)) + "%"), CompareType.LIKE));
        return iFull.exists(filter);
    }

    public static OrgUnitInfo findBizSuperiorOrg(Context ctx, FullOrgUnitInfo fullOrgUnit, BOSObjectType bosType, BizOrgQueryParam queryParam, OrgType orgType) throws BOSException, EASBizException {
        OrgUnitInfo retInfo;
        IFullOrgUnit iFull;
        FullOrgUnitInfo unitInfo;
        if (fullOrgUnit.getParent() == null || fullOrgUnit.getParent().getId() == null) {
            return null;
        }
        IOrgInnerFacade iOrgInnerFacade = OrgInnerFacadeFactory.getLocalInstance(ctx);
        boolean isShow = iOrgInnerFacade.isShowOrgHRFunction();
        if (!isShow && OrgType.HRO.equals((Object)orgType)) {
            queryParam.setBizUnitType("ALL");
        }
        if (OrgTypeHelper.isOrgType((unitInfo = (iFull = FullOrgUnitFactory.getLocalInstance(ctx)).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(fullOrgUnit.getParent().getId().toString()))).getOrgTypeStr(), orgType) && OrgAppHelper.valideOrg((IObjectValue)(retInfo = NewOrgViewHelper.getOrgUnitInfo(ctx, unitInfo.getId().toString(), orgType)), queryParam)) {
            return retInfo;
        }
        return OrgAppHelper.findBizSuperOrgInner(ctx, unitInfo, bosType, queryParam);
    }

    private static OrgUnitInfo findBizSuperOrgInner(Context ctx, FullOrgUnitInfo unitInfo, BOSObjectType bosType, BizOrgQueryParam queryParam) throws BOSException, EASBizException {
        boolean isCuFilter;
        OrgUnitInfo ret = null;
        boolean bl = isCuFilter = queryParam == null || queryParam.isCuFilter();
        if (isCuFilter && unitInfo.isIsCU()) {
            return null;
        }
        if (unitInfo.getParent() == null) {
            return OrgAppHelper.getDynamicUnitInfo(ctx, unitInfo, bosType, queryParam);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent"));
        boolean doWhileCondition = true;
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        do {
            if (unitInfo.getParent() == null) {
                return ret;
            }
            if (unitInfo.getId().toString().equals(unitInfo.getParent().getId().toString())) {
                return OrgAppHelper.getDynamicUnitInfo(ctx, unitInfo, bosType, queryParam);
            }
            if (isCuFilter) {
                boolean bl2 = doWhileCondition = !(unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getParent().getId()), sic)).isIsCU();
            }
            if ((ret = OrgAppHelper.getDynamicUnitInfo(ctx, unitInfo, bosType, queryParam)) != null) break;
            if (isCuFilter) continue;
            unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getParent().getId()), sic);
        } while (doWhileCondition);
        return ret;
    }

    private static OrgUnitInfo getDynamicUnitInfo(Context ctx, FullOrgUnitInfo unitInfo, BOSObjectType bosType, BizOrgQueryParam queryParam) throws BOSException, EASBizException {
        OrgUnitInfo orgInfo;
        OrgUnitInfo ret = null;
        String oql = "select id,isSealUp,isBizUnit,name,number where id = '" + unitInfo.getId().toString() + "'";
        IDynamicObject idy = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection objCol = idy.getCollection(bosType, oql);
        if (!objCol.isEmpty() && OrgAppHelper.valideOrg((IObjectValue)(orgInfo = (OrgUnitInfo)objCol.getObject(0)), queryParam)) {
            ret = orgInfo;
        }
        return ret;
    }

    public static OrgUnitInfo findBizSuperiorOrg(Context ctx, BOSObjectType bosType, String orgId, BizOrgQueryParam queryParam) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        return OrgAppHelper.findBizSuperOrgInner(ctx, unitInfo, bosType, queryParam);
    }

    private static boolean isSame(boolean boolValue, String paramValue) {
        if ("ALL".equals(paramValue)) {
            return true;
        }
        if ("FALSE".equals(paramValue)) {
            return !boolValue;
        }
        if ("TRUE".equals(paramValue)) {
            return boolValue;
        }
        return true;
    }

    private static boolean valideOrg(IObjectValue orgValue, BizOrgQueryParam queryParam) {
        boolean isSealup;
        if (orgValue.get("issealup") != null && (isSealup = ((Boolean)orgValue.get("issealup")).booleanValue())) {
            return false;
        }
        if (!OrgUnitExtInfo.class.isAssignableFrom(orgValue.getClass())) {
            return true;
        }
        OrgUnitExtInfo orgUnitExtInfo = (OrgUnitExtInfo)orgValue;
        boolean isOUSealup = orgUnitExtInfo.isIsSealUp();
        if (queryParam == null) {
            return !isOUSealup;
        }
        boolean retRes = OrgAppHelper.isSame(orgUnitExtInfo.isIsSealUp(), queryParam.getOrgOUSealType());
        if (!retRes) {
            return false;
        }
        return OrgAppHelper.isSame(orgUnitExtInfo.isIsBizUnit(), queryParam.getBizUnitType());
    }

    public static String getSqlQueryOrgInfo(String orgViewTableName, BizOrgQueryParam queryParam) {
        StringBuffer sourceSql = new StringBuffer();
        if (queryParam == null) {
            return sourceSql.toString();
        }
        String idName = "fid";
        if (!"BIZOBJ_VIEW".equals(queryParam.getBizObjType())) {
            idName = "funitid";
            sourceSql = new StringBuffer(" select ").append(idName).append(" from  ").append(orgViewTableName);
        }
        sourceSql.append(OrgAppHelper.getSqlQueryOrgInfoBySealUP(queryParam));
        sourceSql.append(OrgAppHelper.getSqlQueryOrgInfoByBizUnit(queryParam));
        if (!StringUtils.isEmpty((String)queryParam.getOrgId())) {
            if (sourceSql.toString().indexOf("where") == -1) {
                sourceSql.append(" where ").append(idName).append(" ='").append(queryParam.getOrgId()).append("'");
            } else {
                sourceSql.append(" and ").append(idName).append(" ='").append(queryParam.getOrgId()).append("'");
            }
        }
        if (!StringUtils.isEmpty((String)queryParam.getSubLongNumber())) {
            if (sourceSql.toString().indexOf("where") == -1) {
                sourceSql.append(" where flongnumber like '").append(queryParam.getSubLongNumber()).append("!%'");
            } else {
                sourceSql.append(" and flongnumber like '").append(queryParam.getSubLongNumber()).append("!%'");
            }
        }
        return sourceSql.toString();
    }

    public static String getSqlQueryOrgInfoBySealUP(BizOrgQueryParam queryParam) {
        return queryParam.getSqlQueryOrgInfoBySealUp();
    }

    public static String getSqlQueryOrgInfoByBizUnit(BizOrgQueryParam queryParam) {
        return queryParam.getSqlQueryOrgInfoByBizUnit(false);
    }

    public static OrgUnitCollection getOrgUnitCollection(Context ctx, IOrgAppHelper oneHelper, BizOrgQueryParam bizOrgParam) throws BOSException, EASBizException {
        return OrgAppHelper.getOrgUnitCollection(ctx, oneHelper, bizOrgParam, false);
    }

    public static OrgUnitCollection getOrgUnitCollection(Context ctx, IOrgAppHelper oneHelper, BizOrgQueryParam bizOrgParam, boolean isUseOUpartTable) throws BOSException, EASBizException {
        try {
            String oql = " select * " + bizOrgParam.toSql("id", true, isUseOUpartTable);
            IDynamicObject iDynaObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
            IObjectCollection iObjCol = iDynaObj.getCollection(oneHelper.getOrgTypeSelfInfo().getOrgViewBosType(), oql);
            OrgUnitCollection orgCol = new OrgUnitCollection();
            for (int i = 0; i < iObjCol.size(); ++i) {
                orgCol.add((OrgUnitInfo)iObjCol.getObject(i));
            }
            return orgCol;
        }
        catch (UuidException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String getSelectFieldName(Context ctx, String tableAliasName, String[] fieldName) {
        List col = OrgAppHelper.trans2Col(fieldName);
        return OrgAppHelper.getSelectFieldName(ctx, tableAliasName, col);
    }

    public static List trans2Col(Object[] obj) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (obj == null || obj.length == 0) {
            return retList;
        }
        for (int i = 0; i < obj.length; ++i) {
            retList.add(obj[i]);
        }
        return retList;
    }

    public static String getSelectFieldName(Context ctx, String tableAliasName, Collection fieldName) {
        String tableNameTemp = "";
        if (!StringUtils.isEmpty((String)tableAliasName)) {
            tableNameTemp = tableAliasName + ".";
        }
        StringBuffer retSb = new StringBuffer();
        for (String tempThisFieldName : fieldName) {
            if (retSb.length() == 0) {
                retSb.append(tableNameTemp).append(tempThisFieldName).append(" as \"").append(tableNameTemp).append(tempThisFieldName).append("\"");
                continue;
            }
            retSb.append(",").append(tableNameTemp).append(tempThisFieldName).append(" as \"").append(tableNameTemp).append(StringUtils.replace((String)tempThisFieldName, (String)("_" + ctx.getLocale()), (String)"")).append("\"");
        }
        return retSb.toString();
    }

    public static String getSelectFieldAliasName(Context ctx, String tableAliasName, String fieldName) {
        String tableNameTemp = "";
        if (!StringUtils.isEmpty((String)tableAliasName)) {
            tableNameTemp = tableAliasName + ".";
        }
        return tableNameTemp + StringUtils.replace((String)fieldName, (String)("_" + ctx.getLocale()), (String)"");
    }

    public static Map getSelectFieldFactName(Context ctx, String[] fieldName, EntityObjectInfo entityObjInfo) {
        List col = OrgAppHelper.trans2Col(fieldName);
        return OrgAppHelper.getSelectFieldFactName(ctx, col, entityObjInfo);
    }

    public static Map getSelectFieldFactName(Context ctx, Collection fieldNameCol, EntityObjectInfo entityObjInfo) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (fieldNameCol == null || fieldNameCol.isEmpty()) {
            return retMap;
        }
        for (String thisFieldName : fieldNameCol) {
            retMap.put(thisFieldName, OrgAppHelper.getFieldFactNameByField(ctx, thisFieldName, entityObjInfo));
        }
        return retMap;
    }

    public static String getSelectFieldFactName2Str(Context ctx, String talbeNameAlias, Collection fieldNameCol, EntityObjectInfo entityObjInfo) {
        Map allFieldNameMap = OrgAppHelper.getSelectFieldFactName(ctx, fieldNameCol, entityObjInfo);
        return OrgAppHelper.getSelectFieldName(ctx, talbeNameAlias, allFieldNameMap.values());
    }

    public static String getSelectFieldFactName2Str(Context ctx, String talbeNameAlias, String[] fieldName, EntityObjectInfo entityObjInfo) {
        Map allFieldNameMap = OrgAppHelper.getSelectFieldFactName(ctx, fieldName, entityObjInfo);
        return OrgAppHelper.getSelectFieldName(ctx, talbeNameAlias, allFieldNameMap.values());
    }

    public static String getFieldFactNameByField(Context ctx, String fieldName, EntityObjectInfo entityObjInfo) {
        try {
            PropertyInfo pro = entityObjInfo.getFieldByFullName(fieldName);
            String retFieldName = pro.getMappingField().getName();
            if (!pro.getMappingField().isMultilingual()) {
                return retFieldName;
            }
            return retFieldName + "_" + ctx.getLocale();
        }
        catch (Exception e) {
            logger.error((Object)("get fieldName error, field is:" + fieldName), (Throwable)e);
            throw new IllegalArgumentException("get fieldName error, field is:" + fieldName);
        }
    }

    public static Map getSelectFieldDetailInfo(Context ctx, IOrgAppHelper oneHelper, String bizObjType, Set fieldMap) {
        HashMap<String, FieldMetaDataInfo> retMap = new HashMap<String, FieldMetaDataInfo>();
        Iterator it = fieldMap.iterator();
        String tableNameAlias = oneHelper.getOrgTypeSelfInfo().getTableNameAlias();
        BOSObjectType bosType = oneHelper.getOrgTypeSelfInfo().getOrgTableBosType();
        if ("BIZOBJ_VIEW".equals(bizObjType)) {
            tableNameAlias = oneHelper.getOrgTypeSelfInfo().getViewTableAlias();
            bosType = oneHelper.getOrgTypeSelfInfo().getOrgViewBosType();
        }
        EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        while (it.hasNext()) {
            String filedName = (String)it.next();
            FieldMetaDataInfo fieldMetaInfo = OrgAppHelper.getSelectFieldDetailInfo(ctx, filedName, entityObjInfo);
            retMap.put(filedName, fieldMetaInfo);
        }
        return retMap;
    }

    public static FieldMetaDataInfo getSelectFieldDetailInfo(Context ctx, String fieldName, EntityObjectInfo entityObjInfo) {
        try {
            PropertyInfo pro = entityObjInfo.getFieldByFullName(fieldName);
            String retFieldName = pro.getMappingField().getName();
            if (pro.getMappingField().isMultilingual()) {
                retFieldName = retFieldName + "_" + ctx.getLocale();
            }
            String javaType = String.class.getName();
            if (pro instanceof OwnPropertyInfo) {
                OwnPropertyInfo curPro = (OwnPropertyInfo)pro;
                javaType = curPro.getJavaType();
            }
            FieldMetaDataInfo fieldMetaInfo = new FieldMetaDataInfo();
            fieldMetaInfo.setFieldName(fieldName);
            fieldMetaInfo.setFieldNameDb(retFieldName);
            fieldMetaInfo.setFieldObjDataType(javaType);
            return fieldMetaInfo;
        }
        catch (Exception e) {
            logger.error((Object)("get fieldName error, field is:" + fieldName), (Throwable)e);
            throw new IllegalArgumentException("get fieldName error, field is:" + fieldName);
        }
    }
}

