/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeRegister;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgTypeInitHelper {
    private Context ctx;
    private static Logger logger = Logger.getLogger((String)OrgTypeInitHelper.class.getName());
    private static Map checkInitOverMap = new Hashtable();
    private String[] initTable = "T_ORG_BaseUnit,T_ORG_Admin,T_ORG_Company,T_ORG_CostCenter,T_ORG_CtrlUnit,T_ORG_HRO,T_ORG_ProfitCenter,T_ORG_Purchase,T_ORG_Quality,T_ORG_Sale,T_ORG_Storage,T_ORG_Transport,T_ORG_UnionGroup".split(",");
    private String[] initTableHis = "T_ORG_BaseUnit_His,T_ORG_Admin_His,T_ORG_Company_His,T_ORG_CostCenter_His,T_ORG_CtrlUnit_His,T_ORG_HRO_His,T_ORG_ProfitCenter_His,T_ORG_Purchase_His,T_ORG_Quality_His,T_ORG_Sale_His,T_ORG_Storage_His,T_ORG_Transport_His,T_ORG_UnionGroup_His".split(",");

    private boolean alreadyInitOver(String[] tables) {
        StringBuffer testSql = new StringBuffer();
        testSql.append("SELECT count(*) count FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'forgtypestr' AND KSQL_COL_TABNAME in (");
        int length = tables.length;
        for (int i = 0; i < length; ++i) {
            testSql.append("'" + tables[i].toUpperCase() + "'");
            if (i >= length - 1) continue;
            testSql.append(",");
        }
        testSql.append(")");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)testSql.toString());
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (count != tables.length) {
                return false;
            }
        }
        catch (SQLException se) {
            logger.error((Object)se);
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    private void initOrgTypeAddField() throws BOSException {
        String newSql;
        int i;
        String addFieldSql = "IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'FOrgTypeStr' AND KSQL_COL_TABNAME = 'TABLE_NAME')";
        addFieldSql = addFieldSql + " ALTER TABLE TABLE_NAME ADD FOrgTypeStr  NVARCHAR(255)";
        for (i = 0; i < this.initTable.length; ++i) {
            if (this.alreadyInitOver(new String[]{this.initTable[i]})) continue;
            newSql = addFieldSql.replaceAll("TABLE_NAME", this.initTable[i]);
            DbUtil.execute((Context)this.ctx, (String)newSql);
        }
        for (i = 0; i < this.initTableHis.length; ++i) {
            if (this.alreadyInitOver(new String[]{this.initTableHis[i]})) continue;
            newSql = addFieldSql.replaceAll("TABLE_NAME", this.initTableHis[i]);
            DbUtil.execute((Context)this.ctx, (String)newSql);
        }
    }

    private void initOrgFieldTableData() throws BOSException {
        HashMap<String, String> orgFieldMap = new HashMap<String, String>();
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(this.ctx);
        FullOrgUnitCollection fullCol = iFull.getFullOrgUnitCollection();
        for (int i = 0; i < fullCol.size(); ++i) {
            FullOrgUnitInfo orgInfo = fullCol.get(i);
            String orgTypStr = this.createOrgTypeInfoStr(orgInfo);
            orgFieldMap.put(orgInfo.getId().toString(), orgTypStr);
        }
        this.updateOrgData(orgFieldMap);
    }

    private void updateOrgData(Map orgFieldMap) throws BOSException {
        for (int i = 0; i < this.initTable.length; ++i) {
            String updateSql = "update " + this.initTable[i] + " set forgTypeStr = ? where fid = ? ";
            Iterator it = orgFieldMap.keySet().iterator();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (it.hasNext()) {
                String fid = (String)it.next();
                Object[] obj = new Object[]{(String)orgFieldMap.get(fid), fid};
                paramList.add(obj);
            }
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, paramList);
        }
    }

    private String createOrgTypeInfoStr(FullOrgUnitInfo orgInfo) {
        return OrgTypeHelper.createOrgTypeStr(orgInfo);
    }

    private void initOrgFieldHisTableData() throws BOSException {
        try {
            String sql = "select fid,fversionNumber,forgTypeStr,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit,FIsCU,FIsUnion,FIsHROrgUnit,fisTransportOrgUnit,fisQualityOrgUnit from T_ORG_BaseUnit_His";
            FullOrgUnitCollection fullOrgCol = new FullOrgUnitCollection();
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rowSet.next()) {
                FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
                fullInfo.setId(BOSUuid.read((String)rowSet.getString("fid")));
                fullInfo.setVersionNumber(rowSet.getString("fversionNumber"));
                fullInfo.setOrgTypeStr(rowSet.getString("forgTypeStr"));
                fullInfo.setIsCompanyOrgUnit(rowSet.getBoolean("FIsCompanyOrgUnit"));
                fullInfo.setIsAdminOrgUnit(rowSet.getBoolean("FIsAdminOrgUnit"));
                fullInfo.setIsSaleOrgUnit(rowSet.getBoolean("FIsSaleOrgUnit"));
                fullInfo.setIsPurchaseOrgUnit(rowSet.getBoolean("FIsPurchaseOrgUnit"));
                fullInfo.setIsStorageOrgUnit(rowSet.getBoolean("FIsStorageOrgUnit"));
                fullInfo.setIsProfitOrgUnit(rowSet.getBoolean("FIsProfitOrgUnit"));
                fullInfo.setIsCostOrgUnit(rowSet.getBoolean("FIsCostOrgUnit"));
                fullInfo.setIsCU(rowSet.getBoolean("FIsCU"));
                fullInfo.setIsUnion(rowSet.getBoolean("FIsUnion"));
                fullInfo.setIsHROrgUnit(rowSet.getBoolean("FIsHROrgUnit"));
                fullInfo.setIsTransportOrgUnit(rowSet.getBoolean("fisTransportOrgUnit"));
                fullInfo.setIsQualityOrgUnit(rowSet.getBoolean("fisQualityOrgUnit"));
                fullInfo.setOrgTypeStr(this.createOrgTypeInfoStr(fullInfo));
                fullOrgCol.add(fullInfo);
            }
            this.updateOtherTableData(fullOrgCol);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateOtherTableData(FullOrgUnitCollection fullOrgCol) throws BOSException {
        for (int i = 0; i < this.initTableHis.length; ++i) {
            String updateSql = "update " + this.initTableHis[i] + " set forgTypeStr = ? where fid = ?  and fversionNumber = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int j = 0; j < fullOrgCol.size(); ++j) {
                FullOrgUnitInfo fullInfo = fullOrgCol.get(j);
                String fid = fullInfo.getId().toString();
                Object[] obj = new Object[]{fullInfo.getOrgTypeStr(), fullInfo.getId().toString(), fullInfo.getVersionNumber()};
                paramList.add(obj);
            }
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, paramList);
        }
    }

    public void initFieldData(Context ctx) throws BOSException {
        this.ctx = ctx;
        this.initOrgFieldTableData();
        this.initOrgFieldHisTableData();
    }

    public synchronized void checkOrgInit(Context ctx) throws BOSException {
        int i;
        String aisKey = ctx.getAIS();
        boolean isCheckInitOver = false;
        if (checkInitOverMap.get(aisKey) != null) {
            isCheckInitOver = (Boolean)checkInitOverMap.get(aisKey);
        }
        if (isCheckInitOver) {
            return;
        }
        this.ctx = ctx;
        OrgTypeRegister orgReg = new OrgTypeRegister();
        orgReg.initOrgTypeMgrExt();
        ArrayList<String> allTables = new ArrayList<String>();
        int length = this.initTable.length;
        for (i = 0; i < length; ++i) {
            allTables.add(this.initTable[i]);
        }
        length = this.initTableHis.length;
        for (i = 0; i < length; ++i) {
            allTables.add(this.initTableHis[i]);
        }
        String[] allTableStr = new String[allTables.size()];
        int size = allTables.size();
        for (int i2 = 0; i2 < size; ++i2) {
            allTableStr[i2] = allTables.get(i2).toString();
        }
        if (!this.alreadyInitOver(allTableStr)) {
            this.initOrgTypeAddField();
            this.initFieldData(ctx);
        }
        if (checkInitOverMap.get(aisKey) == null) {
            checkInitOverMap.put(aisKey, new Boolean(true));
        }
    }
}

