/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.app.helper.QueryOrgStructSqlHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QueryOrgInfoHelper {
    private static Logger logger = Logger.getLogger(QueryOrgStructSqlHelper.class);

    public FullOrgUnitCollection queryOrgUnitCol(Context ctx, List orgIdList) throws EASBizException, BOSException {
        FullOrgUnitCollection fullCol = new FullOrgUnitCollection();
        try {
            if (orgIdList != null && !orgIdList.isEmpty()) {
                String leftJoinField = OrgTypeAppCenter.getInstance().getLeftJoinSimpleFiled(ctx, "BIZOBJ_PART");
                String leftJoinTable = OrgTypeAppCenter.getInstance().getLeftJoinTableSql("BASE.FID");
                String querySql = "SELECT BASE.FID, BASE.FNAME_L2 as \"BASE.FNAME\", BASE.FNUMBER, BASE.FLONGNUMBER, BASE.FCODE,BASE.FIsOUSealUp, BASE.FORGTYPESTR," + leftJoinField + "FROM T_ORG_BASEUNIT BASE " + leftJoinTable + "WHERE BASE.FID IN ( ? ) " + "ORDER BY BASE.FLONGNUMBER ASC";
                Locale curlocal = ctx.getLocale();
                querySql = StringUtils.replace((String)querySql, (String)"_L2", (String)("_" + curlocal));
                IRowSet rs = null;
                int PERSIZE = 5000;
                int totalSize = orgIdList.size();
                int totalCount = (totalSize - 1) / PERSIZE + 1;
                int begin = 0;
                int end = 0;
                List subList = new ArrayList();
                for (int i = 0; i < totalCount; ++i) {
                    begin = i * PERSIZE;
                    end = (i + 1) * PERSIZE > totalSize ? totalSize : (i + 1) * PERSIZE;
                    subList = orgIdList.subList(begin, end);
                    String tempSQL = querySql;
                    String orgParam = ToolUtils.aryToStr(subList, (boolean)true);
                    tempSQL = tempSQL.replace("?", orgParam);
                    rs = DbUtil.executeQuery((Context)ctx, (String)tempSQL);
                    while (rs.next()) {
                        FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
                        String baseId = rs.getString(1);
                        if (!orgIdList.contains(baseId)) continue;
                        fullInfo.setId(BOSUuid.read((String)rs.getString(1)));
                        fullInfo.setName(rs.getString("BASE.FNAME"));
                        fullInfo.setNumber(rs.getString("FNUMBER"));
                        fullInfo.setLongNumber(rs.getString("FLONGNUMBER"));
                        fullInfo.setCode(rs.getString("FCODE"));
                        fullInfo.setIsOUSealUp(rs.getBoolean("FIsOUSealUp"));
                        fullInfo.setOrgTypeStr(rs.getString("FORGTYPESTR"));
                        OrgTypeHelper.createOrgType4FullOrg(fullInfo, fullInfo.getOrgTypeStr());
                        OrgTypeAppCenter.getInstance().fillFullOrgUnit(ctx, fullInfo, rs, "BIZOBJ_PART");
                        fullCol.add(fullInfo);
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_ORGRANGE_FAIL, (Throwable)e);
        }
        return fullCol;
    }

    public FullOrgUnitCollection queryOrgUnitCol(Context ctx, String orgRangeSql, Object[] params) throws EASBizException, BOSException {
        FullOrgUnitCollection fullCol = new FullOrgUnitCollection();
        try {
            String leftJoinField = OrgTypeAppCenter.getInstance().getLeftJoinSimpleFiled(ctx, "BIZOBJ_PART");
            String leftJoinTable = OrgTypeAppCenter.getInstance().getLeftJoinTableSql("BASE.FID");
            String querySql = "SELECT BASE.FID, BASE.FNAME_L2 as \"BASE.FNAME\", BASE.FNUMBER, BASE.FLONGNUMBER, BASE.FCODE,BASE.FIsOUSealUp, BASE.FORGTYPESTR," + leftJoinField + "FROM T_ORG_BASEUNIT BASE " + leftJoinTable + "WHERE BASE.FID IN (" + orgRangeSql + ") ORDER BY BASE.FLONGNUMBER ASC";
            Locale curlocal = ctx.getLocale();
            querySql = StringUtils.replace((String)querySql, (String)"_L2", (String)("_" + curlocal));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])params);
            while (rs.next()) {
                FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
                fullInfo.setId(BOSUuid.read((String)rs.getString(1)));
                fullInfo.setName(rs.getString("BASE.FNAME"));
                fullInfo.setNumber(rs.getString("FNUMBER"));
                fullInfo.setLongNumber(rs.getString("FLONGNUMBER"));
                fullInfo.setCode(rs.getString("FCODE"));
                fullInfo.setIsOUSealUp(rs.getBoolean("FIsOUSealUp"));
                fullInfo.setOrgTypeStr(rs.getString("FORGTYPESTR"));
                OrgTypeHelper.createOrgType4FullOrg(fullInfo, fullInfo.getOrgTypeStr());
                OrgTypeAppCenter.getInstance().fillFullOrgUnit(ctx, fullInfo, rs, "BIZOBJ_PART");
                fullCol.add(fullInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_ORGRANGE_FAIL, (Throwable)e);
        }
        return fullCol;
    }

    public FullOrgUnitCollection querySimpleOrgUnitCol(Context ctx, List orgIdList) throws EASBizException, BOSException {
        FullOrgUnitCollection fullCol = new FullOrgUnitCollection();
        try {
            if (orgIdList != null && !orgIdList.isEmpty()) {
                String querySql = "SELECT BASE.FID, BASE.FCODE, BASE.FNAME_L2 as \"BASE.FNAME\", BASE.FNUMBER, BASE.FLONGNUMBER, BASE.FIsOUSealUp, BASE.FORGTYPESTR FROM T_ORG_BASEUNIT BASE WHERE BASE.FID IN (" + ToolUtils.aryToStr((List)orgIdList, (boolean)true) + ") ORDER BY BASE.FLONGNUMBER ASC";
                Locale curlocal = ctx.getLocale();
                querySql = StringUtils.replace((String)querySql, (String)"_L2", (String)("_" + curlocal));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
                while (rs.next()) {
                    FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
                    fullInfo.setId(BOSUuid.read((String)rs.getString(1)));
                    fullInfo.setName(rs.getString("BASE.FNAME"));
                    fullInfo.setNumber(rs.getString("FNUMBER"));
                    fullInfo.setLongNumber(rs.getString("FLONGNUMBER"));
                    fullInfo.setCode(rs.getString("FCODE"));
                    fullInfo.setIsOUSealUp(rs.getBoolean("FIsOUSealUp"));
                    fullInfo.setOrgTypeStr(rs.getString("FORGTYPESTR"));
                    fullCol.add(fullInfo);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_ORGRANGE_FAIL, (Throwable)e);
        }
        return fullCol;
    }

    public FullOrgUnitCollection querySimpleOrgUnitCol(Context ctx, String orgRangeSql, Object[] params) throws EASBizException, BOSException {
        FullOrgUnitCollection fullCol = new FullOrgUnitCollection();
        try {
            String querySql = "SELECT BASE.FID, BASE.FCODE,BASE.FNAME_L2 as \"BASE.FNAME\", BASE.FNUMBER, BASE.FLONGNUMBER, BASE.FIsOUSealUp, BASE.FORGTYPESTR FROM T_ORG_BASEUNIT BASE WHERE BASE.FID IN (" + orgRangeSql + ") ORDER BY BASE.FLONGNUMBER ASC";
            Locale curlocal = ctx.getLocale();
            querySql = StringUtils.replace((String)querySql, (String)"_L2", (String)("_" + curlocal));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])params);
            while (rs.next()) {
                FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
                fullInfo.setId(BOSUuid.read((String)rs.getString(1)));
                fullInfo.setName(rs.getString("BASE.FNAME"));
                fullInfo.setNumber(rs.getString("FNUMBER"));
                fullInfo.setLongNumber(rs.getString("FLONGNUMBER"));
                fullInfo.setIsOUSealUp(rs.getBoolean("FIsOUSealUp"));
                fullInfo.setOrgTypeStr(rs.getString("FORGTYPESTR"));
                fullInfo.setCode(rs.getString("FCODE"));
                fullCol.add(fullInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_ORGRANGE_FAIL, (Throwable)e);
        }
        return fullCol;
    }
}

