/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.helper;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.basedata.org.OrgXMLElement;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class OrgConfigHelper {
    private static final String CLIENTROOT_DIR_ENV_NAME = "easclient.root";
    private static final String fileName = "OrgConfig.xml";
    private static final String configPath = OrgConfigHelper.runtimeIsClient() ? System.getProperty("easclient.root") : System.getProperty("eas.deploy");
    private static final String fileFullName = configPath + File.separator + "OrgConfig.xml";

    public static List<String> getItemValues(String itemName) {
        ArrayList<String> retList = new ArrayList<String>();
        ConfigurationItem item = OrgConfigHelper.getConfigItem(itemName);
        if (item == null) {
            return retList;
        }
        Map pro = item.getProperties();
        retList.addAll(pro.values());
        return retList;
    }

    public static ConfigurationItem getConfigItem(String itemName) {
        File orgInitFile = new File(fileFullName);
        XMLConfiguration xmlReader = XMLConfiguration.getInstance((File)orgInitFile);
        return xmlReader.getConfigItem(itemName);
    }

    private static boolean runtimeIsClient() {
        return System.getProperty(CLIENTROOT_DIR_ENV_NAME) != null;
    }

    public static List getBizClassesforOrg(String configitemName, String attributeKey) {
        ArrayList<String> dealClassNamesList = new ArrayList<String>();
        try {
            File orgConfigFile = new File(fileFullName);
            XMLConfiguration xmlReader = XMLConfiguration.getInstance((File)orgConfigFile);
            ConfigurationItem item = xmlReader.getConfigItem(configitemName);
            Map pro = item.getProperties();
            String dealClassName2 = null;
            if (StringUtils.isEmpty((String)attributeKey)) {
                for (String dealClassName2 : pro.values()) {
                    if (StringUtils.isEmpty((String)dealClassName2)) continue;
                    dealClassNamesList.add(dealClassName2);
                }
            } else {
                dealClassNamesList.add((String)pro.get(attributeKey));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dealClassNamesList;
    }

    public static List getXMLBizClasses(String configitemName, String attributeKey) throws JDOMException, IOException {
        ArrayList<OrgXMLElement> dealClassNamesList = new ArrayList<OrgXMLElement>();
        FileInputStream inputStream = null;
        inputStream = new FileInputStream(new File(fileFullName));
        Element document = XMLParser.parseXML((InputStream)inputStream).getRootElement();
        Element currentElement = (Element)XPath.selectSingleNode((Object)document, (String)("configitem[lower-case(attribute::name)='" + configitemName.toLowerCase() + "']"));
        if (currentElement != null) {
            List entities = currentElement.getChildren();
            int size = entities.size();
            for (int i = 0; i < size; ++i) {
                Element entity = (Element)entities.get(i);
                String key = entity.getAttribute("key").getValue();
                String value = entity.getAttribute("value").getValue();
                Attribute isThrowExceptionAttr = entity.getAttribute("isThrowException");
                boolean isThrowException = false;
                if (isThrowExceptionAttr != null) {
                    isThrowException = Boolean.valueOf(isThrowExceptionAttr.getValue());
                }
                String description = entity.getAttribute("description").getValue();
                OrgXMLElement item = new OrgXMLElement(key, value, isThrowException, description);
                Attribute dependenceAttr = entity.getAttribute("dependence");
                String dependence = null;
                if (dependenceAttr != null) {
                    dependence = dependenceAttr.getValue();
                    item.setDependence(dependence);
                }
                if (!StringUtils.isEmpty((String)attributeKey) && attributeKey.equalsIgnoreCase(key)) {
                    dealClassNamesList.clear();
                    dealClassNamesList.add(item);
                    return dealClassNamesList;
                }
                dealClassNamesList.add(item);
            }
        }
        return dealClassNamesList;
    }
}

