/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgTypeRelationCollection;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgHelper {
    public static final String ORGHISTORY = "ORGHISTORY";
    private static final Logger logger = CoreUIObject.getLogger(OrgHelper.class);

    public static IObjectValue getVO(Context ctx, String pk) throws BOSException {
        if (StringUtils.isEmpty((String)pk)) {
            return null;
        }
        IDynamicObject iDynamicObj = null;
        iDynamicObj = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        return iDynamicObj.getValue(BOSUuid.read((String)pk).getType(), (IObjectPK)new ObjectStringPK(pk));
    }

    public static Set getAllTreeIdSet() {
        HashSet<String> allTreeSet = new HashSet<String>();
        Collection orgTypeInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgTypeInfo == null || StringUtils.isEmpty((String)orgTypeInfo.getOrgTreeID())) continue;
            allTreeSet.add(orgTypeInfo.getOrgTreeID());
        }
        return allTreeSet;
    }

    public static OrgTreeCollection filterTreeCol(OrgTreeCollection treeCol) {
        if (treeCol == null || treeCol.isEmpty()) {
            return treeCol;
        }
        Set allTreeSet = OrgHelper.getAllTreeIdSet();
        OrgTreeCollection retOrgTreeCol = new OrgTreeCollection();
        for (int i = 0; i < treeCol.size(); ++i) {
            OrgTreeInfo orgTreeInfo = treeCol.get(i);
            if (orgTreeInfo == null || !allTreeSet.contains(orgTreeInfo.getId().toString())) continue;
            retOrgTreeCol.add(orgTreeInfo);
        }
        return retOrgTreeCol;
    }

    public static OrgTypeRelationCollection filterOrgTypeRel(OrgTypeRelationCollection relCol) {
        if (relCol == null || relCol.isEmpty()) {
            return relCol;
        }
        Set orgTypeSet = OrgTypeInfoMgr.getInstance().getAllOrgType();
        OrgTypeRelationCollection retRelCol = new OrgTypeRelationCollection();
        for (int i = 0; i < relCol.size(); ++i) {
            OrgTypeRelationInfo orgTypeRelInfo = relCol.get(i);
            if (orgTypeRelInfo == null || orgTypeRelInfo.getFromType() == null || orgTypeRelInfo.getToType() == null || !orgTypeSet.contains((Object)orgTypeRelInfo.getFromType()) || !orgTypeSet.contains((Object)orgTypeRelInfo.getToType())) continue;
            retRelCol.add(orgTypeRelInfo);
        }
        return retRelCol;
    }
}

