/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.metadata.cache;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.metadata.cache.IOrgMetaDataCache;
import com.kingdee.eas.basedata.org.metadata.cache.MetaDataCacheException;
import com.kingdee.eas.basedata.org.metadata.config.ConfigurationIllegalException;
import com.kingdee.eas.basedata.org.metadata.config.MetaDataConfiguration;
import com.kingdee.util.ConfigurationItem;
import org.apache.log4j.Logger;

public class OrgMetaDataCacheFactory {
    private static final Logger logger = Logger.getLogger((String)OrgMetaDataCacheFactory.class.getName());
    private static final String META_DATA_CACHE_IMPL = "MetaDataCacheImpl";
    private static final String CLIENT_ATTRIBUTE = "client";
    private static final String SERVER_ATTRIBUTE = "server";
    private static IOrgMetaDataCache clientCache = null;
    private static IOrgMetaDataCache serverCache = null;

    public static IOrgMetaDataCache getClientCache() {
        return OrgMetaDataCacheFactory.getCache(null);
    }

    public static IOrgMetaDataCache getServerCache(Context ctx) {
        return OrgMetaDataCacheFactory.getCache(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOrgMetaDataCache getCache(Context ctx) {
        if (ctx == null) {
            if (clientCache != null) {
                return clientCache;
            }
            Class<OrgMetaDataCacheFactory> clazz = OrgMetaDataCacheFactory.class;
            synchronized (OrgMetaDataCacheFactory.class) {
                if (clientCache != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return clientCache;
                }
                try {
                    Class<?> cls = Class.forName(OrgMetaDataCacheFactory.getClientCacheImplClassName());
                    clientCache = (IOrgMetaDataCache)cls.getDeclaredConstructor(Context.class).newInstance(new Object[]{null});
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new MetaDataCacheException(e);
                }
                return clientCache;
            }
        }
        if (serverCache != null) {
            return serverCache;
        }
        Class<OrgMetaDataCacheFactory> clazz = OrgMetaDataCacheFactory.class;
        synchronized (OrgMetaDataCacheFactory.class) {
            if (serverCache != null) {
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return serverCache;
            }
            try {
                Class<?> cls = Class.forName(OrgMetaDataCacheFactory.getServerCacheImplClassName());
                serverCache = (IOrgMetaDataCache)cls.getDeclaredConstructor(Context.class).newInstance(ctx);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new MetaDataCacheException(e);
            }
            return serverCache;
        }
    }

    private static String getClientCacheImplClassName() {
        ConfigurationItem item = MetaDataConfiguration.getInstance().getConfigItem(META_DATA_CACHE_IMPL);
        if (item == null) {
            throw new ConfigurationIllegalException("Config file has not the item: MetaDataCacheImpl");
        }
        String clientClassName = item.getProperty(CLIENT_ATTRIBUTE);
        if (clientClassName == null) {
            throw new ConfigurationIllegalException("Config item has not the attribute: client");
        }
        return clientClassName;
    }

    private static String getServerCacheImplClassName() {
        ConfigurationItem item = MetaDataConfiguration.getInstance().getConfigItem(META_DATA_CACHE_IMPL);
        if (item == null) {
            throw new ConfigurationIllegalException("Config file has not the item: MetaDataCacheImpl");
        }
        String serverClassName = item.getProperty(SERVER_ATTRIBUTE);
        if (serverClassName == null) {
            throw new ConfigurationIllegalException("Config item has not the attribute: server");
        }
        return serverClassName;
    }
}

