/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.tempfile.TempFileExtension;
import kd.bos.cache.tempfile.TempFileExtensionFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class BaseTempFileCache {
    protected static final String ID_MAP_KEY = "id";
    protected static final String CONFIG_MAP_KEY = "configKey";
    private static TempFileExtension tempFileCheck = TempFileExtensionFactory.get();

    protected String makeUrl(String configKey, String id) {
        configKey = this.encodeConfigKey(configKey);
        return String.format("tempfile/download.do?configKey=%s&id=%s", configKey, id);
    }

    protected String encodeConfigKey(String configKey) {
        return configKey;
    }

    protected String decodeConfigKey(String configKey) {
        return configKey;
    }

    protected String createId() {
        return "tempfile-" + UUID.randomUUID().toString();
    }

    protected Map<String, String> parseUrl(String url) {
        String[] pairstr = url.split("\\?");
        String[] pairs = pairstr[1].split("&");
        HashMap<String, String> m = new HashMap<String, String>(pairs.length);
        for (String pair : pairs) {
            String[] p = pair.split("=");
            m.put(p[0], p[1]);
        }
        return m;
    }

    protected void doZip(InputStream in, ZipOutputStream out, String entryName) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        int len = 0;
        byte[] buffer = new byte[8192];
        BufferedInputStream fis = new BufferedInputStream(in);
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
        }
        out.closeEntry();
        fis.close();
    }

    protected String getRealId(String id, boolean isCheck) {
        return tempFileCheck.checkAsId(id, isCheck);
    }

    protected byte[] checkFile(byte[] bytes, String fileName) {
        return tempFileCheck.checkFile(bytes, fileName);
    }
}

