/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.debug;

import java.io.Serializable;
import java.lang.reflect.Method;
import kd.bos.context.RequestContext;

public class DebugInfo
implements Serializable {
    private static final long serialVersionUID = 85269830181302488L;
    public static final String debugAppId = "debug";
    private String debugId;
    private String debugThreadType;
    private static final Method mSetupThreadDebug;
    private static final Method mClearThreadDebug;
    private static final Class<? extends Enum> enumType;

    public DebugInfo(String debugId, boolean cmd) {
        this.debugId = debugId;
        this.debugThreadType = cmd ? "cmd" : "main";
    }

    public String getDebugId() {
        return this.debugId;
    }

    public String getDebugThreadType() {
        return this.debugThreadType;
    }

    public boolean isCmd() {
        return "cmd".equals(this.debugThreadType);
    }

    public static void setupThreadDebug(DebugInfo di) {
        if (di != null) {
            try {
                Enum type = Enum.valueOf(enumType, di.getDebugThreadType());
                mSetupThreadDebug.invoke(null, di.getDebugId(), type);
            }
            catch (Exception e) {
                throw new RuntimeException("SetupThreadDebug failed!", e);
            }
        }
    }

    public static void clearThreadDebug() {
        DebugInfo di = RequestContext.get().getDebugInfo();
        if (di != null) {
            try {
                mClearThreadDebug.invoke(null, di.getDebugId());
            }
            catch (Exception e) {
                throw new RuntimeException("ClearThreadDebug failed!", e);
            }
            finally {
                RequestContext.get().setDebugInfo(null);
            }
        }
    }

    static {
        try {
            Class<?> clsScriptExecutorFactory = Class.forName("kd.bos.script.ScriptExecutorFactory");
            mClearThreadDebug = clsScriptExecutorFactory.getMethod("clearThreadDebug", String.class);
            enumType = Class.forName("kd.bos.script.debug.DebugThreadType");
            mSetupThreadDebug = clsScriptExecutorFactory.getMethod("setupThreadDebug", String.class, enumType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

