/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.OperationContextCreator;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.ServiceConfig;
import kd.bos.framework.lifecycle.ServiceItem;
import kd.bos.framework.lifecycle.SystemServiceConfig;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.WebPortUtil;

public class LifecycleManager {
    private static final Log log = LogFactory.getLog(LifecycleManager.class);
    private static ArrayList<ServiceItem> startedList = new ArrayList();
    private static List<ServiceItem> startingList = Collections.synchronizedList(new LinkedList());
    private static AtomicInteger startThreadIndex = new AtomicInteger();
    private static Service[] sysServices;

    public static void start() {
        OperationContextCreator.getOrCreateForBos();
        for (Service service : sysServices = Instance.isWebMserviceInOne() ? SystemServiceConfig.getAllServices() : (WebPortUtil.isWebNode() ? SystemServiceConfig.getWebServices() : SystemServiceConfig.getMSServices())) {
            try {
                service.start();
            }
            catch (Exception t) {
                log.error("Service " + service.getName() + " start error.", (Throwable)t);
            }
        }
        final long begin = System.currentTimeMillis();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceItem[] items = ServiceConfig.getServerItems();
                if (items != null) {
                    for (ServiceItem item : items) {
                        LifecycleManager.startService(item);
                    }
                }
                LifecycleManager.startServiceMonitor(begin);
            }
        }, "Lifecycle-start-service");
        t.setDaemon(true);
        t.start();
    }

    private static void startServiceMonitor(long begin) {
        try {
            int N = 600;
            while (N-- > 0 && !startingList.isEmpty()) {
                Thread.sleep(1000L);
                int n = startingList.size();
                for (int i = 0; i < n; ++i) {
                    ServiceItem item = startingList.get(i);
                    if (!item.getInstance().isStarted()) continue;
                    item.setStarted(true);
                    for (ServiceItem child : item.getChildren()) {
                        LifecycleManager.startService(child);
                    }
                    startedList.add(item);
                    startingList.remove(i);
                    --i;
                    --n;
                }
            }
            long end = System.currentTimeMillis();
            log.info("lifecycle staring service finished, cost " + (end - begin) + "ms");
            if (!startingList.isEmpty()) {
                log.warn("service not start in " + (end - begin) + "ms: " + startingList);
            }
        }
        catch (InterruptedException e) {
            log.warn("Error when start service,", (Throwable)e);
        }
    }

    private static void startService(final ServiceItem item) {
        if (!item.isDisable() && item.isAllInputFinished()) {
            startingList.add(item);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    log.info("Starting server " + item.getName() + " by class " + item.getClassName());
                    try {
                        item.getInstance().start();
                    }
                    catch (Exception t) {
                        log.error("Error when starting server " + item.getName() + " by class " + item.getClassName(), (Throwable)t);
                        startingList.remove(item);
                    }
                }
            }, "Lifecycle-start-service-" + startThreadIndex.getAndIncrement());
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static void stop() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = startedList.size() - 1; i >= 0; --i) {
                    ServiceItem item = (ServiceItem)startedList.get(i);
                    try {
                        log.info("Stopping server " + item.getName() + " ,by class " + item.getClassName());
                        item.getInstance().stop();
                        log.info("Stopped server " + item.getName() + " ,by class " + item.getClassName());
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error when Stopped server " + item.getName(), (Throwable)e);
                    }
                }
                if (sysServices != null) {
                    for (Service service : sysServices) {
                        try {
                            if (!service.isStarted()) continue;
                            log.info("Stopping service " + service.getName());
                            service.stop();
                            log.info("Stopped service " + service.getName());
                        }
                        catch (Exception t) {
                            log.error("Stop service: " + service.getName() + " occur error.", (Throwable)t);
                        }
                    }
                }
            }
        }, "Lifecycle-stop-service").start();
    }
}

