/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle.appstart;

import java.util.List;
import kd.bos.context.OperationContextCreator;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.appstart.AppStarter;
import kd.bos.framework.lifecycle.appstart.AppStarterInstanceManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.AppUtils;

public class AppStarterService
implements Service {
    private static Log log = LogFactory.getLog(AppStarterService.class);
    private List<AppStarter> starterList;
    private boolean mIsStarted = false;

    @Override
    public String getName() {
        return "AppStarterService";
    }

    @Override
    public void start() {
        boolean isAppSplit;
        String[] _appIds = this.getDeployAppIds();
        boolean hasDebug = false;
        if (_appIds != null) {
            for (String appId : _appIds) {
                if (!"debug".equals(appId)) continue;
                hasDebug = true;
                break;
            }
        }
        if (isAppSplit = Instance.isAppSplit()) {
            this.starterList = _appIds != null && !hasDebug ? AppStarterInstanceManager.getAppStarter(_appIds) : AppStarterInstanceManager.getAppStarter();
        } else {
            boolean isCurrentDeployAlone = _appIds != null && _appIds.length == 1 && AppUtils.isDeployAloneApp((String)_appIds[0]);
            this.starterList = isCurrentDeployAlone ? AppStarterInstanceManager.getAppStarter(_appIds) : AppStarterInstanceManager.getAppStarter();
        }
        for (AppStarter appStarter : this.starterList) {
            ThreadPools.executeOnce("AppStarter-" + appStarter.getClass().getName(), () -> {
                try {
                    OperationContextCreator.getOrCreateForBos();
                    appStarter.start();
                }
                catch (Exception e) {
                    log.error("appstarter start app error", (Throwable)e);
                }
            });
        }
        this.mIsStarted = true;
    }

    private String[] getDeployAppIds() {
        String[] deployedAppIds = Instance.getDeployedAppIds();
        String[] appIds = Instance.getAppIds();
        if (deployedAppIds == null) {
            return appIds;
        }
        if (appIds != null) {
            String[] _ids = new String[deployedAppIds.length + appIds.length];
            System.arraycopy(deployedAppIds, 0, _ids, 0, deployedAppIds.length);
            System.arraycopy(appIds, 0, _ids, deployedAppIds.length, appIds.length);
            return _ids;
        }
        return null;
    }

    @Override
    public void stop() {
        this.mIsStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.mIsStarted;
    }
}

