/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.redis.RedisSessionableCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.services.sessionmanager.SessionManagerListener;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.thread.ThreadLocalUtils;
import kd.bos.trace.util.TraceIdUtil;

public class SessionManagerService
implements Service {
    private boolean mIsStarted = false;
    private RedisSessionableCache cache;
    private long sleeptimes = 1000000000L;
    private static final String SESSIONM_MANAGER_SLEEP_SECONDS = "sessionmanager.sleepsecond";
    private static final String SESSION_ACCOUNT_SPLITSTR = "@@@";
    private static Log log = LogFactory.getLog(SessionManagerService.class);

    @Override
    public String getName() {
        return "SessionIdManager";
    }

    @Override
    public void start() {
        if (Instance.isLightWeightDeploy()) {
            this.cache = new RedisSessionableCache();
        }
        this.mIsStarted = true;
        int sleepsecond = Integer.parseInt(System.getProperty(SESSIONM_MANAGER_SLEEP_SECONDS, "5"));
        new Thread(() -> {
            while (this.mIsStarted) {
                block13: {
                    try {
                        ThreadLifeCycleManager.start();
                        if (Instance.isLightWeightDeploy()) {
                            Map sessionIds = this.cache.getPartSessionIdsWithAccountId();
                            sessionIds.forEach((sessionId, sessionaccountid) -> {
                                if (!this.cache.existsSession(sessionId)) {
                                    this.doWithSessionId((String)sessionId, (String)sessionaccountid);
                                }
                            });
                            break block13;
                        }
                        try {
                            String[] sessionids;
                            this.cache = new RedisSessionableCache();
                            this.cache.pipelinedMode();
                            this.cache.getPartSessionIdsWithAccountId();
                            List ls = this.cache.syncAndReturn();
                            Map sessions = (Map)ls.get(0);
                            for (String sessionId2 : sessionids = sessions.keySet().toArray(new String[0])) {
                                this.cache.existsSession(sessionId2);
                            }
                            List existsls = this.cache.syncAndReturn();
                            for (int i = 0; i < sessionids.length; ++i) {
                                if (!Boolean.FALSE.equals(existsls.get(i))) continue;
                                String sessionId3 = sessionids[i];
                                this.doWithSessionId(sessionId3, (String)sessions.get(sessionId3));
                            }
                        }
                        finally {
                            if (this.cache != null) {
                                this.cache.syncAndClose();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e);
                    }
                    finally {
                        ThreadLocalUtils.clearCurrentThreadLocals();
                    }
                }
                LockSupport.parkNanos((long)sleepsecond * this.sleeptimes);
            }
        }, "SessionIdRecyleManager").start();
    }

    private void doWithSessionId(String sessionId, String sessionaccountid) {
        RequestContext rc = RequestContextCreator.createOnlySession(sessionId);
        String[] ids = sessionaccountid.split(SESSION_ACCOUNT_SPLITSTR);
        if (ids.length == 2) {
            rc.setTenantId(ids[0]);
            rc.setAccountId(ids[1]);
        } else {
            rc.setAccountId(sessionaccountid);
        }
        rc.setTraceId(TraceIdUtil.createTraceIdString());
        log.warn("session has time out with tenant&account: " + sessionaccountid);
        SessionManagerListener.destory(sessionId);
        this.cache.removeSessionId(new String[]{sessionId});
    }

    @Override
    public void stop() {
        this.mIsStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.mIsStarted;
    }
}

