/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle.services.sessionmanager;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.OperationContextCreator;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SessionListener;

public class SessionManagerListener {
    private static Log log = LogFactory.getLog(SessionManagerListener.class);
    private static List<SessionListener> listenerList = new ArrayList<SessionListener>();
    private static String[] sessionServiceClasses = null;

    private static void addListener(SessionListener listener) {
        listenerList.add(listener);
    }

    private static SessionListener createByClass(String className) {
        try {
            return (SessionListener)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            OperationContextCreator.getOrCreateForBos();
            log.error((Throwable)e);
            return null;
        }
    }

    private static String[] getSessionListenerClassString() {
        return new String[]{"kd.bos.web.SessionTimeoutListener", "kd.bos.login.listener.SessionTimeoutListener"};
    }

    public static void destory(String sessionId) {
        listenerList.forEach(listener -> {
            try {
                listener.destroy(sessionId);
            }
            catch (KDException e) {
                OperationContextCreator.getOrCreateForBos();
                log.info("sessionManagerListener destory session error,class:" + listener.getClass().getName(), (Object)e);
            }
            catch (Exception e) {
                OperationContextCreator.getOrCreateForBos();
                log.error("sessionManagerListener destory session error,class:" + listener.getClass().getName(), (Throwable)e);
            }
        });
    }

    static {
        sessionServiceClasses = SessionManagerListener.getSessionListenerClassString();
        for (int i = 0; i < sessionServiceClasses.length; ++i) {
            SessionListener s = SessionManagerListener.createByClass(sessionServiceClasses[i]);
            if (s == null) continue;
            SessionManagerListener.addListener(s);
        }
    }
}

