/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import java.io.IOException;
import java.nio.charset.Charset;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.msgjet.channel.Channel;
import kd.bos.msgjet.channel.rabbitmq.MsgJetConsumer;
import kd.bos.rabbitmq.RabbitmqFactory;

public class RabbitmqChannel
implements Channel {
    private static Channel instance = new RabbitmqChannel();
    protected static final String EXCHANGE_NAME = "exchange_msgjet_" + Instance.getClusterName();
    protected static final String EXCHANGE_REGION = "broadcast";
    protected static final String EXCHANGE_TYPE = "fanout";
    private com.rabbitmq.client.Channel prodecerChannel;

    public static Channel getInstance() {
        return instance;
    }

    @Override
    public void send(String o) {
        try {
            this.getBoradcastProducerChannel().basicPublish(EXCHANGE_NAME, "", null, o.getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"boradcast message error "});
        }
    }

    @Override
    public void registerCustomer() {
        try {
            com.rabbitmq.client.Channel channel = RabbitmqChannel.getChannel(EXCHANGE_REGION);
            channel.exchangeDeclare(EXCHANGE_NAME, EXCHANGE_TYPE);
            String queueName = channel.queueDeclare().getQueue();
            channel.queueBind(queueName, EXCHANGE_NAME, "");
            MsgJetConsumer consumer = new MsgJetConsumer(channel);
            consumer.setReciver(reciver);
            channel.basicConsume(queueName, true, (Consumer)consumer);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"can't init channel"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private com.rabbitmq.client.Channel getBoradcastProducerChannel() {
        if (this.prodecerChannel != null && this.prodecerChannel.isOpen()) return this.prodecerChannel;
        Class<RabbitmqChannel> clazz = RabbitmqChannel.class;
        synchronized (RabbitmqChannel.class) {
            if (this.prodecerChannel != null && this.prodecerChannel.isOpen()) return this.prodecerChannel;
            try {
                com.rabbitmq.client.Channel channel = RabbitmqChannel.getChannel(EXCHANGE_REGION);
                channel.exchangeDeclare(EXCHANGE_NAME, EXCHANGE_TYPE);
                this.prodecerChannel = channel;
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"can't create channel"});
            }
            return this.prodecerChannel;
        }
    }

    private static com.rabbitmq.client.Channel getChannel(String region) {
        String serverKey = RabbitmqChannel.getRegionServerKey(region);
        Connection con = RabbitmqFactory.getConnection((String)serverKey);
        try {
            return con.createChannel();
        }
        catch (IOException arg3) {
            throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"can't create channel", arg3});
        }
    }

    private static String getRegionServerKey(String region) {
        String serverKey = "mq.server." + region;
        String server = System.getProperty(serverKey);
        return server != null ? serverKey : "mq.server";
    }
}

