/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.websocket.jetty;

import java.util.Iterator;
import java.util.ServiceLoader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.websocket.WebSocketListener;
import kd.bos.msgjet.websocket.jetty.JettyMsgWebSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class MsgAdvancedCreator
implements WebSocketCreator {
    private static Log log = LogFactory.getLog(MsgAdvancedCreator.class);
    private static String LISTENER_CONFIG = "kd.bos.web.WebSocketIdRecorder,kd.bos.web.qing.QingWebSockerListener," + System.getProperty("websocket.listener.config", "");
    private JettyMsgWebSocket annotatedEchoSocket = new JettyMsgWebSocket();

    public MsgAdvancedCreator() {
        ServiceLoader<WebSocketListener> serviceLoader = ServiceLoader.load(WebSocketListener.class);
        Iterator<WebSocketListener> itr = serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                WebSocketListener listener = itr.next();
                if (!(listener instanceof WebSocketListener) || !LISTENER_CONFIG.contains(listener.getClass().getName())) continue;
                this.annotatedEchoSocket.registerListener(listener);
                log.info("MsgAdvancedCreator serviceLoader successfully loaded class: " + listener.getClass().getName());
            }
            catch (Error | Exception e) {
                log.warn("Load WebSocketListener failed,errorMessage:" + e.getMessage(), e);
            }
        }
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        return this.annotatedEchoSocket;
    }
}

