/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.websocket.tomcat;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import kd.bos.context.OperationContextCreator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.websocket.TokenUtils;
import kd.bos.msgjet.websocket.WebSocketListener;
import kd.bos.msgjet.websocket.WebSocketObject;

public class MsgwatchEndpoint
extends Endpoint {
    private static final String TENANTSESSIONKEY = "tenantsessionkey";
    private static String LISTENER_CONFIG = "kd.bos.web.WebSocketIdRecorder,kd.bos.web.qing.QingWebSockerListener," + System.getProperty("websocket.listener.config", "");
    private static Map<String, Set<Session>> map = new ConcurrentHashMap<String, Set<Session>>();
    private static Map<Session, String> sessionIdentifyMap = new ConcurrentHashMap<Session, String>();
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock.ReadLock rlock = lock.readLock();
    private static ReentrantReadWriteLock.WriteLock wlock = lock.writeLock();
    private static Log log = LogFactory.getLog(MsgwatchEndpoint.class);
    private static Map<String, WebSocketListener> listeners = new ConcurrentHashMap<String, WebSocketListener>();

    private static boolean check(Session session, String token) {
        OperationContextCreator.getOrCreateForBos();
        boolean isValite = false;
        isValite = TokenUtils.checkToken(token);
        if (!isValite) {
            if (Boolean.getBoolean("isOutputWebsocketLog")) {
                log.error("Unauthed session " + token + " in cluster " + Instance.getClusterName());
            }
            try {
                session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)4001), "not Authed session " + token + " in cluster " + Instance.getClusterName()));
            }
            catch (IOException e) {
                log.error("MsgwatchEndpoint onOpen close exception", (Throwable)e);
            }
        }
        return isValite;
    }

    private static String getToken(Session session) {
        HandshakeRequest request = (HandshakeRequest)session.getUserProperties().get(HandshakeRequest.class.getName());
        String tenantKey = MsgwatchEndpoint.getParamterFromQueryStr(request, TENANTSESSIONKEY);
        String token = null;
        if (tenantKey != null) {
            String wstk = MsgwatchEndpoint.getFromCookie(request, tenantKey);
            if (wstk != null) {
                token = wstk;
            } else {
                token = MsgwatchEndpoint.getParamterFromQueryStr(request, "token");
                if (token == null) {
                    try {
                        session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)4001), "not Authed in cluster " + Instance.getClusterName() + ",cannt got tenant session of " + tenantKey));
                    }
                    catch (IOException e) {
                        OperationContextCreator.getOrCreateForBos();
                        log.error("MsgwatchEndpoint onOpen close exception", (Throwable)e);
                    }
                }
            }
        } else {
            token = MsgwatchEndpoint.getParamterFromQueryStr(request, "token");
        }
        return token;
    }

    private static String getParamterFromQueryStr(HandshakeRequest request, String key) {
        List tokenLs = (List)request.getParameterMap().get(key);
        if (tokenLs != null) {
            return (String)tokenLs.get(0);
        }
        return null;
    }

    private static String getFromCookie(HandshakeRequest req, String wstkid) {
        String[] cookieStrs;
        List list = (List)req.getHeaders().get("cookie");
        if (wstkid == null || list == null || list.size() == 0) {
            return null;
        }
        for (String cookieStr : cookieStrs = ((String)list.get(0)).split(";")) {
            if (!cookieStr.contains("=")) {
                return null;
            }
            String[] cookieArr = cookieStr.split("=");
            if (!wstkid.equals(cookieArr[0].trim())) continue;
            return cookieArr[1];
        }
        return null;
    }

    private static void removeSession(Session session) {
        String ident = sessionIdentifyMap.remove(session);
        if (ident != null) {
            MsgwatchEndpoint.getIdentifySet(ident).remove(session);
        }
    }

    private static Set<Session> getIdentifySet(String id) {
        Set _set = map.computeIfAbsent(id, k -> new HashSet());
        return _set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(String identifyId, String msg) {
        OperationContextCreator.getOrCreateForBos();
        boolean isOutputWebsocketLog = Boolean.getBoolean("isOutputWebsocketLog");
        if (isOutputWebsocketLog) {
            log.info("sendBrowerMsg from websocket:" + identifyId + ",message:" + msg);
        }
        Set<Session> s = identifyId == null ? sessionIdentifyMap.keySet() : MsgwatchEndpoint.getIdentifySet(identifyId);
        HashSet removeSet = new HashSet();
        HashSet sendSet = new HashSet();
        try {
            rlock.lock();
            s.forEach(session -> {
                if (session.isOpen()) {
                    sendSet.add(session);
                } else {
                    removeSet.add(session);
                }
            });
        }
        finally {
            rlock.unlock();
        }
        try {
            sendSet.forEach(session -> session.getAsyncRemote().sendText(msg));
        }
        catch (Exception e) {
            log.error("session sendText error:", (Throwable)e);
        }
        if (!removeSet.isEmpty()) {
            try {
                wlock.lock();
                removeSet.forEach(session -> MsgwatchEndpoint.removeSession(session));
            }
            finally {
                wlock.unlock();
            }
        }
    }

    private static void registerListener() {
        ServiceLoader<WebSocketListener> serviceLoader = ServiceLoader.load(WebSocketListener.class);
        Iterator<WebSocketListener> itr = serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                WebSocketListener listener = itr.next();
                if (!(listener instanceof WebSocketListener) || !LISTENER_CONFIG.contains(listener.getClass().getName())) continue;
                MsgwatchEndpoint.registerListener(listener);
            }
            catch (Error | Exception e) {
                log.warn("Load WebSocketListener failed,errorMessage:" + e.getMessage(), e);
            }
        }
    }

    private static WebSocketListener createByClass(String className) {
        try {
            return (WebSocketListener)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("Tomcat websocket Can't create WebSocketListener by " + className);
            throw new KDException(BosErrorCode.cannotLoadBeanClass, new Object[]{"Can't create WebSocketListener by " + className});
        }
    }

    private static void registerListener(WebSocketListener listener) {
        listeners.put(listener.getClass().getName(), listener);
        log.info("MsgwatchEndpoint serviceLoader successfully loaded class: {}", (Object)listener.getClass().getName());
    }

    private static boolean isContain(String type, String paramListener) {
        return paramListener == null && type == null || paramListener != null && paramListener.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig config) {
        if (session.isOpen()) {
            String token = MsgwatchEndpoint.getToken(session);
            if (!MsgwatchEndpoint.check(session, token)) {
                return;
            }
            HandshakeRequest request = (HandshakeRequest)session.getUserProperties().get(HandshakeRequest.class.getName());
            final String ident = MsgwatchEndpoint.getParamterFromQueryStr(request, "identifytype");
            String paramListener = MsgwatchEndpoint.getParamterFromQueryStr(request, "listenerType");
            try {
                wlock.lock();
                if (ident != null) {
                    MsgwatchEndpoint.getIdentifySet(ident).add(session);
                    sessionIdentifyMap.put(session, ident);
                }
            }
            finally {
                wlock.unlock();
            }
            if (ident != null) {
                final String _t = token;
                listeners.forEach((k, v) -> {
                    try {
                        if (MsgwatchEndpoint.isContain(v.getType(), paramListener)) {
                            v.onConnect(new WebSocketObject(){

                                @Override
                                public String getSessionId() {
                                    return _t;
                                }

                                @Override
                                public String getIdentifyType() {
                                    return ident;
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                });
            }
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        try {
            wlock.lock();
            MsgwatchEndpoint.removeSession(session);
        }
        finally {
            wlock.unlock();
        }
        HandshakeRequest request = (HandshakeRequest)session.getUserProperties().get(HandshakeRequest.class.getName());
        String tenantKey = MsgwatchEndpoint.getParamterFromQueryStr(request, TENANTSESSIONKEY);
        String wstk = MsgwatchEndpoint.getFromCookie(request, tenantKey);
        if (wstk == null) {
            wstk = MsgwatchEndpoint.getParamterFromQueryStr(request, "token");
        }
        final String ident = MsgwatchEndpoint.getParamterFromQueryStr(request, "identifytype");
        String paramListener = MsgwatchEndpoint.getParamterFromQueryStr(request, "listenerType");
        if (wstk != null && ident != null) {
            final String token = wstk;
            listeners.forEach((k, v) -> {
                try {
                    if (MsgwatchEndpoint.isContain(v.getType(), paramListener)) {
                        v.onClose(new WebSocketObject(){

                            @Override
                            public String getSessionId() {
                                return token;
                            }

                            @Override
                            public String getIdentifyType() {
                                return ident;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    log.error((Throwable)e);
                }
            });
        }
    }

    public void onError(Session session, Throwable throwable) {
    }

    static {
        MsgwatchEndpoint.registerListener();
    }

    private static class MsgwatchMessageHandler
    implements MessageHandler.Partial<String> {
        private Session session;

        private MsgwatchMessageHandler(Session session) {
            this.session = session;
        }

        public void onMessage(String message, boolean last) {
            final String token = MsgwatchEndpoint.getToken(this.session);
            if (!MsgwatchEndpoint.check(this.session, token)) {
                return;
            }
            HandshakeRequest request = (HandshakeRequest)this.session.getUserProperties().get(HandshakeRequest.class.getName());
            final String ident = MsgwatchEndpoint.getParamterFromQueryStr(request, "identifytype");
            String paramListener = MsgwatchEndpoint.getParamterFromQueryStr(request, "listenerType");
            listeners.forEach((k, v) -> {
                try {
                    if (MsgwatchEndpoint.isContain(v.getType(), paramListener)) {
                        v.onMessage(new WebSocketObject(){

                            @Override
                            public String getSessionId() {
                                return token;
                            }

                            @Override
                            public String getIdentifyType() {
                                return ident;
                            }
                        }, message);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            });
        }
    }
}

