/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyPair;
import kd.bos.cache.CacheData;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.RSAUtils;
import kd.bos.util.EncryptUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class KeysUtils {
    private static Log logger = LogFactory.getLog(KeysUtils.class);
    public static final String ENCRYPTED_TOKEN = "stoken";
    public static final int ACCESS_KEY_TIME_OUT = 60;

    public static String getPublicKeyByAccessKey(String accessKey) throws KDException {
        String publicKey = "";
        KeyPair keyPair = RSAUtils.generateKeyPair();
        publicKey = RSAUtils.generateBase64Key(keyPair.getPublic().getEncoded());
        String privateKey = RSAUtils.generateBase64Key(keyPair.getPrivate().getEncoded());
        CacheData.setAttribute(KeysUtils.getAccessKeyType(), accessKey, privateKey, 60);
        return publicKey;
    }

    private static String getAccessKeyType() {
        return "tokenPass";
    }

    public static String getDecryptedPassword(String userPassword, String accessKey) {
        String returnPass = null;
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)userPassword)) {
            String privateKey = CacheData.getAttribute(KeysUtils.getAccessKeyType(), accessKey);
            returnPass = new String(RSAUtils.decryptByKey(RSAUtils.getPrivateKey(Base64.decodeBase64((String)privateKey)), Base64.decodeBase64((byte[])userPassword.getBytes(Charsets.UTF_8))));
        }
        return returnPass;
    }

    public static String encryptTokenLoinSession(String url, String globalSessionId, long duration) throws UnsupportedEncodingException {
        String returnValue = null;
        if (StringUtils.isNotEmpty((String)globalSessionId)) {
            String accessKey = StringUtils.randomWord((int)KeysUtils.getAccessKeyLength());
            String publicKey = KeysUtils.getPublicKeyByAccessKey(accessKey);
            String sessionMd5 = EncryptUtils.encryptPSW((String)globalSessionId);
            String encryptedContent = new String(Base64.encodeBase64((byte[])RSAUtils.encryptByKey(RSAUtils.getPublicKey(Base64.decodeBase64((String)publicKey)), sessionMd5.getBytes(Charsets.UTF_8))));
            CacheData.setAttribute(KeysUtils.getTokenKey(), accessKey + sessionMd5, Encrypters.encode((String)globalSessionId), (int)duration);
            String md5 = EncryptUtils.encryptPSW((String)(accessKey + sessionMd5));
            md5 = KeysUtils.specialHandle(md5);
            CacheData.setAttribute(KeysUtils.getTokenKey(), md5, accessKey + encryptedContent, (int)duration);
            returnValue = url + "&" + ENCRYPTED_TOKEN + "=" + URLEncoder.encode(md5, "UTF-8");
        }
        return returnValue;
    }

    private static String specialHandle(String md5) {
        String returnValue = md5;
        if (md5 != null) {
            returnValue = md5.replaceAll("\\+", "S");
            returnValue = returnValue.replace(" ", "A");
            returnValue = returnValue.replace("=", "E");
            returnValue = returnValue.replace("/", "Z");
            returnValue = returnValue.replace("\r", "");
            returnValue = returnValue.replace("\n", "");
        }
        return returnValue;
    }

    private static String getTokenKey() {
        return "sec_token";
    }

    private static int getAccessKeyLength() {
        return 6;
    }

    public static String decryptTokenSessionId(String sToken) {
        if (StringUtils.isEmpty((String)sToken)) {
            return null;
        }
        String globalSession = null;
        try {
            String cacheString = CacheData.getAttribute(KeysUtils.getTokenKey(), sToken);
            if (StringUtils.isNotEmpty((String)cacheString) && cacheString.length() > KeysUtils.getAccessKeyLength()) {
                String accessToken = cacheString.substring(0, KeysUtils.getAccessKeyLength());
                String encryptedString = cacheString.substring(KeysUtils.getAccessKeyLength(), cacheString.length() - 1);
                String md5 = globalSession = KeysUtils.getDecryptedPassword(encryptedString, accessToken);
                String encryptMD5 = CacheData.getAttribute(KeysUtils.getTokenKey(), accessToken + md5);
                if (StringUtils.isNotEmpty((String)encryptMD5)) {
                    globalSession = Encrypters.decode((String)encryptMD5);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
        return globalSession;
    }

    public static void main(String[] args) {
        String md5 = "sdfdsf+erew e";
    }
}

