/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.redis.RedisSessionableCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SessionInfo;
import kd.bos.util.StringUtils;

public class SessionQuery {
    private static Log logger = LogFactory.getLog(SessionQuery.class);
    private static final String CLIENT_BATCH = "batch";
    private static final String SESSION_ID = "sessionId";
    private static RedisSessionableCache cache = new RedisSessionableCache();
    private static RedisSessionableCache pipelineCache;
    private static String[] ACCOUNTID_USERID_ORGID;
    private static String[] ACCOUNTID_USERID;
    private static final int BATCH_SIZE = 10000;
    private static final String KEY = "onlineuser.pipeline.batchsize";

    private static int getBatchSize() {
        String value = System.getProperty(KEY);
        if (StringUtils.isNumeric((String)value)) {
            int batchSize = Integer.parseInt(value);
            return Math.min(batchSize, 100000);
        }
        return 10000;
    }

    public static List<Map<String, String>> getAllSessions(String[] attributes) {
        Set sessionIds = cache.getSessionIds();
        List<Object> data = SessionQuery.getSessionsByPipeline(sessionIds, attributes);
        return SessionQuery.wrapResult(data, attributes);
    }

    public static List<Map<String, String>> getAllSessions(String accountId, String[] attributes) {
        ArrayList<String> lstAtt = new ArrayList<String>(attributes.length);
        Collections.addAll(lstAtt, attributes);
        if (!lstAtt.contains("accountId")) {
            lstAtt.add("accountId");
        }
        String[] atts = lstAtt.toArray(new String[0]);
        Set<String> sessionIds = cache.getSessionIds();
        sessionIds = sessionIds.stream().filter(sessionId -> sessionId != null && sessionId.startsWith(accountId)).collect(Collectors.toSet());
        List<Object> data = SessionQuery.getSessionsByPipeline(sessionIds, atts);
        return SessionQuery.wrapResult(data, atts);
    }

    public static List<String> getUserSessions(String accountId, String userId) {
        ArrayList<String> sessions = new ArrayList<String>();
        Set<String> sessionIds = cache.getSessionIds();
        sessionIds = sessionIds.stream().filter(sessionId -> sessionId != null && sessionId.startsWith(accountId)).collect(Collectors.toSet());
        List<Object> data = SessionQuery.getSessionsByPipeline(sessionIds, ACCOUNTID_USERID);
        List<Map<String, String>> resultMap = SessionQuery.wrapResult(sessionIds, data, ACCOUNTID_USERID);
        for (Map<String, String> ms : resultMap) {
            if (ms == null || !accountId.equalsIgnoreCase(ms.get("accountId")) || !userId.equalsIgnoreCase(ms.get("userId"))) continue;
            sessions.add(ms.get(SESSION_ID));
        }
        return sessions;
    }

    public static List<SessionInfo> getUserSessions(String accountId) {
        ArrayList<SessionInfo> sessions = new ArrayList<SessionInfo>();
        Set<String> sessionIds = cache.getSessionIds();
        sessionIds = sessionIds.stream().filter(sessionId -> sessionId != null && sessionId.startsWith(accountId)).collect(Collectors.toSet());
        List<Object> data = SessionQuery.getSessionsByPipeline(sessionIds, ACCOUNTID_USERID_ORGID);
        List<Map<String, String>> resultMap = SessionQuery.wrapResult(sessionIds, data, ACCOUNTID_USERID_ORGID);
        for (Map<String, String> ms : resultMap) {
            if (ms == null || !accountId.equalsIgnoreCase(ms.get("accountId"))) continue;
            SessionInfo sessionInfo = new SessionInfo();
            sessionInfo.setGloableSessionId(ms.get(SESSION_ID));
            sessionInfo.setUserId(ms.get("userId"));
            sessionInfo.setOrgId(ms.get("orgId"));
            sessions.add(sessionInfo);
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Object> getSessionsByPipeline(Set<String> sessionIds, String[] atts) {
        logger.info("SessionQuery--getSessionsByPipeline sessionIds size:" + sessionIds.size());
        try {
            int batchSize = SessionQuery.getBatchSize();
            pipelineCache = new RedisSessionableCache();
            pipelineCache.pipelinedMode();
            ArrayList<Object> data = new ArrayList<Object>();
            int num = 0;
            for (String sessionId : sessionIds) {
                pipelineCache.get(sessionId, atts);
                if (++num != batchSize) continue;
                List result = pipelineCache.syncAndReturn();
                logger.info("SessionQuery--syncAndReturn size:" + result.size());
                data.addAll(result);
                num = 0;
            }
            List result = pipelineCache.syncAndReturn();
            logger.info("SessionQuery--last syncAndReturn size:" + result.size());
            data.addAll(result);
            ArrayList<Object> arrayList = data;
            return arrayList;
        }
        finally {
            if (pipelineCache != null) {
                pipelineCache.syncAndClose();
            }
        }
    }

    private static List<Map<String, String>> wrapResult(List<Object> data, String[] keys) {
        if (data == null) {
            return null;
        }
        ArrayList<Map<String, String>> sessions = new ArrayList<Map<String, String>>(data.size());
        for (Object atts : data) {
            List v = (List)atts;
            HashMap result = new HashMap(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                result.put(keys[i], v.get(i));
            }
            sessions.add(result);
        }
        return sessions;
    }

    private static List<Map<String, String>> wrapResult(Set<String> sessionIds, List<Object> data, String[] keys) {
        if (data == null) {
            return null;
        }
        ArrayList<Map<String, String>> sessions = new ArrayList<Map<String, String>>(data.size());
        int index = 0;
        for (String sessionId : sessionIds) {
            Object atts = data.get(index);
            List v = (List)atts;
            HashMap<String, Object> result = new HashMap<String, Object>(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                result.put(keys[i], v.get(i));
            }
            result.put(SESSION_ID, sessionId);
            sessions.add(result);
            ++index;
        }
        return sessions;
    }

    static {
        ACCOUNTID_USERID_ORGID = new String[]{"accountId", "userId", "orgId"};
        ACCOUNTID_USERID = new String[]{"accountId", "userId"};
    }
}

