/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.threads;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.LockSupport;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class WaitingRejectedHandler
implements RejectedExecutionHandler {
    private static ThreadLocal<SubmitRunnableInfo> task = new ThreadLocal();

    @Override
    public void rejectedExecution(Runnable k, ThreadPoolExecutor v) {
        SubmitRunnableInfo submitRunableInfo = task.get();
        if (submitRunableInfo == null) {
            submitRunableInfo = new SubmitRunnableInfo(k, v);
            task.set(submitRunableInfo);
        }
        if (this.isSameTask(submitRunableInfo, k, v)) {
            submitRunableInfo = new SubmitRunnableInfo(k, v);
            task.set(submitRunableInfo);
        }
        submitRunableInfo.incrementRejectTimes();
        if (submitRunableInfo.getRejectTimes() > 100) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Thread pool is full ! Thread Name: %s, Pool Size: %d (active: %d, core: %d, max: %d, largest: %d), Task: %d (completed: %d), Executor status:(isShutdown:%s, isTerminated:%s, isTerminating:%s)", Thread.currentThread().getName(), v.getPoolSize(), v.getActiveCount(), v.getCorePoolSize(), v.getMaximumPoolSize(), v.getLargestPoolSize(), v.getTaskCount(), v.getCompletedTaskCount(), v.isShutdown(), v.isTerminated(), v.isTerminating())});
        }
        while (!v.isShutdown()) {
            LockSupport.parkNanos(100 * submitRunableInfo.getRejectTimes());
            if ((double)v.getActiveCount() < (double)v.getMaximumPoolSize() * 0.9) {
                v.execute(k);
                return;
            }
            LockSupport.parkNanos(100000000 * submitRunableInfo.getRejectTimes());
        }
    }

    private boolean isSameTask(SubmitRunnableInfo submitRunableInfo, Runnable k, ThreadPoolExecutor v) {
        return submitRunableInfo.runnable != k || submitRunableInfo.pool != v;
    }

    private static class SubmitRunnableInfo {
        private int rejectTimes = 0;
        private Runnable runnable;
        private ThreadPoolExecutor pool;

        SubmitRunnableInfo(Runnable k, ThreadPoolExecutor v) {
            this.runnable = k;
            this.pool = v;
        }

        public int getRejectTimes() {
            return this.rejectTimes;
        }

        public void incrementRejectTimes() {
            ++this.rejectTimes;
        }
    }
}

