/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.threads.impl;

import java.util.concurrent.Callable;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.thread.ArchiveRouteAutoContext;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.util.TraceIdUtil;

public class RequestContextCallable<V>
implements Callable<V> {
    private final Callable<V> callable;
    private final OperationContext oc;
    private RequestContext rc;
    private ArchiveRouteAutoContext arCtx;

    public RequestContextCallable(RequestContextCallable<V> callable, RequestContext rc) {
        this(callable, rc, null);
    }

    public RequestContextCallable(Callable<V> callable, RequestContext rc, OperationContext oc) {
        if (rc != null) {
            this.rc = RequestContext.copy(rc);
        }
        this.callable = callable;
        this.oc = oc;
        this.arCtx = ArchiveRouteAutoContext.create();
    }

    /*
     * Loose catch block
     */
    @Override
    public V call() throws Exception {
        this.arCtx.mapRoute();
        try {
            V v;
            long id = TraceIdUtil.createTraceId();
            String traceId = TraceIdUtil.idToHex((long)id);
            if (this.rc != null) {
                this.rc.setTraceId(traceId);
                RequestContextCreator.restoreForThreadPool(this.rc);
            } else {
                this.rc = RequestContext.create();
                this.rc.setTraceId(traceId);
            }
            String threadName = Thread.currentThread().getName();
            int index = threadName.indexOf("/");
            String tempName = threadName;
            if (index > 0) {
                tempName = threadName.substring(0, index);
            }
            try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)tempName);){
                span.addTag("threadName", threadName);
                span.addTag("tenantId", this.rc.getTenantId());
                span.addTag("accountId", this.rc.getAccountId());
                if (this.oc != null) {
                    OperationContext.set((OperationContext)this.oc);
                    span.addTag("appId", this.oc.getAppId());
                }
                v = this.callable.call();
            }
            return v;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.arCtx.close();
        }
    }
}

