/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.url;

import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.UrlServiceForEreceipt;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

@KSObject
public class UrlService {
    public static final String DOMAINURL = "domain.contextUrl";
    public static final String DOMAINURL_ENFORCE = "domain.contextUrl.enforce";
    public static final String DOMAINTENANTCODE = "domain.tenantCode";
    public static final String MOBILE_DOMAINURL = "mobile.domain.contextUrl";
    public static final String OLD_IMAGEFILESERVER = "fileserver";
    public static final String ATTACHMENTFILESERVER = "attachment.fileserver";
    public static final String IMAGEFILESERVER = "image.fileserver";
    private static final String TENANTCODE_PAYLOAD = "{tenantCode}";
    private static final String TENANTCODE_PAYLOAD_REGEX = "\\{tenantCode\\}";
    private static final String FILESERVER_CHECKAUTH_ENABLE = "fileserver.checkauth.enable";
    private static final String ATTACHMENT_DOWNLOAD = "/attachment/download.do?path=/";

    public static String getAttachmentFullUrl(String path) {
        String domianUrl = UrlService.getDomainContextUrl();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (domianUrl == null) {
            String str = System.getProperty(ATTACHMENTFILESERVER);
            if (!str.endsWith("/")) {
                str = str + "/";
            }
            return str + path;
        }
        return domianUrl + ATTACHMENT_DOWNLOAD + path;
    }

    public static String getAttachmentPreviewUrl(String path) {
        String domianUrl = UrlService.getDomainContextUrl();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (domianUrl == null) {
            String str = System.getProperty(ATTACHMENTFILESERVER);
            if (!str.endsWith("/")) {
                str = str + "/";
            }
            return str + path;
        }
        return domianUrl + "/attachment/preview.do?path=/" + path;
    }

    public static String getAttachmentPrefixUrl() {
        String domianUrl = UrlService.getDomainContextUrl();
        if (domianUrl == null) {
            return System.getProperty(ATTACHMENTFILESERVER);
        }
        return domianUrl + ATTACHMENT_DOWNLOAD;
    }

    @KSMethod
    public static String getDomainContextUrl() {
        if (RequestContext.get() != null) {
            return UrlService.getDomainContextUrlByTenantCode(RequestContext.get().getTenantCode());
        }
        return UrlService.getDomainContextUrlByTenantCode("");
    }

    public static String getMobileDomainContextUrl() {
        return UrlService.getMobileDomainContextUrlByTenantCode(RequestContext.get().getTenantCode());
    }

    public static String getMobileDomainContextUrlByTenantCode(String tenantCode) {
        String mobileDomainConfig = System.getProperty(MOBILE_DOMAINURL);
        if (mobileDomainConfig == null || mobileDomainConfig.length() == 0) {
            return UrlService.getDomainContextUrlByTenantCode(tenantCode);
        }
        if (mobileDomainConfig.contains(TENANTCODE_PAYLOAD) && tenantCode != null) {
            mobileDomainConfig = mobileDomainConfig.replaceAll(TENANTCODE_PAYLOAD_REGEX, tenantCode);
        }
        if (mobileDomainConfig.endsWith("/")) {
            mobileDomainConfig = mobileDomainConfig.substring(0, mobileDomainConfig.length() - 1);
        }
        return mobileDomainConfig;
    }

    public static String getDomainContextUrlByTenantCode(String tenantCode) {
        String enforceString = System.getProperty(DOMAINURL_ENFORCE);
        String domainUrl = "";
        if (!"true".equalsIgnoreCase(enforceString) && RequestContext.get() != null && StringUtils.isNotEmpty((String)RequestContext.get().getClientFullContextPath())) {
            domainUrl = RequestContext.get().getClientFullContextPath();
        }
        if (StringUtils.isEmpty((String)domainUrl)) {
            domainUrl = System.getProperty(DOMAINURL);
        }
        if (StringUtils.isNotEmpty((String)domainUrl) && domainUrl.contains(TENANTCODE_PAYLOAD)) {
            domainUrl = domainUrl.replaceAll(TENANTCODE_PAYLOAD_REGEX, tenantCode);
        }
        if (StringUtils.isNotEmpty((String)domainUrl)) {
            domainUrl = RevProxyUtil.addSlash((String)domainUrl);
        }
        if (domainUrl.endsWith("/")) {
            domainUrl = domainUrl.substring(0, domainUrl.length() - 1);
        }
        return domainUrl;
    }

    public static String getWebSocketPreUrl() {
        String domainConfig = UrlService.getDomainContextUrl();
        if (domainConfig == null) {
            return null;
        }
        if (domainConfig.startsWith("http:")) {
            domainConfig = domainConfig.replaceAll("http:", "ws:");
        } else if (domainConfig.startsWith("https:")) {
            domainConfig = domainConfig.replaceAll("https:", "wss:");
        }
        domainConfig = domainConfig.endsWith("/") ? domainConfig + "msgwatch/" : domainConfig + "/msgwatch/";
        return domainConfig;
    }

    public static String getAttachmentFullUrl(String path, String nouse) {
        String domianUrl = UrlService.getDomainContextUrl(nouse);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (domianUrl == null) {
            return System.getProperty(ATTACHMENTFILESERVER) + path;
        }
        return domianUrl + ATTACHMENT_DOWNLOAD + path;
    }

    public static String getAttachmentPrefixUrl(String nouse) {
        String domianUrl = UrlService.getDomainContextUrl(nouse);
        if (domianUrl == null) {
            return System.getProperty(ATTACHMENTFILESERVER);
        }
        return domianUrl + ATTACHMENT_DOWNLOAD;
    }

    public static String getDomainContextUrl(String nouse) {
        return UrlService.getDomainContextUrl();
    }

    public static String getTenantCode(HttpServletRequest request) {
        String tenantCode = null;
        RequestContext rc = RequestContext.get();
        if (rc != null && (tenantCode = rc.getTenantCode()) != null) {
            return tenantCode;
        }
        tenantCode = System.getProperty(DOMAINTENANTCODE);
        if (tenantCode != null) {
            return tenantCode;
        }
        tenantCode = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        return tenantCode;
    }

    public static String getImageFullUrl(String path) {
        if ("true".equals(System.getProperty(FILESERVER_CHECKAUTH_ENABLE))) {
            return UrlService.getDownloadImageFullUrl(path);
        }
        if (!FileServiceFactory.isDefaultImageFileStorageClass()) {
            return UrlService.getFullUrlFromOos(path);
        }
        String imageServerUrl = System.getProperty(IMAGEFILESERVER);
        if (StringUtils.isNotEmpty((String)RequestContext.get().getClientImageServer())) {
            imageServerUrl = RequestContext.get().getClientImageServer();
        }
        if (null == imageServerUrl) {
            imageServerUrl = System.getProperty(OLD_IMAGEFILESERVER);
        }
        if (!imageServerUrl.endsWith("/")) {
            imageServerUrl = imageServerUrl + "/";
        }
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        return imageServerUrl + path;
    }

    private static String getDownloadImageFullUrl(String path) {
        String domianUrl = UrlService.getDomainContextUrl();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (domianUrl == null) {
            String str = System.getProperty(IMAGEFILESERVER);
            if (!str.endsWith("/")) {
                str = str + "/";
            }
            return str + path;
        }
        return domianUrl + "/image/downloadImage.do?path=/" + path;
    }

    public static String getFullUrlFromOos(String oosUrl) {
        String rootUrl = UrlService.getDomainContextUrl();
        if (!rootUrl.endsWith("/")) {
            rootUrl = rootUrl + "/";
        }
        return rootUrl + "image/downloadImage.do?path=" + oosUrl;
    }

    private static String getMobileDownloadImageFullUrl(String path) {
        String domianUrl = UrlService.getMobileDomainContextUrl();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (domianUrl == null) {
            String str = System.getProperty(IMAGEFILESERVER);
            if (!str.endsWith("/")) {
                str = str + "/";
            }
            return str + path;
        }
        return domianUrl + "/image/downloadImage.do?path=/" + path;
    }

    public static final String getEreceiptFullUrl(String path) {
        return UrlServiceForEreceipt.getEreceiptFullUrl((String)path);
    }
}

