/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql;

import kd.bos.ksql.FormaterContext;
import kd.bos.ksql.KSqlLimiter;
import kd.bos.ksql.TransInner;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.shell.trace.TraceInfo;

public final class TransUtil {
    public static final String Dialect_Prefix = "/*dialect*/";
    private static final int DIALECT_PREFIX_LENGTH = "/*dialect*/".length();
    private static boolean throwExWhenNameTooLong = false;

    private TransUtil() {
    }

    public static String translate(String kSql, int targetDbType) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    public static String translate(String kSql, int targetDbType, FormatOptions options) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, options, null, throwExWhenNameTooLong);
    }

    public static String translate(String kSql, int targetDbType, FormatOptions options, FormaterContext formaterContext, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        if (kSql == null || kSql.length() == 0) {
            throw new IllegalArgumentException("KSQL can not be empty!");
        }
        if ((kSql.charAt(0) == ' ' || kSql.charAt(kSql.length() - 1) == ' ') && (kSql = kSql.trim()).length() == 0) {
            throw new IllegalArgumentException("KSQL can not be empty!");
        }
        if (targetDbType == 6 && Boolean.parseBoolean(System.getProperty("ksql.mysql.escape.slash", "true"))) {
            StringBuilder buf = new StringBuilder(kSql.length());
            for (char ch : kSql.toCharArray()) {
                if (ch == '\\') {
                    buf.append(ch);
                }
                buf.append(ch);
            }
            if (kSql.length() != buf.length()) {
                kSql = buf.toString();
            }
        }
        KSqlLimiter.limitMaxLength(kSql);
        if (kSql.startsWith(Dialect_Prefix)) {
            kSql = kSql.substring(DIALECT_PREFIX_LENGTH);
            while (kSql.startsWith(Dialect_Prefix)) {
                kSql = kSql.substring(DIALECT_PREFIX_LENGTH);
            }
            if (kSql.length() == 0) {
                throw new IllegalArgumentException("KSQL can not be empty!");
            }
            if (TransInner.isWarnDialectSQL()) {
                TransInner.warnDialectSQL(kSql);
            }
            return kSql;
        }
        String ret = TransInner.transSQL(kSql, targetDbType, options, formaterContext, throwExWhenNameTooLong);
        if (ret.length() == 0) {
            throw new IllegalArgumentException("KSQL can not be empty: " + kSql);
        }
        return ret;
    }

    public static boolean isThrowExWhenNameTooLong() {
        return throwExWhenNameTooLong;
    }

    public static void setThrowExWhenNameTooLong(boolean throwExWhenNameTooLong) {
        TransUtil.throwExWhenNameTooLong = throwExWhenNameTooLong;
    }

    @Deprecated
    public static final String translate(String kSql, int targetDbType, TraceInfo traceInfo) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static final String translate(String kSql, int targetDbType, TraceInfo traceInfo, FormaterContext formaterContext) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, traceInfo == null ? null : traceInfo.getFormatOptions(), formaterContext, throwExWhenNameTooLong);
    }

    @Deprecated
    public static final String translate(String kSql, int targetDbType, TraceInfo traceInfo, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static String translate(String kSql, int targetDbType, FormatOptions options, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, options, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static final String translate(String ksql, int targetDbType, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(ksql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static String translate(StringBuilder sqlBuffer, int targetDbType) throws SqlTranslateException {
        return TransUtil.translate(sqlBuffer.toString(), targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static String translate(StringBuilder sqlBuffer, int targetDbType, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(sqlBuffer.toString(), targetDbType, null, null, throwExWhenNameTooLong);
    }

    public static void main(String[] args) throws Exception {
        String ksql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_BAS_IMAGEREMIND')    CREATE TABLE T_BAS_IMAGEREMIND (  FID BIGINT DEFAULT 0 NOT NULL,  FNUMBER VARCHAR(50) DEFAULT ' ' NOT NULL,  FSTATUS VARCHAR(10) DEFAULT ' ' NOT NULL,  FCREATORID BIGINT DEFAULT 0 NOT NULL,  FCREATETIME DATETIME,  FMODIFIERID BIGINT DEFAULT 0 NOT NULL,  FMODIFYTIME DATETIME,  FENABLE CHAR(1) DEFAULT ' ' NOT NULL,  FMESSAGETITLE NVARCHAR(1000) DEFAULT ' ' NOT NULL,  FEXPIREDDAY INT DEFAULT 0 NOT NULL,  FREMINDCYCLE INT DEFAULT 0 NOT NULL,  FMESSAGECHANNEL NVARCHAR(10) DEFAULT ' ' NOT NULL,  FMESSAGEOBJECT NVARCHAR(10) DEFAULT ' ' NOT NULL,  FMESSAGETEMPLATE NVARCHAR(1000) DEFAULT ' ' NOT NULL,  FPRIORITY NVARCHAR(10) DEFAULT ' ' NOT NULL,  FMASTERID BIGINT DEFAULT 0 NOT NULL  );";
        ksql = "SELECT FLOCALEID,FNAME,FDESCRIPTION FROM T_META_APPRUNTIME_L WHERE FAPPID='XXX', 1003, 1007";
        ksql = " \r\n ";
        String sql = TransUtil.translate(ksql, 6);
        System.out.println(sql);
    }
}

