/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.Iterator;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.formater.DrSQLFormater;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.util.DisCardUtil;

public class DrStyleSQLFormater
extends DrSQLFormater {
    public static final DrStyleSQLFormater instance = new DrStyleSQLFormater();

    protected DrStyleSQLFormater() {
    }

    public void formatSelect(SqlSelect select, StringBuilder buffer, FormatOptions options) throws FormaterException {
        buffer.append("SELECT ");
        if (select.distinct == 1) {
            buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("distinct option not support.");
        }
        if (select.limit != null) {
            buffer.append("TOP ");
            buffer.append(select.limit.rowCount);
            buffer.append(" ");
            if (select.limit.type == 1) {
                throw new FormaterException("TOP PERCENT is not support.");
            }
        }
        Iterator iterator = select.selectList.iterator();
        int itemIndex = 0;
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                buffer.append(", ");
            }
            if (++itemIndex % 4 == 0) {
                buffer.append("\n        ");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            this.formatSelectItem(item);
            flag = true;
        }
        if (select.tableSource != null) {
            buffer.append("\n    FROM ");
            this.formatTableSource(select.tableSource);
        }
        if (select.condition != null) {
            buffer.append("\n        WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        if (select.groupBy.size() != 0) {
            buffer.append("\n            GROUP BY ");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
        if (select.having != null) {
            buffer.append("\n                HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            buffer.append("\n    ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.mode == 0) {
                    buffer.append(" ASC");
                } else {
                    buffer.append(" DESC");
                }
                flag = true;
            }
        }
    }

    @Override
    public void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            this.buffer.append(simpleTableSource.name);
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias);
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(" CROSS JOIN ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias);
            }
        } else {
            throw new FormaterException("not support tableSource:" + tableSource);
        }
    }
}

