/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import kd.bos.ksql.DbType;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.DB2AS400SQLFormater;
import kd.bos.ksql.formater.DB2SQLFormater;
import kd.bos.ksql.formater.DMSQLFormater;
import kd.bos.ksql.formater.DerbySQLFormater;
import kd.bos.ksql.formater.GS100SQLFormater;
import kd.bos.ksql.formater.GSSQLFormater;
import kd.bos.ksql.formater.KingBaseSQLFormater;
import kd.bos.ksql.formater.MSTransactSQLFormater;
import kd.bos.ksql.formater.MySQLFormater;
import kd.bos.ksql.formater.OpenGaussSQLFormater;
import kd.bos.ksql.formater.Oracle10SQLFormater;
import kd.bos.ksql.formater.Oracle9SQLFormater;
import kd.bos.ksql.formater.PostgresSQLFormater;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.formater.SybaseTransactSQLFormater;

public abstract class FormaterFactory {
    public static SQLFormater getFormater(int dbType) throws SqlTranslateException {
        switch (dbType) {
            case 9: {
                return new DB2AS400SQLFormater();
            }
            case 1: {
                return new DB2SQLFormater();
            }
            case 6: {
                return new MySQLFormater();
            }
            case 3: {
                return new MSTransactSQLFormater();
            }
            case 2: {
                return new Oracle9SQLFormater();
            }
            case 8: {
                return new Oracle10SQLFormater();
            }
            case 7: {
                return new Oracle9SQLFormater();
            }
            case 5: {
                return new PostgresSQLFormater();
            }
            case 4: {
                return new SybaseTransactSQLFormater();
            }
            case 10: {
                return new DerbySQLFormater();
            }
            case 11: {
                return new DMSQLFormater();
            }
            case 12: {
                return new GSSQLFormater();
            }
            case 13: {
                return new GS100SQLFormater();
            }
            case 14: {
                return new OpenGaussSQLFormater();
            }
            case 15: {
                return new KingBaseSQLFormater();
            }
        }
        throw new SqlTranslateException("DbType is not supported." + DbType.getName(dbType));
    }
}

