/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.ksql.dom.AbstractUpdateItem;
import kd.bos.ksql.dom.SqlAlterTableAddDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableAddItem;
import kd.bos.ksql.dom.SqlAlterTableAlterColumnItem;
import kd.bos.ksql.dom.SqlAlterTableDropDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableDropItem;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.SqlUpdateItem;
import kd.bos.ksql.dom.SubQueryUpdateItem;
import kd.bos.ksql.dom.expr.QueryExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlTrancateTableStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.TSQLFormater;
import kd.bos.ksql.parser.Token;
import kd.bos.util.DisCardUtil;

public class SybaseTransactSQLFormater
extends TSQLFormater {
    private int drivedTableAliasCount = 0;
    private boolean isIndentity = false;

    public SybaseTransactSQLFormater(StringBuilder sb) {
        super(sb);
        this.max_length_of_index_name = 128;
        this.max_length_of_table_name = 128;
        this.max_length_of_constraint_name = 128;
        this.max_length_of_column_name = 128;
        this.max_length_of_column_count = 1023;
        this.max_length_of_row_size = 8000;
    }

    public SybaseTransactSQLFormater() {
        this(null);
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        String sql = "select name from sysobjects where type = N'U' order by name";
        this.buffer.append(sql);
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String tableName = stmt.tableName;
        String sql = tableName != null && tableName.length() != 0 ? "select a.name COLUMN_NAME, b.name DATA_TYPE, a.length DEFAULT_LENGTH, a.prec DATA_PRECISION, a.scale DATA_SCALE, convert(bit,(a.status & 8)) NULLABLE, object_name(a.id) as TABLE_NAME from syscolumns a inner join systypes b on a.type = b.type where object_name(a.id) = '" + this.formatTableName(stmt.tableName) + "' order by TABLE_NAME, COLUMN_NAME" : "select a.name COLUMN_NAME, b.name DATA_TYPE, a.length DEFAULT_LENGTH, a.prec DATA_PRECISION, a.scale DATA_SCALE, convert(bit,(a.status & 8)) NULLABLE, object_name(a.id) as TABLE_NAME from syscolumns a inner join systypes b on a.type = b.type order by TABLE_NAME, COLUMN_NAME";
        this.buffer.append(sql);
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(this.formatColumnName(column.name)).append(" ");
        if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("NVARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("IMAGE");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("BINARY (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARBINARY (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (!column.autoIncrement) {
            if (column.isPrimaryKey) {
                this.buffer.append(" NOT NULL");
            } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
                this.buffer.append(" NOT NULL");
            } else {
                this.buffer.append(" NULL");
            }
        }
        if (column.autoIncrement) {
            this.buffer.append(" IDENTITY");
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(this.formatConstraintName(column.containtName));
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
            if (!column.clustered) {
                this.buffer.append(" NONCLUSTERED");
            }
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
            if (column.clustered) {
                this.buffer.append(" CLUSTERED");
            }
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    private void doWidthOrderBy(SqlSelect select) throws FormaterException {
        SqlTableSourceBase tableSource = select.tableSource;
        while (tableSource != null) {
            if (tableSource instanceof SqlSubQueryTableSource) {
                SqlSubQueryTableSource ts = (SqlSubQueryTableSource)tableSource;
                if (ts.alias == null) {
                    ts.alias = "KSQL_DRIVED_" + this.drivedTableAliasCount++;
                }
                SqlSelectBase subQuery = ts.subQuery;
                if (subQuery.orderBy != null) {
                    if (subQuery instanceof SqlSelect) {
                        SqlSelect subSelect = (SqlSelect)subQuery;
                        HashMap<String, String> colMap = new HashMap<String, String>();
                        for (SqlObject item : subSelect.selectList) {
                            if (item.alias == null) continue;
                            colMap.put(item.expr.toString(), item.alias);
                        }
                        for (SqlObject item : subSelect.orderBy) {
                            String alias;
                            if (((SqlOrderByItem)item).expr instanceof SqlIdentifierExpr) {
                                SqlIdentifierExpr exp = (SqlIdentifierExpr)((SqlOrderByItem)item).expr;
                                alias = (String)colMap.get(exp.toString());
                                if (alias != null) {
                                    exp.value = alias;
                                } else if (!colMap.containsKey(exp.toString()) && !colMap.containsValue(exp.toString())) {
                                    subSelect.selectList.add(new SqlSelectItem(exp, null));
                                }
                            } else if (((SqlOrderByItem)item).expr instanceof SqlBinaryOpExpr) {
                                SqlBinaryOpExpr bo = (SqlBinaryOpExpr)((SqlOrderByItem)item).expr;
                                if (bo.operator == 20) {
                                    SqlExpr right;
                                    alias = select.tableSource.alias;
                                    SqlBinaryOpExpr newBo = (SqlBinaryOpExpr)bo.clone();
                                    if (alias != null) {
                                        bo.left = new SqlIdentifierExpr(alias);
                                    }
                                    if (!colMap.containsKey((right = bo.right).toString()) && !colMap.containsKey(right)) {
                                        subSelect.selectList.add(new SqlSelectItem(newBo, right.toString()));
                                    }
                                }
                            }
                            select.orderBy.add(item);
                        }
                        subSelect.orderBy.clear();
                        tableSource = ((SqlSelect)subQuery).tableSource;
                        continue;
                    }
                    if (!(subQuery instanceof SqlUnionSelect)) continue;
                    tableSource = null;
                    continue;
                }
                tableSource = null;
                continue;
            }
            tableSource = null;
        }
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        this.doWidthOrderBy(select);
        this.buffer.append("SELECT ");
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("distinct option not support.");
        }
        if (select.limit != null) {
            this.buffer.append("TOP ").append(select.limit.rowCount).append(" ");
        }
        HashSet<String> aliasSet = new HashSet<String>();
        String ALIAS_PRIFIX = "KSQL_FX";
        int ALIAS_PRIFIX_INDEX = 0;
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            if (item.alias != null && item.alias.length() != 0) {
                this.formatExpr(item.expr);
                this.buffer.append(" ");
                String uppperAlias = this.formatAlias(item.alias);
                if (aliasSet.contains(uppperAlias)) {
                    this.buffer.append('\"').append("KSQL_FX").append(ALIAS_PRIFIX_INDEX).append('\"');
                    ++ALIAS_PRIFIX_INDEX;
                } else {
                    aliasSet.add(uppperAlias);
                    if (uppperAlias.equalsIgnoreCase("count")) {
                        this.buffer.append("\"count\"");
                    } else {
                        this.buffer.append(uppperAlias);
                    }
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.into != null) {
            this.buffer.append(" INTO ").append(this.formatTableName(select.into.new_table));
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase()).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ATN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CEILING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("COS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("EXP(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("FLOOR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" % ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOG(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("POWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIGN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SIGN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SQRT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SQRT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONVERT") == 0) {
            if (expr.parameters.size() != 2) {
                throw new FormaterException("ERROR");
            }
            if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) {
                throw new FormaterException("ERROR");
            }
            String typeName = ((SqlIdentifierExpr)expr.parameters.get((int)0)).value;
            if (typeName == null) throw new FormaterException("ERROR");
            if (typeName.length() == 0) {
                throw new FormaterException("ERROR");
            }
            if (typeName.compareToIgnoreCase("BINARY") == 0 || typeName.compareToIgnoreCase("VARBINARY") == 0 || typeName.compareToIgnoreCase("CHAR") == 0 || typeName.compareToIgnoreCase("VARCHAR") == 0 || typeName.compareToIgnoreCase("NCHAR") == 0 || typeName.compareToIgnoreCase("NVARCHAR") == 0 || typeName.compareToIgnoreCase("DATETIME") == 0 || typeName.compareToIgnoreCase("DECIMAL") == 0 || typeName.compareToIgnoreCase("INT") == 0 || typeName.compareToIgnoreCase("SMALLINT") == 0) {
                this.buffer.append("CONVERT(").append(typeName.toUpperCase()).append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("NUMBER") == 0) {
                this.buffer.append("CONVERT(NUMERIC, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("BLOB") == 0) {
                this.buffer.append("CONVERT(IMAGE, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("CLOB") == 0) {
                this.buffer.append("CONVERT(CLOB, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("NCLOB") != 0) throw new FormaterException("not support type:" + typeName);
            this.buffer.append("CONVERT(NCLOB, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CURDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CONVERT(DATETIME, CONVERT(VARCHAR(50) ,GETDATE( ), 101))");
            return;
        }
        if (methodNameI.compareTo("CURTIME") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CONVERT(VARCHAR(50) ,GETDATE( ), 108)");
            return;
        }
        if (methodNameI.compareTo("DATEDIFF") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATEDIFF(SS, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("DATEDIFF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATENAME(DW, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DATEADD") == 0 || methodNameI.compareTo("DATETIMEADD") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATEADD(SS, ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DATENAME") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATENAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFMONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(DAY, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFWEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(DW, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFYEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(DY, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("GETDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("GETDATE()");
            return;
        }
        if (methodNameI.compareTo("HOUR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(HH, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MINUTE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(MI, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(MM, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTHNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATENAME(MM, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NOW") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("GETDATE()");
            return;
        }
        if (methodNameI.compareTo("QUARTER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(QQ, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SECOND") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(SS, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("WEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATEPART(WK, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("YEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_DATE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CONVERT(DATETIME, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATEDIFF(MM, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_MONTHS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATEADD(month, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_YEARS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATEADD(year, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_DAYS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATEADD(day, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_HOURS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATEADD(hour, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_MINUTES") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATEADD(minute, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_SECONDS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATEADD(second, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASCII(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("CHARINDEX(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            StringBuilder sb = this.buffer;
            this.buffer = new StringBuilder();
            this.buffer.append("CHARINDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", SUBSTRING(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(", LEN(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")))");
            String exp = this.buffer.toString();
            this.buffer = sb;
            this.buffer.append(" CASE ").append(exp).append(" WHEN 0 THEN 0 ELSE ").append(exp).append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(" END");
            return;
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            return;
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("LEFT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATALENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DATALENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("STR_REPLACE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("RIGHT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SOUNDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            int startIndex;
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("SUBSTRING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0), false);
            this.buffer.append(", ");
            if (expr.parameters.get(1) instanceof SqlIntExpr && (startIndex = ((SqlIntExpr)expr.parameters.get((int)1)).value) < 1) {
                if (startIndex == 0) {
                    expr.parameters.set(1, new SqlIntExpr(1));
                } else if (startIndex < 0) {
                    throw new FormaterException("SUBSTRING parameter2 cannot not smaller then 1.");
                }
            }
            this.formatExpr((SqlExpr)expr.parameters.get(1), false);
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2), false);
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LTRIM(RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
            if (expr.parameters.size() == 1) {
                if (expr.parameters.get(0) instanceof SqlNullExpr) {
                    this.buffer.append("CONVERT(VARCHAR, null)");
                    return;
                }
                this.buffer.append("CONVERT(VARCHAR, ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD")) {
                this.buffer.append("CONVERT(CHAR(10), ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 23)");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD HH24:MI:SS")) {
                this.buffer.append("STR_REPLACE(CONVERT(CHAR(19), ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 23), 'T', ' ')");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            if (!expr.parameters.get(1).toString().equalsIgnoreCase("NUMBER")) throw new FormaterException("ERROR");
            if (!(expr.parameters.get(2) instanceof SqlCharExpr)) {
                if (!(expr.parameters.get(2) instanceof SqlIntExpr)) return;
                this.buffer.append("LTRIM(RTRIM(STR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 38, ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(")))");
                return;
            }
            String style = expr.parameters.get(2).toString();
            if (style.split("D").length <= 0) throw new FormaterException("TO_CHAR()'s NUMBER style not valid.");
            if (style.split("D").length >= 3) throw new FormaterException("TO_CHAR()'s NUMBER style not valid.");
            char[] integerStyle = style.split("D")[0].toCharArray();
            char[] radixStyle = style.split("D")[1].toCharArray();
            int countInteger = 0;
            for (int i = 0; i < integerStyle.length; ++i) {
                if (integerStyle[i] != '9') continue;
                ++countInteger;
            }
            int countradix = 0;
            int i = 0;
            while (true) {
                if (i >= radixStyle.length) {
                    this.buffer.append("CONVERT(VARCHAR, ");
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" AS DECIMAL(");
                    this.buffer.append(countInteger + countradix);
                    this.buffer.append(", ");
                    this.buffer.append(countradix);
                    this.buffer.append(")");
                    this.buffer.append("))");
                    return;
                }
                if (radixStyle[i] == '9') {
                    ++countradix;
                }
                ++i;
            }
        }
        if (methodNameI.compareTo("ISNULL") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ISNULL(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NULLIF") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("NULLIF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_NUMBER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CONVERT(FLOAT, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_INT") == 0 || methodNameI.compareTo("TO_INTEGER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("FLOOR(CONVERT(FLOAT, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("NEWID") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("newid()");
            return;
        }
        if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
            if (expr.parameters.size() != 1) {
                if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS NUMERIC(");
                this.buffer.append(expr.parameters.get(1));
                this.buffer.append(", ");
                this.buffer.append(expr.parameters.get(2));
                this.buffer.append("))");
                return;
            }
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                return;
            }
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS NUMERIC)");
            return;
        }
        if (methodNameI.compareTo("TO_NVARCHAR") == 0 || methodNameI.compareTo("TONVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("NEWBOSID") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("dbo.newbosid(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        this.formeatUnkownMethodInvokeExpr(expr);
    }

    @Override
    protected void formatTrancateTableStmt(SqlTrancateTableStmt stmt) throws FormaterException {
        this.buffer.append("exec dbo.truncateTable '").append(this.formatTableName(stmt.tableName)).append("'");
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        this.buffer.append("SET ");
        this.formatExpr(stmt.variant);
        this.buffer.append(" = ");
        this.formatExpr(stmt.value);
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        SqlStmt itemStmt;
        int i;
        this.buffer.append("IF ");
        this.formatExpr(stmt.condition);
        this.buffer.append("\n");
        this.buffer.append("BEGIN\n");
        StringBuilder oBuffer = this.buffer;
        this.setBuffer(new StringBuilder());
        for (i = 0; i < stmt.trueStmtList.size(); ++i) {
            if (i != 0) {
                this.buffer.append("\n");
            }
            itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
            this.formatStmt(itemStmt);
        }
        oBuffer.append("EXECUTE('").append((CharSequence)this.handleComma(this.buffer, 0)).append("')\n");
        oBuffer.append("END");
        this.buffer.setLength(0);
        if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
            oBuffer.append("\nELSE\n");
            oBuffer.append("BEGIN\n");
            this.buffer.setLength(0);
            for (i = 0; i < stmt.falseStmtList.size(); ++i) {
                if (i != 0) {
                    this.buffer.append("\n");
                }
                itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                this.formatStmt(itemStmt);
            }
            oBuffer.append("EXECUTE('").append((CharSequence)this.handleComma(this.buffer, 0)).append("')\n");
            oBuffer.append("END");
        }
        this.setBuffer(oBuffer);
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        this.buffer.append("WHILE ");
        this.formatExpr(stmt.condition);
        this.buffer.append("\n");
        this.buffer.append("BEGIN\n");
        for (int i = 0; i < stmt.stmtList.size(); ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append("\n");
        }
        this.buffer.append("END\n");
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        this.buffer.append("DEALLOCATE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        this.buffer.append("CLOSE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        this.buffer.append("OPEN ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        SqlExpr expr;
        int i;
        String curName = stmt.curName;
        if (curName != null && curName.length() > 0 && curName.charAt(0) == '@') {
            curName = curName.substring(1);
        }
        this.buffer.append("OPEN ");
        this.buffer.append(curName);
        this.buffer.append("\n");
        this.buffer.append("FETCH NEXT FROM ");
        this.buffer.append(curName);
        this.buffer.append(" INTO ");
        int size = stmt.intoList.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
        this.buffer.append("\n");
        this.buffer.append("WHILE (@@FETCH_STATUS = 0)\n");
        this.buffer.append("BEGIN\n");
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append("\n");
        }
        this.buffer.append("FETCH NEXT FROM ");
        this.buffer.append(curName);
        this.buffer.append(" INTO ");
        size = stmt.intoList.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
        this.buffer.append("\n");
        this.buffer.append("END\n");
        this.buffer.append("CLOSE ");
        this.buffer.append(curName);
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("not support format fetch statement");
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        this.buffer.append("BREAK");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        this.buffer.append("CONTINUE");
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        this.buffer.append("GOTO ");
        this.buffer.append(stmt.name);
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        this.buffer.append(stmt.name);
        this.buffer.append(":");
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        SqlBlockStmt.DeclItem item;
        int i;
        int size;
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                String name;
                item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (item instanceof SqlBlockStmt.DeclVarItem) {
                    SqlBlockStmt.DeclVarItem varItem = (SqlBlockStmt.DeclVarItem)item;
                    this.buffer.append("DECLARE ");
                    name = varItem.name;
                    this.buffer.append(name);
                    this.buffer.append(" AS ");
                    if (varItem.dataType.equalsIgnoreCase("BIGINT")) {
                        this.buffer.append("BIGINT");
                    } else if (varItem.dataType.equalsIgnoreCase("BINARY")) {
                        this.buffer.append("BINARY (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("BIT")) {
                        this.buffer.append("BIT");
                    } else if (varItem.dataType.equalsIgnoreCase("CHAR")) {
                        this.buffer.append("CHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("DATETIME")) {
                        this.buffer.append("DATETIME");
                    } else if (varItem.dataType.equalsIgnoreCase("DECIMAL")) {
                        this.buffer.append("DECIMAL (");
                        this.buffer.append(varItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(varItem.scale);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("FLOAT")) {
                        this.buffer.append("FLOAT");
                    } else if (varItem.dataType.equalsIgnoreCase("IMAGE")) {
                        this.buffer.append("IMAGE");
                    } else if (varItem.dataType.equalsIgnoreCase("INT")) {
                        this.buffer.append("INT");
                    } else if (varItem.dataType.equalsIgnoreCase("MONEY")) {
                        this.buffer.append("MONEY");
                    } else if (varItem.dataType.equalsIgnoreCase("NCHAR")) {
                        this.buffer.append("NCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NTEXT")) {
                        this.buffer.append("TEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("NUMERIC")) {
                        this.buffer.append("NUMERIC (");
                        this.buffer.append(varItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(varItem.scale);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NVARCHAR")) {
                        this.buffer.append("NVARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("REAL")) {
                        this.buffer.append("REAL");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLDATETIME")) {
                        this.buffer.append("SMALLDATETIME");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLINT")) {
                        this.buffer.append("SMALLINT");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLMONEY")) {
                        this.buffer.append("SMALLMONEY");
                    } else if (varItem.dataType.equalsIgnoreCase("SQL_VARIANT")) {
                        this.buffer.append("SQL_VARIANT");
                    } else if (varItem.dataType.equalsIgnoreCase("TEXT")) {
                        this.buffer.append("TEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("TIMESTAMP")) {
                        this.buffer.append("TIMESTAMP");
                    } else if (varItem.dataType.equalsIgnoreCase("TINYINT")) {
                        this.buffer.append("TINYINT");
                    } else if (varItem.dataType.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                        this.buffer.append("UNIQUEIDENTIFIER");
                    } else if (varItem.dataType.equalsIgnoreCase("VARCHAR")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("VARBINARY")) {
                        this.buffer.append("VARBINARY (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("BLOB")) {
                        this.buffer.append("IMAGE");
                    } else if (varItem.dataType.equalsIgnoreCase("CLOB")) {
                        this.buffer.append("TEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("NCLOB")) {
                        this.buffer.append("TEXT");
                    } else {
                        this.buffer.append(varItem.dataType);
                    }
                    if (varItem.defaultValueExpr != null) {
                        this.buffer.append("\nSET ");
                        this.buffer.append(varItem.name);
                        this.buffer.append(" = ");
                        this.formatExpr(varItem.defaultValueExpr);
                    }
                } else if (item instanceof SqlBlockStmt.DeclCurItem) {
                    SqlBlockStmt.DeclCurItem curItem = (SqlBlockStmt.DeclCurItem)item;
                    this.buffer.append("DECLARE ");
                    name = curItem.name;
                    if (name != null && name.length() > 0 && name.charAt(0) == '@') {
                        name = name.substring(1);
                        this.buffer.append(name);
                    } else {
                        this.buffer.append(name);
                    }
                    this.buffer.append(" CURSOR FOR ");
                    this.formatSelectBase(curItem.select);
                    this.buffer.append("\n");
                } else {
                    throw new FormaterException("unexpected statement: '" + item + "'");
                }
                this.buffer.append("\n");
            }
            this.buffer.append("\n");
        }
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append("\n");
        }
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (!(item instanceof SqlBlockStmt.DeclCurItem)) continue;
                this.buffer.append("DEALLOCATE ");
                this.buffer.append(item.name);
                this.buffer.append("\n");
            }
        }
    }

    @Override
    protected void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ").append(this.formatTableName(stmt.tableName));
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD ");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                try {
                    this.formatTableConstraint(constraint);
                }
                catch (FormaterException ex) {
                    throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            String columnDef;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(this.formatColumnName(columnDef));
                flag = true;
            }
            iterator = dropColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("CONSTRAINT ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(this.formatColumnName(columnDef));
                flag = true;
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" MODIFY ");
            this.formatColumnDef(alterColumnDefItem.columnDef);
        } else if (stmt.item instanceof SqlAlterTableAddDefaultItem) {
            SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)stmt.item;
            this.buffer.append(" REPLACE ");
            this.buffer.append(this.formatColumnName(addDefaultItem.columnName));
            this.buffer.append(" DEFAULT ");
            this.formatExpr(addDefaultItem.value);
        } else if (stmt.item instanceof SqlAlterTableDropDefaultItem) {
            SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.item;
            this.buffer.append(" REPLACE ");
            this.buffer.append(this.formatColumnName(dropDefaultItem.columnName));
            this.buffer.append(" DEFAULT NULL");
        } else {
            throw new FormaterException("unexpect statement: '" + stmt + "'");
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("sysobjects sysobj");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("syscolumns syscol LEFT JOIN sysobjects sysobj ON syscol.id = sysobj.id");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("sysindexes sysind");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("sysindexes const_obj LEFT JOIN sysobjects table_obj ON const_obj.id = table_obj.id");
            } else {
                this.buffer.append(this.formatTableName(simpleTableSource.name));
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(this.formatAlias(simpleTableSource.alias));
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("unexpect Join Type: '" + joinedTable.joinType + "'");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(this.formatAlias(tableSource.alias));
            }
        } else {
            throw new FormaterException("unexpect tableSource: '" + tableSource + "'");
        }
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        this.isIndentity = true;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "syscol.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "syscol.cdefault";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "syscol.status";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "sysobj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "length";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
            ident = "systype.name";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "sysind.name";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "sysobj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "const_obj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "table_obj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "const_obj.status";
        } else if (ident != null) {
            ident = ident.toLowerCase();
            this.isIndentity = false;
        }
        this.buffer.append(ident);
    }

    @Override
    protected void formatValueKSQL_COL_NULLABLE(SqlBinaryOpExpr expr) {
        SqlCharExpr charExpr = (SqlCharExpr)expr.right;
        if (charExpr.text.equalsIgnoreCase("Y")) {
            this.buffer.append("8");
        } else if (charExpr.text.equalsIgnoreCase("N")) {
            this.buffer.append("0");
        } else {
            throw new NotSupportedException("unexpected expression: " + expr.toString());
        }
    }

    @Override
    protected void formatChar(SqlCharExpr expr) throws FormaterException {
        String text = expr.text;
        if (text.equalsIgnoreCase(Token.KSQL_CT_P.value)) {
            text = "1";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_F.value)) {
            text = "255";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_U.value)) {
            text = "2";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_C.value)) {
            text = "16";
        }
        if (this.context.get("like_predicate") != null && this.context.get("like_predicate").equals("1")) {
            text = text.replaceAll("\\[", "[[]");
            this.context.put("like_predicate", "0");
        }
        this.buffer.append("'");
        this.buffer.append(this.isIndentity ? text.toLowerCase() : text);
        this.buffer.append("'");
        this.isIndentity = false;
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE TABLE ");
        this.buffer.append(this.formatTableName(stmt.name));
        this.buffer.append(" (");
        Iterator iterator = stmt.columnList.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            if (size > 0) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            ++size;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
        if (size > 254) {
            this.buffer.append(" lock datapages");
        }
    }

    @Override
    protected String formatTableName(String tableName) {
        return tableName.toLowerCase();
    }

    @Override
    protected String formatConstraintName(String name) {
        return name.toLowerCase();
    }

    protected String formatAlias(String name) {
        return name.toLowerCase();
    }

    @Override
    protected String formatColumnName(String name) {
        return name.toLowerCase();
    }

    @Override
    protected String formateIndexName(String indexName) {
        return indexName.toLowerCase();
    }

    @Override
    protected String formatViewName(String name) {
        return name.toLowerCase();
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            if (expr.left.type == 4 && ((SqlIdentifierExpr)expr.left).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                this.buffer.append(" = 0)");
                return;
            }
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            if (expr.left.type == 4 && ((SqlIdentifierExpr)expr.left).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                this.buffer.append(" <> 0)");
                return;
            }
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.right.type == 5 && expr.left.type == 4 && ((SqlIdentifierExpr)expr.left).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                this.formatValueKSQL_COL_NULLABLE(expr);
                return;
            }
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 0) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.formatExpr(binaryOpLeft, false);
                } else {
                    this.formatExpr(binaryOpLeft);
                }
            } else {
                this.formatExpr(expr.left);
            }
            this.buffer.append(" + ");
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.formatExpr(binaryOpRight, false);
                } else {
                    this.formatExpr(binaryOpRight);
                }
            } else {
                this.formatExpr(expr.right);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 1) {
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                String alias = ((SqlIdentifierExpr)expr.right).value.toLowerCase();
                this.buffer.append(this.formatAlias(alias));
            } else if (expr.right instanceof SqlCharExpr) {
                String alias = ((SqlCharExpr)expr.right).text.toLowerCase();
                this.buffer.append(this.formatAlias(alias));
            } else if (expr.right instanceof SqlNCharExpr) {
                String alias = ((SqlNCharExpr)expr.right).text.toLowerCase();
                this.buffer.append(this.formatAlias(alias));
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 4: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 5: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 42: {
                this.buffer.append(" + ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: {
                this.buffer.append(" LIKE ");
                this.context.put("like_predicate", "1");
                break;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                this.context.put("like_predicate", "1");
                break;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 40: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
        }
        this.formatExpr(expr.right);
        this.context.put("like_predicate", "0");
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    public void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        boolean flag;
        Iterator iterator;
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        String tableName = this.formatTableName(insert.tableName);
        this.buffer.append(tableName);
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            iterator = insert.columnList.iterator();
            flag = false;
            boolean hasRowNum = false;
            while (iterator.hasNext()) {
                Object colItem = iterator.next();
                if (colItem instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    if (!hasRowNum) {
                        if (flag) {
                            this.buffer.append(", ");
                        }
                        this.buffer.append(this.formatColumnName(identExpr.value));
                    }
                } else if (colItem instanceof String) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(this.formatColumnName((String)colItem));
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = !hasRowNum || flag;
                hasRowNum = false;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            iterator = insert.valueList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)iterator.next();
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery, stmt);
        }
    }

    @Override
    protected final void formatExiststExpr(SqlExistsExpr expr) throws FormaterException {
        if (expr.not) {
            this.buffer.append("NOT EXISTS (");
        } else {
            this.buffer.append("EXISTS (");
        }
        this.formatSelectBase(expr.subQuery, expr);
        this.buffer.append(")");
    }

    public void formatSelectBase(SqlSelectBase select, SqlObject parent) throws FormaterException {
        if (select instanceof SqlSelect) {
            this.formatSelect((SqlSelect)select);
        } else if (select instanceof SqlUnionSelect) {
            if (parent != null) {
                this.buffer.append("SELECT * FROM (");
            }
            SqlUnionSelect unionSelect = (SqlUnionSelect)select;
            if (unionSelect.left instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.left).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.left);
                this.buffer.append(')');
            } else {
                this.formatSelectBase(unionSelect.left);
                select.subQueries.addAll(unionSelect.left.subQueries);
            }
            if (unionSelect.option == 0) {
                this.buffer.append(" UNION ");
            } else if (unionSelect.option == 1) {
                this.buffer.append(" UNION ALL ");
            } else {
                throw new FormaterException("Eorr Union Option.");
            }
            if (unionSelect.right instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.right).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.right);
                this.buffer.append(')');
            } else {
                this.formatSelectBase(unionSelect.right);
                select.subQueries.addAll(unionSelect.right.subQueries);
            }
            if (unionSelect.orderBy.size() != 0) {
                this.buffer.append(" ORDER BY ");
                boolean flag = false;
                Iterator iterator = unionSelect.orderBy.iterator();
                while (iterator.hasNext()) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                    this.formatExpr(orderByIterm.expr);
                    if (orderByIterm.mode == 0) {
                        this.buffer.append(" ASC");
                    } else {
                        this.buffer.append(" DESC");
                    }
                    flag = true;
                }
            }
            if (parent != null) {
                this.buffer.append(") ksql_union_1");
            }
        }
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SqlSelect subQuerySelect;
        int i;
        SubQueryUpdateItem queryItem;
        SqlUpdate update = stmt.update;
        boolean updateSelf = this.replaceUpdateStmt(update);
        this.buffer.append("UPDATE ");
        this.buffer.append(this.formatTableName(update.updateTable.name));
        this.buffer.append(" SET ");
        Iterator iterator = update.updateList.iterator();
        ArrayList<AbstractUpdateItem> subqueryUpdateItemList = new ArrayList<AbstractUpdateItem>();
        int count = 0;
        boolean flag = false;
        while (iterator.hasNext()) {
            AbstractUpdateItem abstract_item = (AbstractUpdateItem)iterator.next();
            if (flag) {
                this.buffer.append(", ");
            }
            if (abstract_item instanceof SqlUpdateItem) {
                SqlSelectBase qExpr;
                SqlUpdateItem item = (SqlUpdateItem)abstract_item;
                this.buffer.append(this.formatColumnName(item.name));
                this.buffer.append(" = ");
                if (item.expr instanceof QueryExpr && (qExpr = ((QueryExpr)item.expr).subQuery) instanceof SqlSelect) {
                    SqlSelect select = (SqlSelect)qExpr;
                    for (int i2 = 0; i2 < select.selectList.size(); ++i2) {
                        SqlSelectItem sItem = (SqlSelectItem)select.selectList.get(i2);
                        sItem.alias = null;
                    }
                }
                this.formatExpr(item.expr);
            } else if (abstract_item instanceof SubQueryUpdateItem) {
                queryItem = (SubQueryUpdateItem)abstract_item;
                subqueryUpdateItemList.add(abstract_item);
                for (int i3 = 0; i3 < queryItem.columnList.size(); ++i3) {
                    String column = (String)queryItem.columnList.get(i3);
                    if (i3 != 0) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(this.formatColumnName(column));
                    this.buffer.append(" = ");
                    if (!(queryItem.subQuery instanceof SqlSelect)) {
                        throw new FormaterException("unexpect subquery item: '" + queryItem.subQuery + "'");
                    }
                    SqlSelect subQuerySelect2 = (SqlSelect)queryItem.subQuery;
                    SqlSelectItem subSelectItem = (SqlSelectItem)subQuerySelect2.selectList.get(i3);
                    this.formatExpr(subSelectItem.expr, false);
                    ++count;
                    flag = true;
                }
            } else {
                throw new FormaterException("unexpect update item: '" + abstract_item + "'");
            }
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("update's tableSource is null");
        }
        for (i = 0; i < subqueryUpdateItemList.size(); ++i) {
            if (i == 0) {
                this.buffer.append(" FROM ");
                if (update.updateTable.alias != null && !updateSelf) {
                    this.buffer.append(this.formatTableName(update.updateTable.name));
                    this.buffer.append(" ").append(update.updateTable.alias.toLowerCase()).append(", ");
                }
            } else {
                this.buffer.append(", ");
            }
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (!(queryItem.subQuery instanceof SqlSelect)) {
                throw new FormaterException("unexpect queryItem subQuery: '" + queryItem + "'");
            }
            subQuerySelect = (SqlSelect)queryItem.subQuery;
            this.formatTableSource(subQuerySelect.tableSource);
        }
        flag = false;
        for (i = 0; i < subqueryUpdateItemList.size(); ++i) {
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (queryItem.subQuery instanceof SqlSelect) {
                subQuerySelect = (SqlSelect)queryItem.subQuery;
                if (subQuerySelect.condition == null) continue;
                if (flag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                }
                this.formatExpr(subQuerySelect.condition);
                flag = true;
                continue;
            }
            throw new FormaterException("not support query item:" + queryItem);
        }
        if (update.condition != null) {
            if (flag) {
                this.buffer.append(" AND ");
            } else {
                this.buffer.append(" WHERE ");
            }
            this.formatExpr(update.condition);
            flag = true;
        }
    }

    @Override
    protected void formatInSubQueryExpr(SqlInSubQueryExpr expr) throws FormaterException {
        this.formatExpr(expr.expr);
        if (expr.not) {
            this.buffer.append(" NOT IN (");
        } else {
            this.buffer.append(" IN (");
        }
        SqlSelect select = null;
        if (expr.subQuery instanceof SqlSelect) {
            select = (SqlSelect)expr.subQuery;
            SqlSelectItem item = (SqlSelectItem)select.selectList.get(0);
            item.alias = null;
            this.formatSelectBase(expr.subQuery);
            this.buffer.append(")");
        } else if (expr.subQuery instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)expr.subQuery;
            while (unionSelect.left instanceof SqlUnionSelect) {
                unionSelect = (SqlUnionSelect)unionSelect.left;
            }
            select = (SqlSelect)unionSelect.left;
            SqlSelectItem item = (SqlSelectItem)select.selectList.get(0);
            String colName = item.alias == null ? item.expr.toString() : item.alias;
            this.buffer.append("SELECT ").append(colName.toLowerCase()).append(" FROM (");
            this.formatSelectBase(expr.subQuery);
            this.buffer.append(")");
            this.buffer.append(" AS ksql_union)");
        } else {
            this.formatSelectBase(expr.subQuery);
            this.buffer.append(")");
        }
    }
}

