/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.parser;

import java.util.ArrayList;
import java.util.List;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SelectParser;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.parser.SqlStmtParser;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.parser.TokenList;
import kd.bos.util.DisCardUtil;

public class SqlBlockParser {
    private final TokenList _tokenList;

    public SqlBlockParser(String sql) throws ParserException {
        Lexer lexer = new Lexer(sql);
        this._tokenList = new TokenList(lexer);
    }

    public SqlBlockParser(TokenList tokenList) {
        this._tokenList = tokenList;
    }

    public void decl(List descList) throws ParserException {
        if (!this._tokenList.lookup(0).equals(Token.DeclareToken)) {
            return;
        }
        this._tokenList.match();
        SqlExprParser exprParser = new SqlExprParser(this._tokenList);
        while (!this._tokenList.lookup(0).equals(Token.BeginToken)) {
            if (this._tokenList.lookup((int)0).type == 2) {
                String dataType;
                SqlBlockStmt.DeclVarItem varItem = new SqlBlockStmt.DeclVarItem();
                varItem.name = this._tokenList.lookup((int)0).value;
                this._tokenList.match();
                varItem.dataType = dataType = this._tokenList.lookup((int)0).value.toUpperCase();
                this._tokenList.match();
                if (dataType.equals("INT") || dataType.equals("INTEGER")) {
                    varItem.dataType = "INT";
                    varItem.length = 4;
                } else if (dataType.equals("SMALLINT")) {
                    varItem.length = 2;
                } else if (dataType.equals("DECIMAL") || dataType.equals("NUMBER") || dataType.equals("NUMERIC")) {
                    varItem.dataType = "DECIMAL";
                    varItem.length = 9;
                    if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        this._tokenList.match();
                        varItem.precision = Integer.parseInt(this._tokenList.lookup((int)0).value);
                        this._tokenList.match(8);
                        if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                            this._tokenList.match();
                            varItem.scale = Integer.parseInt(this._tokenList.lookup((int)0).value);
                            this._tokenList.match(8);
                        }
                        this._tokenList.match(Token.CloseBraceToken);
                    }
                } else if (dataType.equals("CHAR")) {
                    this._tokenList.match(Token.OpenBraceToken);
                    varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    if (varItem.length > 254) {
                        throw new ParserException("the max lenght of the data type 'char' is 254, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                    }
                    this._tokenList.match(8);
                    this._tokenList.match(Token.CloseBraceToken);
                } else if (dataType.equals("NCHAR")) {
                    this._tokenList.match(Token.OpenBraceToken);
                    varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    if (varItem.length > 254) {
                        throw new ParserException("the max lenght of the data type 'nchar' is 254, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                    }
                    this._tokenList.match(8);
                    this._tokenList.match(Token.CloseBraceToken);
                } else if (dataType.equals("VARCHAR")) {
                    this._tokenList.match(Token.OpenBraceToken);
                    varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    if (varItem.length > 4000) {
                        throw new ParserException("the max lenght of the data type 'varchar' is 4000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                    }
                    this._tokenList.match(8);
                    this._tokenList.match(Token.CloseBraceToken);
                } else if (dataType.equals("NVARCHAR")) {
                    this._tokenList.match(Token.OpenBraceToken);
                    varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    if (varItem.length > 2000) {
                        throw new ParserException("the max lenght of the data type 'nvarchar' is 2000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                    }
                    this._tokenList.match(8);
                    this._tokenList.match(Token.CloseBraceToken);
                } else if (dataType.equals("DATETIME")) {
                    DisCardUtil.discard();
                } else if (dataType.equals("TIMESTAMP")) {
                    varItem.dataType = "DATETIME";
                } else if (dataType.equals("BINARY")) {
                    this._tokenList.match(Token.OpenBraceToken);
                    varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    if (varItem.length > 2000) {
                        throw new ParserException("the max lenght of the data type 'binary' is 2000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                    }
                    this._tokenList.match(8);
                    this._tokenList.match(Token.CloseBraceToken);
                } else if (dataType.equals("VARBINARY")) {
                    this._tokenList.match(Token.OpenBraceToken);
                    varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                    if (varItem.length > 2000) {
                        throw new ParserException("the max lenght of the data type 'varbinary' is 2000, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                    }
                    this._tokenList.match(8);
                    this._tokenList.match(Token.CloseBraceToken);
                } else if (dataType.equals("BLOG")) {
                    if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        this._tokenList.match(Token.OpenBraceToken);
                        varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                        this._tokenList.match(8);
                        this._tokenList.match(Token.CloseBraceToken);
                    }
                } else if (dataType.equals("CLOB")) {
                    if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        this._tokenList.match(Token.OpenBraceToken);
                        varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                        if (varItem.length > 0x40000000) {
                            throw new ParserException("the max lenght of the data type 'CLOB' is 1073741824, at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                        }
                        this._tokenList.match(8);
                        this._tokenList.match(Token.CloseBraceToken);
                    }
                } else if (dataType.equals("NCLOB")) {
                    if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        this._tokenList.match(Token.OpenBraceToken);
                        varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                        this._tokenList.match(8);
                        this._tokenList.match(Token.CloseBraceToken);
                    }
                } else if (dataType.equals("SMALLINT")) {
                    if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        this._tokenList.match(Token.OpenBraceToken);
                        varItem.length = 1;
                        this._tokenList.match(8);
                        this._tokenList.match(Token.CloseBraceToken);
                    }
                } else if (dataType.equals("BLOB")) {
                    if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        this._tokenList.match(Token.OpenBraceToken);
                        varItem.length = Integer.parseInt(this._tokenList.lookup((int)0).value);
                        this._tokenList.match(8);
                        this._tokenList.match(Token.CloseBraceToken);
                    }
                } else {
                    throw new ParserException("NOT SUPPORT DATA TYPE '" + dataType + "', at line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
                }
                if (this._tokenList.lookup(0).equals(Token.EqualToken)) {
                    this._tokenList.match();
                    varItem.defaultValueExpr = exprParser.expr();
                }
                this._tokenList.match(Token.SemicolonToken);
                descList.add(varItem);
                continue;
            }
            if (this._tokenList.lookup(0).equals(Token.CursorToken)) {
                this._tokenList.match();
                SqlBlockStmt.DeclCurItem curItem = new SqlBlockStmt.DeclCurItem();
                curItem.name = this._tokenList.lookup((int)0).value;
                this._tokenList.match();
                this._tokenList.match(Token.IsToken);
                SelectParser selectParser = new SelectParser(this._tokenList);
                curItem.select = selectParser.select();
                this._tokenList.match(Token.SemicolonToken);
                descList.add(curItem);
                continue;
            }
            throw new ParserException("TODO, " + this._tokenList.lookup((int)0).value);
        }
    }

    public SqlBlockStmt block() throws ParserException {
        SqlBlockStmt stmt = new SqlBlockStmt();
        if (stmt.declItemList == null) {
            stmt.declItemList = new ArrayList();
        }
        if (this._tokenList.lookup(0).equals(Token.DeclareToken)) {
            this.decl(stmt.declItemList);
        }
        this._tokenList.match(Token.BeginToken);
        if (stmt.stmtList == null) {
            stmt.stmtList = new ArrayList();
        }
        SqlStmtParser stmtParser = new SqlStmtParser(this._tokenList);
        stmtParser.stmtList(stmt.stmtList, Token.EndToken);
        this._tokenList.match(Token.EndToken);
        this._tokenList.match(Token.SemicolonToken);
        return stmt;
    }
}

