/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell;

import dm.jdbc.driver.DmdbClob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ksql.shell.KDResultSetMetaData;
import kd.bos.ksql.shell.KDResultSetUnwrapper;
import kd.bos.ksql.shell.KDStatement;
import kd.bos.ksql.shell.trace.NextDest;
import oracle.sql.CLOB;
import org.apache.log4j.Logger;

public class KDResultSet
implements ResultSet,
KDResultSetUnwrapper {
    private final boolean isOracle;
    private ResultSet rs;
    private KDStatement stmt;
    private Connection conn;
    private Map<String, Integer> bigDecimalScaleNameMap = new HashMap<String, Integer>();
    private Map<Integer, Integer> bigDecimalScaleIndexMap = new HashMap<Integer, Integer>();
    private Map<String, Integer> columnIndexMap;
    private static final Logger logger = Logger.getLogger(KDResultSet.class);
    private List<String> realColumns;

    @Deprecated
    public static final void addNextDest(NextDest dest) {
    }

    @Deprecated
    public static final void removeNextDest(NextDest dest) {
    }

    protected KDResultSet(ResultSet rs, KDStatement stmt) {
        this.isOracle = stmt.dbType == 2 || stmt.dbType == 7 || stmt.dbType == 8;
        this.rs = rs;
        this.stmt = stmt;
        this.conn = stmt.cn;
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int n = meta.getColumnCount();
            this.columnIndexMap = new HashMap<String, Integer>(n);
            for (int i = 1; i <= n; ++i) {
                int scale;
                String lname = meta.getColumnName(i).toLowerCase();
                if ("java.math.BigDecimal".equals(meta.getColumnClassName(i)) && ((scale = meta.getScale(i)) > 0 || scale == 0 && meta.getPrecision(i) == 19)) {
                    this.bigDecimalScaleNameMap.put(lname, scale);
                    this.bigDecimalScaleIndexMap.put(i, scale);
                }
                this.columnIndexMap.put(lname, i);
            }
        }
        catch (SQLException ex) {
            logger.warn((Object)ex);
        }
    }

    @Override
    public boolean absolute(int p1) throws SQLException {
        return this.rs.absolute(p1);
    }

    @Override
    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.rs.cancelRowUpdates();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.rs.close();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.rs.deleteRow();
    }

    @Override
    public int findColumn(String p1) throws SQLException {
        return this.rs.findColumn(p1);
    }

    @Override
    public boolean first() throws SQLException {
        return this.rs.first();
    }

    @Override
    public Array getArray(int p1) throws SQLException {
        return this.rs.getArray(p1);
    }

    @Override
    public Array getArray(String p1) throws SQLException {
        return this.rs.getArray(p1);
    }

    @Override
    public InputStream getAsciiStream(int p1) throws SQLException {
        return this.rs.getAsciiStream(p1);
    }

    @Override
    public InputStream getAsciiStream(String p1) throws SQLException {
        return this.rs.getAsciiStream(p1);
    }

    @Override
    public BigDecimal getBigDecimal(int p1) throws SQLException {
        Integer scale = this.bigDecimalScaleIndexMap.get(p1);
        if (scale != null) {
            return this.getBigDecimal(p1, (int)scale);
        }
        return this.rs.getBigDecimal(p1);
    }

    @Override
    public BigDecimal getBigDecimal(int p1, int p2) throws SQLException {
        BigDecimal ret = this.rs.getBigDecimal(p1);
        if (ret != null && ret.scale() != p2) {
            ret = ret.setScale(p2, 4);
        }
        return ret;
    }

    @Override
    public BigDecimal getBigDecimal(String p1) throws SQLException {
        Integer scale = this.bigDecimalScaleNameMap.get(p1);
        if (scale != null) {
            return this.getBigDecimal(p1, (int)scale);
        }
        return this.rs.getBigDecimal(p1);
    }

    @Override
    public BigDecimal getBigDecimal(String p1, int p2) throws SQLException {
        BigDecimal ret = this.rs.getBigDecimal(p1);
        if (ret != null && ret.scale() != p2) {
            ret = ret.setScale(p2, 4);
        }
        return ret;
    }

    @Override
    public InputStream getBinaryStream(int p1) throws SQLException {
        return this.rs.getBinaryStream(p1);
    }

    @Override
    public InputStream getBinaryStream(String p1) throws SQLException {
        return this.rs.getBinaryStream(p1);
    }

    @Override
    public Blob getBlob(int p1) throws SQLException {
        return this.rs.getBlob(p1);
    }

    @Override
    public Blob getBlob(String p1) throws SQLException {
        return this.rs.getBlob(p1);
    }

    @Override
    public boolean getBoolean(int p1) throws SQLException {
        return this.rs.getBoolean(p1);
    }

    @Override
    public boolean getBoolean(String p1) throws SQLException {
        return this.rs.getBoolean(p1);
    }

    @Override
    public byte getByte(int p1) throws SQLException {
        return this.rs.getByte(p1);
    }

    @Override
    public byte getByte(String p1) throws SQLException {
        return this.rs.getByte(p1);
    }

    @Override
    public byte[] getBytes(int p1) throws SQLException {
        return this.rs.getBytes(p1);
    }

    @Override
    public byte[] getBytes(String p1) throws SQLException {
        return this.rs.getBytes(p1);
    }

    @Override
    public Reader getCharacterStream(int p1) throws SQLException {
        return this.rs.getCharacterStream(p1);
    }

    @Override
    public Reader getCharacterStream(String p1) throws SQLException {
        return this.rs.getCharacterStream(p1);
    }

    @Override
    public Clob getClob(int p1) throws SQLException {
        return this.rs.getClob(p1);
    }

    @Override
    public Clob getClob(String p1) throws SQLException {
        return this.rs.getClob(p1);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rs.getConcurrency();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    @Override
    public Date getDate(int p1) throws SQLException {
        return this.rs.getDate(p1);
    }

    @Override
    public Date getDate(int p1, Calendar p2) throws SQLException {
        return this.rs.getDate(p1, p2);
    }

    @Override
    public Date getDate(String p1) throws SQLException {
        return this.rs.getDate(p1);
    }

    @Override
    public Date getDate(String p1, Calendar p2) throws SQLException {
        return this.rs.getDate(p1, p2);
    }

    @Override
    public double getDouble(int p1) throws SQLException {
        return this.rs.getDouble(p1);
    }

    @Override
    public double getDouble(String p1) throws SQLException {
        return this.rs.getDouble(p1);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    @Override
    public float getFloat(int p1) throws SQLException {
        return this.rs.getFloat(p1);
    }

    @Override
    public float getFloat(String p1) throws SQLException {
        return this.rs.getFloat(p1);
    }

    @Override
    public int getInt(int p1) throws SQLException {
        return this.rs.getInt(p1);
    }

    @Override
    public int getInt(String p1) throws SQLException {
        return this.rs.getInt(p1);
    }

    @Override
    public long getLong(int p1) throws SQLException {
        return this.rs.getLong(p1);
    }

    @Override
    public long getLong(String p1) throws SQLException {
        return this.rs.getLong(p1);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        KDResultSetMetaData ret = new KDResultSetMetaData(this.rs.getMetaData(), this.stmt.dbType);
        ret.setRealColumns(this.realColumns);
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getObject(int index) throws SQLException {
        if (!this.isOracle) {
            Object value = this.rs.getObject(index);
            if (!(value instanceof LocalDateTime)) return value;
            return this.getTimestamp(index);
        }
        ResultSetMetaData rsMeta = this.rs.getMetaData();
        int dataType = rsMeta.getColumnType(index);
        String className = rsMeta.getColumnClassName(index);
        if (dataType == 93) return this.rs.getTimestamp(index);
        if (className.equalsIgnoreCase("oracle.sql.TIMESTAMP")) {
            return this.rs.getTimestamp(index);
        }
        if (dataType == 2) return this.rs.getBigDecimal(index);
        if (dataType == 3) {
            return this.rs.getBigDecimal(index);
        }
        Object obj = this.rs.getObject(index);
        if (obj instanceof Clob) {
            return this.readOracleClob((CLOB)obj);
        }
        if (!(obj instanceof Blob)) return obj;
        Blob blob = this.rs.getBlob(index);
        try (InputStream bis = blob.getBinaryStream();){
            int size;
            int len = bis.available();
            byte[] buf = new byte[Math.min(1024, len)];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(len);
            while ((size = bis.read(buf)) != -1) {
                bos.write(buf, 0, size);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new SQLException("read blob error", e);
        }
    }

    @Override
    public Object getObject(int p1, Map<String, Class<?>> p2) throws SQLException {
        return this.rs.getObject(p1, p2);
    }

    @Override
    public Object getObject(String name) throws SQLException {
        Object value;
        ResultSetMetaData rsMeta;
        if (this.columnIndexMap != null) {
            Integer index = this.columnIndexMap.get(name);
            if (index == null) {
                index = this.columnIndexMap.get(name.toLowerCase());
            }
            if (index != null) {
                return this.getObject(index);
            }
        }
        if (this.isOracle) {
            rsMeta = this.rs.getMetaData();
            for (int i = 0; i < rsMeta.getColumnCount(); ++i) {
                if (!name.equalsIgnoreCase(rsMeta.getColumnName(i + 1))) continue;
                int columnType = rsMeta.getColumnType(i + 1);
                String className = rsMeta.getColumnClassName(i + 1);
                if (columnType != 93 && !className.equalsIgnoreCase("oracle.sql.TIMESTAMP")) continue;
                return this.rs.getTimestamp(i + 1);
            }
            return this.rs.getObject(name);
        }
        if (this.stmt.dbType == 11) {
            rsMeta = this.rs.getMetaData();
            for (int i = 0; i < rsMeta.getColumnCount(); ++i) {
                if (!name.equalsIgnoreCase(rsMeta.getColumnName(i + 1))) continue;
                int columnType = rsMeta.getColumnType(i + 1);
                String className = rsMeta.getColumnClassName(i + 1);
                if (columnType != 93 && !className.equalsIgnoreCase("dm.sql.DmdbTimestamp")) continue;
                return this.rs.getTimestamp(i + 1);
            }
        }
        if ((value = this.rs.getObject(name)) instanceof LocalDateTime) {
            return this.getTimestamp(name);
        }
        return value;
    }

    @Override
    public Object getObject(String p1, Map<String, Class<?>> p2) throws SQLException {
        return this.rs.getObject(p1, p2);
    }

    @Override
    public Ref getRef(int p1) throws SQLException {
        return this.rs.getRef(p1);
    }

    @Override
    public Ref getRef(String p1) throws SQLException {
        return this.rs.getRef(p1);
    }

    @Override
    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    @Override
    public short getShort(int p1) throws SQLException {
        return this.rs.getShort(p1);
    }

    @Override
    public short getShort(String p1) throws SQLException {
        return this.rs.getShort(p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            return this.stmt;
        }
    }

    private String readOracleClob(CLOB clob) throws SQLException {
        int len;
        Reader reader = clob.getCharacterStream();
        StringBuilder buff = new StringBuilder();
        int blockSize = 1024;
        char[] block = new char[blockSize];
        do {
            try {
                len = reader.read(block);
                if (len <= 0) continue;
                buff.append(block, 0, len);
            }
            catch (IOException e) {
                logger.warn((Object)e);
                throw new SQLException(e.getMessage());
            }
        } while (len == blockSize);
        return buff.toString();
    }

    private String readDMClob(DmdbClob clob) throws SQLException {
        int len;
        Reader reader = clob.getCharacterStream();
        StringBuilder buff = new StringBuilder();
        int blockSize = 1024;
        char[] block = new char[blockSize];
        do {
            try {
                len = reader.read(block);
                if (len <= 0) continue;
                buff.append(block, 0, len);
            }
            catch (IOException e) {
                logger.warn((Object)e);
                throw new SQLException(e.getMessage());
            }
        } while (len == blockSize);
        return buff.toString();
    }

    @Override
    public String getString(int p1) throws SQLException {
        if (this.isOracle) {
            Object obj = this.rs.getObject(p1);
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Clob) {
                return this.readOracleClob((CLOB)obj);
            }
            return this.rs.getString(p1);
        }
        return this.rs.getString(p1);
    }

    @Override
    public String getString(String p1) throws SQLException {
        if (this.isOracle) {
            Object obj = this.rs.getObject(p1);
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Clob) {
                if (obj instanceof CLOB) {
                    return this.readOracleClob((CLOB)obj);
                }
                return this.rs.getString(p1);
            }
        }
        return this.rs.getString(p1);
    }

    @Override
    public Time getTime(int p1) throws SQLException {
        return this.rs.getTime(p1);
    }

    @Override
    public Time getTime(int p1, Calendar p2) throws SQLException {
        return this.rs.getTime(p1, p2);
    }

    @Override
    public Time getTime(String p1) throws SQLException {
        return this.rs.getTime(p1);
    }

    @Override
    public Time getTime(String p1, Calendar p2) throws SQLException {
        return this.rs.getTime(p1, p2);
    }

    @Override
    public Timestamp getTimestamp(int p1) throws SQLException {
        return this.rs.getTimestamp(p1);
    }

    @Override
    public Timestamp getTimestamp(int p1, Calendar p2) throws SQLException {
        return this.rs.getTimestamp(p1, p2);
    }

    @Override
    public Timestamp getTimestamp(String p1) throws SQLException {
        return this.rs.getTimestamp(p1);
    }

    @Override
    public Timestamp getTimestamp(String p1, Calendar p2) throws SQLException {
        return this.rs.getTimestamp(p1, p2);
    }

    @Override
    public int getType() throws SQLException {
        return this.rs.getType();
    }

    @Override
    public InputStream getUnicodeStream(int p1) throws SQLException {
        return this.rs.getUnicodeStream(p1);
    }

    @Override
    public InputStream getUnicodeStream(String p1) throws SQLException {
        return this.rs.getUnicodeStream(p1);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    @Override
    public void insertRow() throws SQLException {
        this.rs.insertRow();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    @Override
    public boolean last() throws SQLException {
        return this.rs.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.rs.moveToCurrentRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.rs.moveToInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        return this.rs.next();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.rs.refreshRow();
    }

    @Override
    public boolean relative(int p1) throws SQLException {
        return this.rs.relative(p1);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rowUpdated() throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            return this.rs.rowUpdated();
        }
    }

    @Override
    public void setFetchDirection(int p1) throws SQLException {
        this.rs.setFetchDirection(p1);
    }

    @Override
    public void setFetchSize(int p1) throws SQLException {
        this.rs.setFetchSize(p1);
    }

    @Override
    public void updateAsciiStream(int p1, InputStream p2, int p3) throws SQLException {
        this.rs.updateAsciiStream(p1, p2, p3);
    }

    @Override
    public void updateAsciiStream(String p1, InputStream p2, int p3) throws SQLException {
        this.rs.updateAsciiStream(p1, p2, p3);
    }

    @Override
    public void updateBigDecimal(int p1, BigDecimal p2) throws SQLException {
        this.rs.updateBigDecimal(p1, p2);
    }

    @Override
    public void updateBigDecimal(String p1, BigDecimal p2) throws SQLException {
        this.rs.updateBigDecimal(p1, p2);
    }

    @Override
    public void updateBinaryStream(int p1, InputStream p2, int p3) throws SQLException {
        this.rs.updateBinaryStream(p1, p2, p3);
    }

    @Override
    public void updateBinaryStream(String p1, InputStream p2, int p3) throws SQLException {
        this.rs.updateBinaryStream(p1, p2, p3);
    }

    @Override
    public void updateBoolean(int p1, boolean p2) throws SQLException {
        this.rs.updateBoolean(p1, p2);
    }

    @Override
    public void updateBoolean(String p1, boolean p2) throws SQLException {
        this.rs.updateBoolean(p1, p2);
    }

    @Override
    public void updateByte(int p1, byte p2) throws SQLException {
        this.rs.updateByte(p1, p2);
    }

    @Override
    public void updateByte(String p1, byte p2) throws SQLException {
        this.rs.updateByte(p1, p2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int p1, byte[] p2) throws SQLException {
        Connection connection = this.conn;
        synchronized (connection) {
            this.rs.updateBytes(p1, p2);
        }
    }

    @Override
    public void updateBytes(String p1, byte[] p2) throws SQLException {
        this.rs.updateBytes(p1, p2);
    }

    @Override
    public void updateCharacterStream(int p1, Reader p2, int p3) throws SQLException {
        this.rs.updateCharacterStream(p1, p2, p3);
    }

    @Override
    public void updateCharacterStream(String p1, Reader p2, int p3) throws SQLException {
        this.rs.updateCharacterStream(p1, p2, p3);
    }

    @Override
    public void updateDate(int p1, Date p2) throws SQLException {
        this.rs.updateDate(p1, p2);
    }

    @Override
    public void updateDate(String p1, Date p2) throws SQLException {
        this.rs.updateDate(p1, p2);
    }

    @Override
    public void updateDouble(int p1, double p2) throws SQLException {
        this.rs.updateDouble(p1, p2);
    }

    @Override
    public void updateDouble(String p1, double p2) throws SQLException {
        this.rs.updateDouble(p1, p2);
    }

    @Override
    public void updateFloat(int p1, float p2) throws SQLException {
        this.rs.updateFloat(p1, p2);
    }

    @Override
    public void updateFloat(String p1, float p2) throws SQLException {
        this.rs.updateFloat(p1, p2);
    }

    @Override
    public void updateInt(int p1, int p2) throws SQLException {
        this.rs.updateInt(p1, p2);
    }

    @Override
    public void updateInt(String p1, int p2) throws SQLException {
        this.rs.updateInt(p1, p2);
    }

    @Override
    public void updateLong(int p1, long p2) throws SQLException {
        this.rs.updateLong(p1, p2);
    }

    @Override
    public void updateLong(String p1, long p2) throws SQLException {
        this.rs.updateLong(p1, p2);
    }

    @Override
    public void updateNull(int p1) throws SQLException {
        this.rs.updateNull(p1);
    }

    @Override
    public void updateNull(String p1) throws SQLException {
        this.rs.updateNull(p1);
    }

    @Override
    public void updateObject(int p1, Object p2) throws SQLException {
        this.rs.updateObject(p1, p2);
    }

    @Override
    public void updateObject(int p1, Object p2, int p3) throws SQLException {
        this.rs.updateObject(p1, p2, p3);
    }

    @Override
    public void updateObject(String p1, Object p2) throws SQLException {
        this.rs.updateObject(p1, p2);
    }

    @Override
    public void updateObject(String p1, Object p2, int p3) throws SQLException {
        this.rs.updateObject(p1, p2, p3);
    }

    @Override
    public void updateRow() throws SQLException {
        this.rs.updateRow();
    }

    @Override
    public void updateShort(int p1, short p2) throws SQLException {
        this.rs.updateShort(p1, p2);
    }

    @Override
    public void updateShort(String p1, short p2) throws SQLException {
        this.rs.updateShort(p1, p2);
    }

    @Override
    public void updateString(int p1, String p2) throws SQLException {
        this.rs.updateString(p1, p2);
    }

    @Override
    public void updateString(String p1, String p2) throws SQLException {
        this.rs.updateString(p1, p2);
    }

    @Override
    public void updateTime(int p1, Time p2) throws SQLException {
        this.rs.updateTime(p1, p2);
    }

    @Override
    public void updateTime(String p1, Time p2) throws SQLException {
        this.rs.updateTime(p1, p2);
    }

    @Override
    public void updateTimestamp(int p1, Timestamp p2) throws SQLException {
        this.rs.updateTimestamp(p1, p2);
    }

    @Override
    public void updateTimestamp(String p1, Timestamp p2) throws SQLException {
        this.rs.updateTimestamp(p1, p2);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return null;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.rs)) {
            return (T)this.rs;
        }
        if (this.rs != null) {
            return this.rs.unwrap(iface);
        }
        throw new SQLException("Wrapped ResultSet is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + " wrapping " + this.rs;
    }

    @Override
    public KDResultSet get() {
        return this;
    }

    public ResultSet getInternalResultSet() {
        return this.rs;
    }

    public void setRealColumns(List<String> realColumns) {
        this.realColumns = realColumns;
    }
}

