/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell;

public class KSQLLogOption
implements AutoCloseable {
    private static final ThreadLocal<KSQLLogOption> KSQL_LOG_OPTION_THREAD_LOCAL = new ThreadLocal();
    private static final KSQLLogOption DEFAULT = new KSQLLogOption(true);
    private final boolean logStatementExecuteError;
    private final KSQLLogOption parent;

    private KSQLLogOption(boolean logStatementExecuteError) {
        this.logStatementExecuteError = logStatementExecuteError;
        this.parent = KSQL_LOG_OPTION_THREAD_LOCAL.get();
    }

    @Override
    public void close() {
        KSQL_LOG_OPTION_THREAD_LOCAL.remove();
        if (this.parent != null) {
            this.parent.setCurrent();
        }
    }

    public boolean isLogStatementExecuteError() {
        return this.logStatementExecuteError;
    }

    private void setCurrent() {
        KSQL_LOG_OPTION_THREAD_LOCAL.set(this);
    }

    public static KSQLLogOption create(boolean logStatementExecuteError) {
        KSQLLogOption current = new KSQLLogOption(logStatementExecuteError);
        current.setCurrent();
        return current;
    }

    public static KSQLLogOption getOption() {
        KSQLLogOption op = KSQL_LOG_OPTION_THREAD_LOCAL.get();
        if (op == null) {
            return DEFAULT;
        }
        return op;
    }
}

