/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.util;

import java.util.ArrayList;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.SelectParser;
import kd.bos.ksql.util.IReservedWord;
import kd.bos.ksql.util.OracleReservedWord;
import kd.bos.ksql.util.ReservedWordInfo;
import kd.bos.ksql.util.Sql2003ReservedWord;
import kd.bos.ksql.util.Sql92ReservedWord;
import kd.bos.ksql.util.Sql99ReservedWord;
import org.apache.log4j.Logger;

public class ReservedWordUtil {
    private static final Logger logger = Logger.getLogger(ReservedWordUtil.class);

    public static ReservedWordInfo[] check(String sql) throws ParserException {
        ArrayList alias = new ArrayList();
        SelectParser parser = new SelectParser(sql);
        SqlSelectBase selectBase = parser.select();
        ReservedWordUtil.check_selectbase(selectBase, alias);
        int size = alias.size();
        ReservedWordInfo[] infos = new ReservedWordInfo[size];
        for (int i = 0; i < size; ++i) {
            infos[i] = (ReservedWordInfo)alias.get(i);
        }
        return infos;
    }

    public static ReservedWordInfo isReservedWord(String word) {
        ReservedWordInfo reservedWord = null;
        IReservedWord[] ichecks = new IReservedWord[]{new Sql92ReservedWord(), new Sql99ReservedWord(), new Sql2003ReservedWord(), new OracleReservedWord()};
        for (int i = 0; i < ichecks.length && reservedWord == null; ++i) {
            reservedWord = ichecks[i].isReservedWord(word);
        }
        return reservedWord;
    }

    private static void check_selectbase(SqlSelectBase selectBase, ArrayList alias) throws ParserException {
        if (selectBase instanceof SqlSelect) {
            ReservedWordUtil.check((SqlSelect)selectBase, alias);
        } else if (selectBase instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)selectBase;
            ReservedWordUtil.check_selectbase(unionSelect.left, alias);
            ReservedWordUtil.check_selectbase(unionSelect.right, alias);
        }
    }

    private static void check(SqlSelect select, ArrayList alias) {
        try {
            ReservedWordUtil.check_table_source(select.tableSource, alias);
        }
        catch (ParserException e) {
            logger.warn((Object)e.getMessage());
        }
        for (SqlSelectItem selectItem : select.selectList) {
            ReservedWordInfo reservedWordInfo = ReservedWordUtil.isReservedWord(selectItem.expr.toString());
            if (reservedWordInfo != null) {
                alias.add(reservedWordInfo);
                logger.debug((Object)("put expr: [" + reservedWordInfo.getReservedWord() + "," + reservedWordInfo.getStandard() + "]"));
            }
            if ((reservedWordInfo = ReservedWordUtil.isReservedWord(selectItem.alias)) == null) continue;
            alias.add(reservedWordInfo);
            logger.debug((Object)("put expr: [" + reservedWordInfo.getReservedWord() + "," + reservedWordInfo.getStandard() + "]"));
        }
    }

    private static void check_table_source(SqlTableSourceBase tableSource, ArrayList alias) throws ParserException {
        if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinTabSrc = (SqlJoinedTableSource)tableSource;
            ReservedWordUtil.check_table_source(joinTabSrc.left, alias);
            ReservedWordUtil.check_table_source(joinTabSrc.right, alias);
        }
        if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource queryTabSrc = (SqlSubQueryTableSource)tableSource;
            ReservedWordUtil.check_selectbase(queryTabSrc.subQuery, alias);
        }
    }
}

