/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bundle;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.lang.Lang;

public final class Resources {
    private static final ResourceBundle NONEXISTENT_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        public String toString() {
            return "NONEXISTENT_BUNDLE";
        }
    };
    private static final Map<String, ResourceBundle> bundleMap = new ConcurrentHashMap<String, ResourceBundle>();

    @Deprecated
    public static String getString(String project, String key, Object ... args) {
        return Resources.getString(Lang.get().getLocale(), project, key, null, args);
    }

    public static String get(String project, String key, String desc, Object ... args) {
        return Resources.get(Lang.get().getLocale(), project, key, desc, args);
    }

    @Deprecated
    public static String getString(Locale locale, String project, String key, String desc, Object ... args) {
        return Resources.get(locale, project, key, desc, args);
    }

    public static String get(Locale locale, String project, String key, String desc, Object ... args) {
        String resource = project + '_' + locale.toString();
        ResourceBundle bundle = bundleMap.get(resource);
        if (bundle == null) {
            bundle = bundleMap.computeIfAbsent(resource, k -> {
                try {
                    return ResourceBundle.getBundle("resources/" + project, locale);
                }
                catch (MissingResourceException e) {
                    return NONEXISTENT_BUNDLE;
                }
            });
        }
        if (bundle == NONEXISTENT_BUNDLE) {
            if (desc == null) {
                return Resources.missBundle(key);
            }
            return Resources.format(Resources.missBundle(desc), args);
        }
        String s = null;
        try {
            s = bundle.getString(key);
            return Resources.format(new String(s.getBytes("ISO8859-1"), "UTF-8"), args);
        }
        catch (UnsupportedEncodingException e) {
            return Resources.format(s, args);
        }
        catch (MissingResourceException e) {
            if (desc == null) {
                return Resources.missBundleKey(key);
            }
            return Resources.format(Resources.missBundleKey(desc), args);
        }
    }

    public static String format(String s, Object ... args) {
        if (args != null && args.length > 0) {
            try {
                if (s.contains("%s")) {
                    return String.format(s, args);
                }
                return MessageFormat.format(s, args);
            }
            catch (Exception e) {
                return s + ':' + Arrays.toString(args);
            }
        }
        return s;
    }

    public static String missBundle(String key) {
        return Boolean.getBoolean("lang.miss.mark") ? "!" + key : key;
    }

    public static String missBundleKey(String key) {
        return Boolean.getBoolean("lang.miss.mark") ? "!!" + key : key;
    }
}

