/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.aes;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.aes.AESEncrypter;
import kd.bos.encrypt.key.EncryptKeyFactory;
import kd.bos.util.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class AESEncrypterImpl
implements AESEncrypter {
    private static final Object LOCKER = new Object();
    private static final Object LOCKER2 = new Object();
    private static final String KEY_ALGORITHM = "AES";
    private static final String AES_DEFAULT_LENGTH = "128";
    private static final String AES_KEY_LENGTH = "kd.bos.encrypt.keyLength";
    private static final String AES_CIPHER_ALGORITHM = "kd.bos.encrypt.aesAlgorithm";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES";
    private Cipher cipher = null;
    private SecretKeySpec keyFromCache = null;
    private IvParameterSpec ivBytesFromCache;
    private SecureRandom secureRandom = new SecureRandom();
    private String aesCipherAlgorithm = "AES";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cipher getCipherInstance() {
        if (this.cipher == null) {
            Object object = LOCKER;
            synchronized (object) {
                if (this.cipher == null) {
                    this.initCipher();
                }
            }
        }
        return this.cipher;
    }

    private void initCipher() {
        boolean isZkReaded;
        boolean bl = isZkReaded = StringUtils.isNotEmpty(System.getProperty("kd.bos.encrypt.encryptKey")) || StringUtils.isNotEmpty(System.getProperty("redis.serversForSession"));
        if (isZkReaded) {
            try {
                this.aesCipherAlgorithm = System.getProperty(AES_CIPHER_ALGORITHM, "AES");
                this.cipher = Cipher.getInstance(this.aesCipherAlgorithm);
            }
            catch (Exception ex) {
                throw new EncryptException("Failed to create AESEncrypt because the cipher initialization is failed, reason:", ex);
            }
        } else {
            throw new EncryptException("cannot init AESEncrypt, because the AES_KEY[MC-Key:kd.bos.encrypt.encryptKey]from zookeeper) is still null.");
        }
    }

    private SecretKeySpec getAesKey() {
        if (this.keyFromCache != null) {
            return this.keyFromCache;
        }
        String aesKey = EncryptKeyFactory.getEncrypterKeyManager().getEncryptKey();
        String aesKeyLengthFromZK = System.getProperty(AES_KEY_LENGTH, AES_DEFAULT_LENGTH);
        int aesKeyLength = Integer.parseInt(aesKeyLengthFromZK);
        if (StringUtils.isNotEmpty(aesKey)) {
            SecretKeySpec key;
            this.keyFromCache = key = this.getAESKeyFromString(aesKey, aesKeyLength);
            String ivFromZK = EncryptKeyFactory.getEncrypterKeyManager().getEncryptIvKey();
            this.ivBytesFromCache = this.getAESIvFromString(ivFromZK);
            return key;
        }
        throw new EncryptException("get encrypt key failed(encrypt key cannot be empty)");
    }

    @Override
    public String encrypt(String originalStr) throws EncryptException {
        try {
            SecretKeySpec key = this.getAesKey();
            IvParameterSpec iv = this.ivBytesFromCache;
            return this.encrypt(originalStr, key, iv);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String decrypt(String encryptStr) throws EncryptException {
        try {
            SecretKeySpec key = this.getAesKey();
            IvParameterSpec iv = this.ivBytesFromCache;
            return this.decrypt(encryptStr, key, iv);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String encrypt(String originalStr, String aesKey, int length) throws EncryptException {
        try {
            SecretKeySpec key = this.getAESKeyFromString(aesKey, length);
            IvParameterSpec iv = this.getAESIvFromString(aesKey);
            return this.encrypt(originalStr, key, iv);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String decrypt(String encryptStr, String aesKey, int length) throws EncryptException {
        try {
            SecretKeySpec key = this.getAESKeyFromString(aesKey, length);
            IvParameterSpec iv = this.getAESIvFromString(aesKey);
            return this.decrypt(encryptStr, key, iv);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecretKeySpec getAESKeyFromBuiltinResource(int length) {
        try (InputStream in = this.getClass().getResourceAsStream("/kd/bos/aes/aeskey.txt");){
            SecretKeySpec key;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String str = br.readLine();
            SecretKeySpec secretKeySpec = key = this.getAESKeyFromString(str, length);
            return secretKeySpec;
        }
        catch (IOException e) {
            throw new EncryptException(e);
        }
    }

    private SecretKeySpec getAESKeyFromString(String str, int length) throws EncryptException {
        if (str == null || str.length() < length / 8) {
            throw new EncryptException("The given AES key is too short.");
        }
        try {
            byte[] keyBytes = str.substring(0, length / 8).getBytes(Charsets.UTF_8);
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            return key;
        }
        catch (Exception ex) {
            throw new EncryptException("An error has occurred when getting AES key:" + ex.getMessage(), ex);
        }
    }

    private IvParameterSpec getAESIvFromString(String str) throws EncryptException {
        if (str == null || str.length() < 16) {
            throw new EncryptException("The given AES IvKey is too short.");
        }
        try {
            return new IvParameterSpec(str.getBytes(Charsets.UTF_8), 0, 16);
        }
        catch (Exception ex) {
            throw new EncryptException("An error has occurred when getting AES IvKey:" + ex.getMessage(), ex);
        }
    }

    private void cipherInit(int mode, Key aesKey, IvParameterSpec iv) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (this.getCipherInstance() == null) {
            throw new EncryptException("Failed to create encrypt because the cipher initialization is failed");
        }
        if (this.aesCipherAlgorithm.equals("AES") || this.aesCipherAlgorithm.startsWith("AES/ECB")) {
            this.getCipherInstance().init(mode, aesKey, this.secureRandom);
        } else {
            this.getCipherInstance().init(mode, aesKey, iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encrypt(String originalStr, SecretKeySpec aesKey, IvParameterSpec iv) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        byte[] bytes;
        if (originalStr == null) {
            return null;
        }
        Object object = LOCKER2;
        synchronized (object) {
            this.cipherInit(1, aesKey, iv);
            bytes = this.getCipherInstance().doFinal(originalStr.getBytes(Charsets.UTF_8));
        }
        BASE64Encoder encoder = new BASE64Encoder();
        String str = encoder.encode(bytes);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decrypt(String encryptStr, Key aesKey, IvParameterSpec iv) throws InvalidKeyException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        byte[] result;
        if (encryptStr == null) {
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] bytes = decoder.decodeBuffer(encryptStr);
        Object object = LOCKER2;
        synchronized (object) {
            this.cipherInit(2, aesKey, iv);
            result = this.getCipherInstance().doFinal(bytes);
        }
        return new String(result);
    }
}

