/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.impl;

import java.security.PrivateKey;
import java.security.PublicKey;
import kd.bos.encrypt.core.PrefixMatchableEncrypter;
import kd.bos.encrypt.impl.RSAEncrypterUtil;

public class RSAKeyEncrypter
extends PrefixMatchableEncrypter {
    private String publicKeyString = null;
    private String privateKeyString = null;
    private String module = null;
    private String privateExponent = null;
    private String publicExponent = null;
    private boolean isPrivate;

    public RSAKeyEncrypter() {
        super("p@p$r:");
    }

    public RSAKeyEncrypter(String prefix, String key, Boolean isPrivate) {
        super(prefix);
        this.isPrivate = isPrivate;
        if (isPrivate.booleanValue()) {
            this.privateKeyString = key;
        } else {
            this.publicKeyString = key;
        }
    }

    public RSAKeyEncrypter(String prefix, String moduleStr, String exponent, Boolean isPrivate) {
        super(prefix);
        this.isPrivate = isPrivate;
        this.module = moduleStr;
        if (isPrivate.booleanValue()) {
            this.privateExponent = exponent;
        } else {
            this.publicExponent = exponent;
        }
    }

    private PrivateKey preparePrivateKey() throws Exception {
        if (this.module != null) {
            return RSAEncrypterUtil.getPrivateKey(this.module, this.privateExponent);
        }
        return RSAEncrypterUtil.getPrivateKey(this.privateKeyString);
    }

    private PublicKey preparePublicKey() throws Exception {
        if (this.module != null) {
            return RSAEncrypterUtil.getPublicKey(this.module, this.publicExponent);
        }
        return RSAEncrypterUtil.getPublicKey(this.publicKeyString);
    }

    @Override
    protected String decode0(String str) {
        try {
            if (this.isPrivate) {
                PrivateKey key = this.preparePrivateKey();
                return RSAEncrypterUtil.decrypt(str, key);
            }
            PublicKey key = this.preparePublicKey();
            return RSAEncrypterUtil.decrypt(str, key);
        }
        catch (Exception ex) {
            throw new RuntimeException("RSA encrypt error,", ex);
        }
    }

    @Override
    protected String encode0(String str) {
        try {
            if (this.isPrivate) {
                PrivateKey key = this.preparePrivateKey();
                return RSAEncrypterUtil.encrypt(str, key);
            }
            PublicKey key = this.preparePublicKey();
            return RSAEncrypterUtil.encrypt(str, key);
        }
        catch (Exception ex) {
            throw new RuntimeException("RSA encrypt error,", ex);
        }
    }

    @Override
    protected boolean checkEncrypt(String str) {
        return true;
    }
}

