/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.instance;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.util.SystemProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppStore {
    public static final String APPSTORE_URL = "APPSTORE_URL";
    public static final String LIBSNAMEPATHMAP_KEY = "libs.name.pathmapping";
    private static final String LOADAPPIDFROMAPPSTORE = "loadappidfromappstore";

    public static Set<String> getConfiggedAppidsInAppStore() {
        HashSet<String> configAppidSet = new HashSet<String>(4);
        String appstore_url = System.getenv(APPSTORE_URL);
        if (appstore_url == null || "false".equals(SystemProperties.getWithEnv(LOADAPPIDFROMAPPSTORE))) {
            return configAppidSet;
        }
        Map<String, String> libsNamePathMap = AppStore.getDefaultlibsNamePathMap();
        String libsNamePathMapStr = System.getenv(LIBSNAMEPATHMAP_KEY);
        if (libsNamePathMapStr != null) {
            String[] libsNamePathStrs;
            for (String libsNamePathStr : libsNamePathStrs = libsNamePathMapStr.split(",")) {
                String[] libsNamePathPair = libsNamePathStr.split("=");
                if (libsNamePathPair.length != 2) continue;
                libsNamePathMap.put(libsNamePathPair[0], libsNamePathPair[1]);
            }
        }
        libsNamePathMap.forEach((libsName, subPath) -> {
            String libs = System.getenv(libsName);
            if (libs != null) {
                String appstoreUrl = appstore_url;
                if (!appstoreUrl.endsWith("/")) {
                    appstoreUrl = appstore_url + "/";
                }
                for (String lib : libs.split(",")) {
                    if (!lib.endsWith(".xml")) continue;
                    String xmlUrl = appstoreUrl + subPath + "/" + lib;
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        URL url = new URL(xmlUrl);
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setConnectTimeout(3000);
                        connection.setReadTimeout(5000);
                        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                        try (InputStream inputStream = connection.getInputStream();){
                            NodeList list;
                            Document document = null;
                            document = builder.parse(inputStream);
                            Element root = (Element)document.getElementsByTagName("root").item(0);
                            if (root == null || (list = root.getElementsByTagName("appIds")) == null) continue;
                            for (int i = 0; i < list.getLength(); ++i) {
                                Element ele = (Element)list.item(i);
                                String configAppids = ele.getFirstChild().getNodeValue();
                                if (configAppids == null) continue;
                                for (String appid : configAppids.split(",")) {
                                    configAppidSet.add(appid);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.flush();
                        System.setProperty("getConfiggedAppidsInAppStoreError", sw.toString());
                        if (SystemProperties.getWithEnv("appIds") != null || !Boolean.parseBoolean(SystemProperties.getWithEnv("appSplit"))) continue;
                        System.exit(1);
                    }
                }
            }
        });
        if (!configAppidSet.isEmpty()) {
            System.setProperty("appIdsFromAppStore", configAppidSet.stream().collect(Collectors.joining(",")));
        }
        return configAppidSet;
    }

    private static Map<String, String> getDefaultlibsNamePathMap() {
        HashMap<String, String> libsNamePathMap = new HashMap<String, String>(4);
        libsNamePathMap.put("BIZLIBS", "biz");
        libsNamePathMap.put("BOSLIBS", "bos");
        libsNamePathMap.put("TRDLIBS", "trd");
        return libsNamePathMap;
    }
}

