/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.instance;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bundle.Resources;
import kd.bos.instance.AppStore;
import kd.bos.util.SystemProperties;

public class Instance {
    public static final String KEY_CLUSTERNAME = "clusterName";
    public static final String KEY_DATACENTERNAME = "dataCenterName";
    public static final String KEY_APPNAME = "appName";
    public static final String KEY_CONFIGAPPNAME = "configAppName";
    public static final String KEY_APPSPLIT = "appSplit";
    public static final String KEY_WEBMSERVICEINONE = "webmserviceinone";
    public static final String KEY_LIGHTWEIGHTDEPLOY = "lightweightdeploy";
    public static final String KEY_APPIDS = "appIds";
    public static final String KEY_DEPLOYEDAPPIDS = "deployedAppIds";
    public static final String KEY_INNERAPPIDS = "innerAppIds";
    public static final String KEY_HASBOSINNERAPPIDS = "defalutBosInnerAppId.enable";
    public static final String KEY_CUSTOMAPPIDS = "customAppIds";
    public static final String KEY_REGISTEDAPPIDS = "registedAppIds";
    public static final String KEY_DEBUG_APP_NAME = "debug";
    private static String clusterName;
    private static String appName;
    private static String[] configAppNames;
    private static boolean appSplit;
    private static boolean webMserviceInOne;
    private static boolean lightWeightDeploy;
    private static String[] appIds;
    private static String[] deployedAppIds;
    private static String[] innerAppIds;
    private static String instanceId;
    private static boolean debugInstance;
    private static boolean pausedServiceByMonitor;

    public static String getClusterName() {
        return clusterName;
    }

    @Deprecated
    public static String getDataCenterName() {
        throw new UnsupportedOperationException(Resources.getString("bos-util", "Instance_0", null));
    }

    private static String[] initDeployedAppIds() {
        String str = SystemProperties.getWithEnv(KEY_DEPLOYEDAPPIDS);
        if (str != null) {
            return Instance.parseAppIds(str);
        }
        return null;
    }

    private static String[] initInnerAppIds() {
        if ("false".equals(SystemProperties.getWithEnv(KEY_HASBOSINNERAPPIDS))) {
            String str = SystemProperties.getWithEnv(KEY_INNERAPPIDS);
            if (str != null) {
                return Instance.parseAppIds(str);
            }
            return null;
        }
        String str = SystemProperties.getWithEnv(KEY_INNERAPPIDS);
        HashSet<Object> set = str != null ? new HashSet<String>(Arrays.asList(Instance.parseAppIds(str))) : new HashSet<String>(1);
        set.add("bos");
        return set.toArray(new String[0]);
    }

    private static String[] initAppIds() {
        Set<String> appidSet;
        try {
            appidSet = AppStore.getConfiggedAppidsInAppStore();
        }
        catch (Throwable e) {
            appidSet = new HashSet<String>();
        }
        String str = SystemProperties.getWithEnv(KEY_APPIDS);
        if (str != null) {
            String[] ids;
            for (String id : ids = Instance.parseAppIds(str)) {
                appidSet.add(id);
            }
        }
        if (appidSet.isEmpty()) {
            return null;
        }
        return appidSet.toArray(new String[0]);
    }

    public static String[] parseAppIds(String str) {
        if (str == null) {
            return null;
        }
        return str.split(",|;");
    }

    public static String getAppName() {
        return appName;
    }

    public static String[] getConfigAppName() {
        return configAppNames;
    }

    public static String getInstanceId() {
        return instanceId;
    }

    public static String[] getAppIds() {
        return appIds;
    }

    public static String[] getDeployedAppIds() {
        return deployedAppIds;
    }

    public static String[] getInnerAppIds() {
        return innerAppIds;
    }

    public static boolean isAppSplit() {
        return appSplit;
    }

    public static boolean isWebMserviceInOne() {
        return webMserviceInOne;
    }

    public static boolean isLightWeightDeploy() {
        return lightWeightDeploy;
    }

    private static String createInstanceId(String appName) {
        return appName + "-" + new SecureRandom().nextInt(9) + System.currentTimeMillis() % 1000000000L;
    }

    public static boolean isPausedServiceByMonitor() {
        return pausedServiceByMonitor;
    }

    public static boolean isDebugInstance() {
        return debugInstance;
    }

    static {
        debugInstance = false;
        clusterName = SystemProperties.getWithEnv(KEY_CLUSTERNAME);
        if (clusterName == null) {
            throw new Error("clusterName not configured.");
        }
        appName = SystemProperties.getWithEnv(KEY_APPNAME);
        if (appName == null) {
            throw new Error("appName not configured.");
        }
        String configAppName = SystemProperties.getWithEnv(KEY_CONFIGAPPNAME);
        if (configAppName == null) {
            configAppName = appName;
        }
        configAppNames = configAppName.split(",");
        appSplit = Boolean.parseBoolean(SystemProperties.getWithEnv(KEY_APPSPLIT));
        webMserviceInOne = Boolean.parseBoolean(SystemProperties.getWithEnv(KEY_WEBMSERVICEINONE));
        lightWeightDeploy = Boolean.parseBoolean(SystemProperties.getWithEnv(KEY_LIGHTWEIGHTDEPLOY));
        appIds = Instance.initAppIds();
        deployedAppIds = Instance.initDeployedAppIds();
        innerAppIds = Instance.initInnerAppIds();
        instanceId = Instance.createInstanceId(appName);
        if (appIds != null && appIds.length > 0) {
            for (String id : appIds) {
                if (!KEY_DEBUG_APP_NAME.equals(id)) continue;
                debugInstance = true;
                break;
            }
        }
        if (!debugInstance && innerAppIds != null && innerAppIds.length > 0) {
            ArrayList<String> appIds = new ArrayList<String>(innerAppIds.length);
            for (String id : innerAppIds) {
                if (KEY_DEBUG_APP_NAME.equals(id)) continue;
                appIds.add(id);
            }
            if (appIds.size() != innerAppIds.length) {
                innerAppIds = appIds.toArray(new String[appIds.size()]);
            }
        }
        pausedServiceByMonitor = false;
    }
}

