/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.lang;

import com.alibaba.fastjson.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STConverter {
    private static final Logger log = LoggerFactory.getLogger(STConverter.class);
    public static final String BOS_SC2TC_DICT = "bos.sc2tc.dict";
    public static final int CHAR = 0;
    public static final int WORD = 1;
    public static final int TEXT = 2;
    private static final STConverter s2t = new STConverter();
    private static final STConverter t2s = new STConverter();
    Hashtable<String, String> basic = new Hashtable();
    HashMap<Integer, Object> tree = new HashMap();

    public static void sc2tc(InputStream in, OutputStream out2) throws IOException {
        STConverter.sc2tc(new InputStreamReader(in), new PrintWriter(out2, true));
    }

    public static void sc2tc(Reader in, PrintWriter out2) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(in);
        while ((line = r.readLine()) != null) {
            out2.println(STConverter.sc2tc(line));
        }
    }

    public static String sc2tc(String text) {
        return STConverter.sc2tc(text, 2);
    }

    public static String sc2tc(String text, int level) {
        return s2t.convert(text, level);
    }

    public static void tc2sc(InputStream in, OutputStream out2) throws IOException {
        STConverter.tc2sc(new InputStreamReader(in), new PrintWriter(out2, true));
    }

    public static void tc2sc(Reader in, PrintWriter out2) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(in);
        while ((line = r.readLine()) != null) {
            out2.println(STConverter.tc2sc(line));
        }
    }

    public static String tc2sc(String text) {
        return STConverter.tc2sc(text, 2);
    }

    public static String tc2sc(String text, int level) {
        return t2s.convert(text, level);
    }

    public static void appendDictionary(String sc, String tc) {
        s2t.add(sc, tc);
        t2s.add(tc, sc);
    }

    private static String readString(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = STConverter.readChar(in)) == -1) {
                return null;
            }
            if (c == 10 || c == 32) break;
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    private static int readChar(InputStream in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        if (b1 == -1 || b2 == -1) {
            return -1;
        }
        return b1 | b2 << 8;
    }

    private STConverter() {
    }

    private void add(String s1, String s2) {
        HashMap<Integer, Object> cur = this.tree;
        this.basic.put(s1, s2);
        for (int i = 0; i < s1.length(); ++i) {
            Integer c = s1.charAt(i);
            HashMap<Integer, Object> map = (HashMap<Integer, Object>)cur.get(c);
            if (map == null) {
                map = new HashMap<Integer, Object>();
                cur.put(c, map);
            }
            cur = map;
        }
        cur.put(null, s2);
    }

    private String convert(String s, int level) {
        switch (level) {
            case 0: {
                return this.convertChar(s);
            }
            case 1: {
                return this.convertWord(s);
            }
        }
        return this.convertText(s);
    }

    private String convertChar(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            String r = this.basic.get(c);
            if (r == null) {
                sb.append(c);
                continue;
            }
            sb.append(r);
        }
        return sb.toString();
    }

    private String convertWord(String s) {
        String r = this.basic.get(s);
        if (r == null) {
            return this.convertChar(s);
        }
        return r;
    }

    private String convertText(String s) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < s.length()) {
            index = this.matchText(s, index, sb);
        }
        return sb.toString();
    }

    private int matchText(String s, int start, StringBuffer sb) {
        Integer c;
        HashMap map;
        HashMap cur = this.tree;
        int lastMatch = start;
        String match = null;
        for (int i = start; i < s.length() && (map = (HashMap)cur.get(c = Integer.valueOf(s.charAt(i)))) != null; ++i) {
            String r = (String)map.get(null);
            if (r != null) {
                lastMatch = i;
                match = r;
            }
            cur = map;
        }
        if (match == null) {
            sb.append(s.substring(start, start + 1));
        } else {
            sb.append(match);
        }
        return lastMatch + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String dictpath = System.getProperty(BOS_SC2TC_DICT);
        InputStream in = null;
        if (dictpath != null) {
            try {
                in = new FileInputStream(dictpath);
            }
            catch (Exception ex) {
                in = null;
            }
        }
        try {
            String s1;
            if (in == null) {
                in = STConverter.class.getResourceAsStream("sc2tc");
            }
            STConverter.readChar(in);
            while ((s1 = STConverter.readString(in)) != null) {
                String s2 = STConverter.readString(in);
                s2t.add(s1, s2);
                t2s.add(s2, s1);
            }
        }
        catch (IOException e) {
            try {
                log.error(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
            IOUtils.close((Closeable)in);
        }
        IOUtils.close((Closeable)in);
    }
}

